/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PCMFileWriter {
    private String TAG = "PCMFileWriter";
    private FileOutputStream fos;
    private FileChannel channel;
    private byte[] localFrame;

    public PCMFileWriter(String fileName, int sampleRate, int channels, int biteFormat) {
        this.createFileToSDCard(fileName, sampleRate, channels, biteFormat);
    }

    public PCMFileWriter(String fileName) {
        this.createFileToSDCard(fileName, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileToSDCard(String filename, int sampleRate, int channels, int biteFormat) {
        try {
            File parent_path = Environment.getExternalStorageDirectory();
            File dir = new File(parent_path.getAbsoluteFile(), "RC_RTC");
            dir.mkdir();
            String dtf = new SimpleDateFormat("MM_dd_HH-mm-ss").format(new Date());
            StringBuffer stringBuffer = new StringBuffer(dtf).append("_").append(filename);
            if (sampleRate != 0 && channels != 0 && biteFormat != 0) {
                stringBuffer.append("-").append(sampleRate).append("-").append(channels).append("-").append(biteFormat * 8);
            }
            filename = stringBuffer.append(".pcm").toString();
            File file = new File(dir.getAbsoluteFile(), filename);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.fos = new FileOutputStream(file);
            this.channel = this.fos.getChannel();
            Log.d((String)this.TAG, (String)("kurt create file success " + file.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)"kurt create file failed");
        }
    }

    public void write(ByteBuffer buffer) {
        try {
            if (this.channel != null) {
                buffer.rewind();
                ByteBuffer sliceBuffer = buffer.slice();
                this.channel.write(sliceBuffer);
            }
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)"kurt write file failed");
        }
    }

    public void write(byte[] buffer) {
        try {
            if (this.channel != null) {
                this.channel.write(ByteBuffer.wrap(buffer));
            }
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)"kurt write file failed");
        }
    }

    public void close() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
            }
            this.localFrame = null;
            this.channel = null;
            this.fos = null;
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)"kurt close file failed");
        }
    }
}

