/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.c;
import com.tencent.liteav.videobase.egl.d;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.bg;
import com.tencent.liteav.videoproducer.encoder.r;
import com.tencent.liteav.videoproducer.encoder.s;
import com.tencent.liteav.videoproducer.encoder.t;
import com.tencent.liteav.videoproducer.encoder.u;
import com.tencent.liteav.videoproducer.encoder.v;
import com.tencent.liteav.videoproducer.encoder.y;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import java.util.concurrent.TimeUnit;

public final class q
implements bg,
bg.a {
    private final String a;
    @NonNull
    private final IVideoReporter b;
    @NonNull
    private final Size c = new Size(0, 0);
    private final y d;
    private final b e = new b();
    private final VideoProducerDef.StreamType f;
    private Surface g;
    private EGLCore h;
    private j i;
    private VideoEncodeParams j;
    private long k = 0L;
    private volatile Handler l;
    private volatile bg.a m;
    private c n;
    private final k o;

    public q(Bundle bundle, @NonNull IVideoReporter iVideoReporter, VideoProducerDef.StreamType streamType) {
        this.d = new y(bundle, iVideoReporter, streamType);
        this.b = iVideoReporter;
        this.o = new k("hwEn" + this.hashCode());
        this.f = streamType;
        this.a = "HardwareVideoEncoder_" + (Object)((Object)streamType) + "_" + this.hashCode();
    }

    @Override
    public final void initialize() {
        LiteavLog.d(this.a, "initialize");
        this.l = new Handler(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
        this.n = new c(this.l.getLooper());
        this.d.a();
    }

    @Override
    public final void setServerConfig(ServerVideoProducerConfig serverConfig) {
        this.d.a(serverConfig);
    }

    @Override
    public final boolean start(VideoEncodeParams params, bg.a listener) {
        if (this.g != null) {
            LiteavLog.e(this.a, "Encoder has started");
            return false;
        }
        LiteavLog.i(this.a, "Start hw video encoder. %s", params);
        this.m = listener;
        Pair<Surface, Size> pair = this.d.a(params, this);
        this.g = (Surface)pair.first;
        this.c.set((Size)pair.second);
        this.j = new VideoEncodeParams(params);
        return this.g != null;
    }

    @Override
    public final void encodeFrame(PixelFrame frame) {
        boolean bl2;
        if (frame == null) {
            return;
        }
        Object object = frame.getGLContext();
        c c2 = this.n;
        if (object == null) {
            bl2 = true;
        } else {
            boolean bl3 = !CommonUtil.equals(c2.c, object);
            c2.c = object;
            bl2 = !bl3;
        }
        if (!bl2) {
            this.a();
        }
        if (this.h == null && !this.a(frame.getGLContext(), this.g)) {
            return;
        }
        try {
            this.h.makeCurrent();
            this.o.a(frame);
            if (frame.getRotation() == Rotation.b || frame.getRotation() == Rotation.d) {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorHorizontal(!pixelFrame.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame = frame;
                pixelFrame.setMirrorVertical(!pixelFrame.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.c.width, this.c.height);
            if (this.i != null) {
                this.i.a(frame, GLConstants.GLScaleType.a, null);
            }
            this.d.a(frame.getTimestamp());
            if (frame.getTimestamp() < this.k) {
                LiteavLog.e(this.a, "timestamp is not increase. pre: " + this.k + ", cur: " + frame.getTimestamp());
            }
            this.k = frame.getTimestamp();
            this.h.setPresentationTime(TimeUnit.MILLISECONDS.toNanos(frame.getTimestamp()));
            this.h.swapBuffers();
            return;
        }
        catch (f f2) {
            g.c c3 = g.c.d;
            this.b.notifyWarning(c3, "VideoEncode: swapBuffer error, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage(), new Object[0]);
            this.d.a(f2.getMessage());
            LiteavLog.e(this.e.a("EGLError"), this.a, "makeCurrent failed.", f2);
            return;
        }
    }

    private boolean a(Object object, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.e.a("SurfaceNull"), this.a, "init opengl: surface is null.", new Object[0]);
            return false;
        }
        LiteavLog.d(this.e.a("initGL"), this.a, "initOpenGLComponents", new Object[0]);
        this.h = new EGLCore();
        try {
            this.h.initialize(object, surface, this.c.width, this.c.height);
        }
        catch (f f2) {
            g.c c2 = g.c.a;
            this.b.notifyWarning(c2, "VideoEncode: create EGLCore failed, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage(), new Object[0]);
            this.b.updateStatus(com.tencent.liteav.videobase.videobase.h.N, this.f.mValue, c2.mValue);
            this.d.a(f2.getMessage());
            LiteavLog.e(this.e.a("initError"), this.a, "create EGLCore failed.", f2);
            this.h = null;
            return false;
        }
        this.o.a((e)null);
        this.o.a(this.c.width, this.c.height);
        this.i = new j(this.c.width, this.c.height);
        return true;
    }

    @Override
    public final void signalEndOfStream() {
        this.d.b();
    }

    @Override
    public final void stop() {
        LiteavLog.d(this.a, "stop");
        this.a();
        if (this.g != null) {
            this.g.release();
            this.g = null;
        }
        this.d.c();
        this.m = null;
    }

    private void a() {
        if (this.h == null) {
            return;
        }
        LiteavLog.d(this.e.a("uninitGL"), this.a, "uninitOpenGLComponents", new Object[0]);
        try {
            this.h.makeCurrent();
            if (this.i != null) {
                this.i.a();
                this.i = null;
            }
            this.o.a();
        }
        catch (f f2) {
            LiteavLog.e(this.e.a("uninitError"), this.a, "makeCurrent failed.", f2);
        }
        EGLCore.destroy(this.h);
        this.h = null;
    }

    @Override
    public final void restartIDRFrame() {
    }

    @Override
    public final void setRPSIFrameFPS(int fps) {
    }

    @Override
    public final void setRPSNearestREFSize(int referenceSize) {
    }

    @Override
    public final void ackRPSRecvFrameIndex(int ackedFrameId, int bitmap) {
    }

    @Override
    public final void setBitrate(int bitrate) {
        LiteavLog.i(this.a, "SetBitrate ".concat(String.valueOf(bitrate)));
        if (this.j != null) {
            this.j.bitrate = bitrate;
        }
        this.d.a(bitrate);
    }

    @Override
    public final void setFps(int fps) {
    }

    @Override
    public final VideoEncodeParams getEncodeParams() {
        return new VideoEncodeParams(this.j);
    }

    @Override
    public final void uninitialize() {
        LiteavLog.d(this.a, "uninitialize");
        this.d.d();
        c c2 = this.n;
        c2.a.post(com.tencent.liteav.videobase.egl.d.a(c2));
        this.l = null;
    }

    @Override
    public final VideoEncoderDef.a getEncoderType() {
        return VideoEncoderDef.a.a;
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        this.o.a = listener;
    }

    private void a(Runnable runnable) {
        Handler handler = this.l;
        if (handler != null) {
            if (handler.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            handler.post(runnable);
        }
    }

    @Override
    public final void onRequestRestart() {
        q q2 = this;
        q2.a(r.a(q2));
    }

    @Override
    public final void onEncodeError(String message) {
        q q2 = this;
        q2.a(s.a(q2, message));
    }

    @Override
    public final void onRpsFrameRateChanged(boolean isRpsIDRMode, int idrFps) {
    }

    @Override
    public final void onOutputFormatChanged(MediaFormat format) {
        q q2 = this;
        q2.a(t.a(q2, format));
    }

    @Override
    public final void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
        q q2 = this;
        q2.a(u.a(q2, nal, isEos));
    }

    @Override
    public final void onEncodedFail(g.a code) {
        q q2 = this;
        q2.a(v.a(q2, code));
    }

    static /* synthetic */ void a(q q2, g.a a2) {
        bg.a a3 = q2.m;
        if (a3 != null) {
            a3.onEncodedFail(a2);
        }
    }

    static /* synthetic */ void a(q q2, EncodedVideoFrame encodedVideoFrame, boolean bl2) {
        bg.a a2 = q2.m;
        if (a2 != null) {
            a2.onEncodedNAL(encodedVideoFrame, bl2);
        }
    }

    static /* synthetic */ void a(q q2, MediaFormat mediaFormat) {
        bg.a a2 = q2.m;
        if (a2 != null) {
            a2.onOutputFormatChanged(mediaFormat);
        }
    }

    static /* synthetic */ void a(q q2, String string) {
        bg.a a2 = q2.m;
        if (a2 != null) {
            a2.onEncodeError(string);
        }
    }

    static /* synthetic */ void a(q q2) {
        bg.a a2 = q2.m;
        if (a2 != null) {
            a2.onRequestRestart();
        }
    }
}

