/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlRGBFilter
extends GlFilter {
    private static final String RGB_FRAGMENT_SHADER = "precision mediump float; varying vec2 vTextureCoord;\n  \n uniform lowp sampler2D sTexture;\n  uniform highp float red;\n  uniform highp float green;\n  uniform highp float blue;\n  \n  void main()\n  {\n      highp vec4 textureColor = texture2D(sTexture, vTextureCoord);\n      \n      gl_FragColor = vec4(textureColor.r * red, textureColor.g * green, textureColor.b * blue, 1.0);\n  }\n";
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;

    public GlRGBFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", RGB_FRAGMENT_SHADER);
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    @Override
    public void onDraw() {
        GLES20.glUniform1f((int)this.getHandle("red"), (float)this.red);
        GLES20.glUniform1f((int)this.getHandle("green"), (float)this.green);
        GLES20.glUniform1f((int)this.getHandle("blue"), (float)this.blue);
    }
}

