/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceScrollerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXScroller
extends WXBaseScroller {
    public static final String DIRECTION = "direction";
    protected int mOrientation = 1;
    private List<WXComponent> mRefreshs = new ArrayList<WXComponent>();
    private int mChildrenLayoutOffset = 0;
    private boolean mForceLoadmoreNextTime = false;
    private int mOffsetAccuracy = 10;
    private Point mLastReport = new Point(-1, -1);
    private boolean mHasAddScrollEvent = false;
    private Boolean mIslastDirectionRTL;
    private static final int SWIPE_MIN_DISTANCE = 5;
    private static final int SWIPE_THRESHOLD_VELOCITY = 300;
    private int mActiveFeature = 0;
    private ScrollStartEndHelper mScrollStartEndHelper;
    private GestureDetector mGestureDetector;
    private int pageSize = 0;
    private boolean pageEnable = false;
    private boolean mIsHostAttachedToWindow = false;
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener;
    private boolean mlastDirectionRTL = false;
    private Map<String, AppearanceHelper> mAppearanceComponents = new HashMap<String, AppearanceHelper>();
    private Map<String, Map<String, WXComponent>> mStickyMap = new HashMap<String, Map<String, WXComponent>>();
    private FrameLayout mRealView;
    private FrameLayout mScrollerView;
    private int mContentHeight = 0;
    private int mContentWidth = 0;
    private WXStickyHelper stickyHelper;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean isScrollable = true;

    @Deprecated
    public WXScroller(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public WXScroller(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.stickyHelper = new WXStickyHelper(this);
        instance.getApmForInstance().updateDiffStats("wxScrollerCount", 1.0);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mScrollerView;
    }

    @Override
    public void createViewImpl() {
        super.createViewImpl();
        for (int i = 0; i < this.mRefreshs.size(); ++i) {
            WXComponent component = this.mRefreshs.get(i);
            component.createViewImpl();
            this.checkRefreshOrLoading(component);
        }
    }

    @Override
    public ViewGroup getInnerView() {
        if (this.getHostView() == null) {
            return null;
        }
        if (this.getHostView() instanceof BounceScrollerView) {
            return (ViewGroup)((BounceScrollerView)((Object)this.getHostView())).getInnerView();
        }
        return (ViewGroup)this.getHostView();
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (ScrollStartEndHelper.isScrollEvent(type) && this.getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            if (this.getInnerView() instanceof WXScrollView) {
                ((WXScrollView)this.getInnerView()).addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                    @Override
                    public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
                        WXScroller.this.getScrollStartEndHelper().onScrolled(x, y);
                        if (!WXScroller.this.getEvents().contains("scroll")) {
                            return;
                        }
                        if (WXScroller.this.shouldReport(x, y)) {
                            WXScroller.this.fireScrollEvent(scrollView.getContentFrame(), x, y, oldx, oldy);
                        }
                    }

                    @Override
                    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScroll(WXScrollView scrollView, int x, int y) {
                    }
                });
            } else if (this.getInnerView() instanceof WXHorizontalScrollView) {
                ((WXHorizontalScrollView)this.getInnerView()).addScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                    @Override
                    public void onScrollChanged(WXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                        WXScroller.this.getScrollStartEndHelper().onScrolled(x, y);
                        if (!WXScroller.this.getEvents().contains("scroll")) {
                            return;
                        }
                        if (WXScroller.this.shouldReport(x, y)) {
                            WXScroller.this.fireScrollEvent(scrollView.getContentFrame(), x, y, oldx, oldy);
                        }
                    }
                });
            }
        }
    }

    private void fireScrollEvent(Rect contentFrame, int x, int y, int oldx, int oldy) {
        this.fireEvent("scroll", this.getScrollEvent(x, y));
    }

    @Override
    public Map<String, Object> getScrollEvent(int x, int y) {
        Rect contentFrame = new Rect();
        if (this.getInnerView() instanceof WXScrollView) {
            contentFrame = ((WXScrollView)this.getInnerView()).getContentFrame();
        } else if (this.getInnerView() instanceof WXHorizontalScrollView) {
            contentFrame = ((WXHorizontalScrollView)this.getInnerView()).getContentFrame();
        }
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(2);
        HashMap<String, Float> contentOffset = new HashMap<String, Float>(2);
        float viewport = this.getInstance().getInstanceViewPortWidthWithFloat();
        contentSize.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.width(), viewport)));
        contentSize.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float)contentFrame.height(), viewport)));
        contentOffset.put("x", Float.valueOf(-WXViewUtils.getWebPxByWidth((float)x, viewport)));
        contentOffset.put("y", Float.valueOf(-WXViewUtils.getWebPxByWidth((float)y, viewport)));
        event.put("contentSize", contentSize);
        event.put("contentOffset", contentOffset);
        return event;
    }

    private boolean shouldReport(int x, int y) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        if (this.mOrientation == 0 && Math.abs(x - this.mLastReport.x) >= this.mOffsetAccuracy) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        if (this.mOrientation == 1 && Math.abs(y - this.mLastReport.y) >= this.mOffsetAccuracy) {
            this.mLastReport.x = x;
            this.mLastReport.y = y;
            return true;
        }
        return false;
    }

    @Override
    public void addSubView(View child, int index) {
        if (child == null || this.mRealView == null) {
            return;
        }
        if (child instanceof WXBaseRefreshLayout) {
            return;
        }
        int count = this.mRealView.getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.mRealView.addView(child);
        } else {
            this.mRealView.addView(child, index);
        }
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        int listSize;
        if (this.mChildrenLayoutOffset == 0 && (listSize = this.mRefreshs.size()) > 0) {
            for (int i = 0; i < listSize; ++i) {
                WXComponent child = this.mRefreshs.get(i);
                this.mChildrenLayoutOffset += child.getLayoutTopOffsetForSibling();
            }
        }
        return this.mChildrenLayoutOffset;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        if (child instanceof WXBaseRefresh && this.checkRefreshOrLoading(child)) {
            this.mRefreshs.add(child);
        }
        super.addChild(child, index);
    }

    private boolean checkRefreshOrLoading(final WXComponent child) {
        Runnable runnable;
        boolean result = false;
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnRefreshListener((WXRefresh)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setHeaderView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
            result = true;
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnLoadingListener((WXLoading)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setFooterView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
            result = true;
        }
        return result;
    }

    @Override
    public void remove(WXComponent child, boolean destory) {
        super.remove(child, destory);
        if (child instanceof WXLoading) {
            ((BaseBounceView)((Object)this.getHostView())).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BaseBounceView)((Object)this.getHostView())).removeHeaderView(child);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mAppearanceComponents != null) {
            this.mAppearanceComponents.clear();
        }
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.mOnAttachStateChangeListener != null && this.getInnerView() != null) {
            this.getInnerView().removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
        if (this.getInnerView() != null && this.getInnerView() instanceof IWXScroller) {
            ((IWXScroller)this.getInnerView()).destroy();
        }
    }

    @Override
    public void setMarginsSupportRTL(ViewGroup.MarginLayoutParams lp, int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            lp.setMargins(left, top, right, bottom);
            lp.setMarginStart(left);
            lp.setMarginEnd(right);
        } else if (lp instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams lp_frameLayout = (FrameLayout.LayoutParams)lp;
            if (this.isLayoutRTL()) {
                lp_frameLayout.gravity = 53;
                lp.setMargins(right, top, left, bottom);
            } else {
                lp_frameLayout.gravity = 51;
                lp.setMargins(left, top, right, bottom);
            }
        } else {
            lp.setMargins(left, top, right, bottom);
        }
    }

    @Override
    public void setLayout(WXComponent component) {
        if (TextUtils.isEmpty((CharSequence)component.getComponentType()) || TextUtils.isEmpty((CharSequence)component.getRef()) || component.getLayoutPosition() == null || component.getLayoutSize() == null) {
            return;
        }
        if (component.getHostView() != null) {
            int layoutDirection = component.isLayoutRTL() ? 1 : 0;
            ViewCompat.setLayoutDirection(component.getHostView(), (int)layoutDirection);
        }
        super.setLayout(component);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenW = WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            int weexW = WXViewUtils.getWeexWidth(this.getInstanceId());
            measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? -1 : width;
            measureOutput.height = height;
        } else {
            int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
            measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? -1 : height;
            measureOutput.width = width;
        }
        return measureOutput;
    }

    @Override
    protected ViewGroup initComponentHostView(@NonNull Context context) {
        Object host;
        String scroll;
        if (this.getAttrs().isEmpty()) {
            scroll = "vertical";
        } else {
            float aFloat;
            float realPxByWidth;
            scroll = this.getAttrs().getScrollDirection();
            Object o = this.getAttrs().get("pagingEnabled");
            this.pageEnable = o != null && Boolean.parseBoolean(o.toString());
            Object pageSize = this.getAttrs().get("pageSize");
            if (pageSize != null && (realPxByWidth = WXViewUtils.getRealPxByWidth(aFloat = WXUtils.getFloat(pageSize), this.getInstance().getInstanceViewPortWidthWithFloat())) != 0.0f) {
                this.pageSize = (int)realPxByWidth;
            }
        }
        if ("horizontal".equals(scroll)) {
            this.mOrientation = 0;
            final WXHorizontalScrollView scrollView = new WXHorizontalScrollView(context);
            this.mRealView = new FrameLayout(context);
            scrollView.setScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                @Override
                public void onScrollChanged(WXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                    WXScroller.this.procAppear(x, y, oldx, oldy);
                    WXScroller.this.onLoadMore((FrameLayout)scrollView, x, y);
                }
            });
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            scrollView.setHorizontalScrollBarEnabled(false);
            this.mScrollerView = scrollView;
            final WXScroller component = this;
            final View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View view, final int left, int top, final int right, int bottom, final int oldLeft, int oldTop, final int oldRight, int oldBottom) {
                    View frameLayout = view;
                    scrollView.post(new Runnable(){

                        @Override
                        public void run() {
                            int oldWidth;
                            int width;
                            int changedWidth;
                            if (WXScroller.this.mIslastDirectionRTL != null && WXScroller.this.isLayoutRTL() != WXScroller.this.mIslastDirectionRTL.booleanValue()) {
                                int currentX = WXScroller.this.getScrollX();
                                int totalWidth = WXScroller.this.getInnerView().getChildAt(0).getWidth();
                                int displayWidth = WXScroller.this.getInnerView().getMeasuredWidth();
                                scrollView.scrollTo(totalWidth - currentX - displayWidth, component.getScrollY());
                            } else if (WXScroller.this.isLayoutRTL() && (changedWidth = (width = right - left) - (oldWidth = oldRight - oldLeft)) != 0) {
                                scrollView.scrollBy(changedWidth, component.getScrollY());
                            }
                            WXScroller.this.mIslastDirectionRTL = new Boolean(WXScroller.this.isLayoutRTL());
                        }
                    });
                }
            };
            this.mRealView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.addOnLayoutChangeListener(listener);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnLayoutChangeListener(listener);
                }
            });
            if (this.pageEnable) {
                this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new MyGestureDetector(scrollView));
                scrollView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        if (WXScroller.this.pageSize == 0) {
                            WXScroller.this.pageSize = v.getMeasuredWidth();
                        }
                        if (WXScroller.this.mGestureDetector.onTouchEvent(event)) {
                            return true;
                        }
                        if (event.getAction() == 1 || event.getAction() == 3) {
                            int scrollX = WXScroller.this.getScrollX();
                            int featureWidth = WXScroller.this.pageSize;
                            WXScroller.this.mActiveFeature = (scrollX + featureWidth / 2) / featureWidth;
                            int scrollTo = WXScroller.this.mActiveFeature * featureWidth;
                            scrollView.smoothScrollTo(scrollTo, 0);
                            return true;
                        }
                        return false;
                    }
                });
            }
            host = scrollView;
        } else {
            this.mOrientation = 1;
            BounceScrollerView scrollerView = new BounceScrollerView(context, this.mOrientation, this);
            this.mRealView = new FrameLayout(context);
            WXScrollView innerView = (WXScrollView)scrollerView.getInnerView();
            innerView.addScrollViewListener(this);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.mScrollerView = innerView;
            innerView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            innerView.setVerticalScrollBarEnabled(true);
            innerView.setNestedScrollingEnabled(WXUtils.getBoolean(this.getAttrs().get("nestedScrollingEnabled"), true));
            innerView.addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                @Override
                public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
                }

                @Override
                public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
                }

                @Override
                public void onScrollStopped(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrollStateChanged((View)scrollView, x, y, 0);
                        }
                    }
                    WXScroller.this.getScrollStartEndHelper().onScrollStateChanged(0);
                }

                @Override
                public void onScroll(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            if (listener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)listener)).isNeedScroller(WXScroller.this.getRef(), null)) continue;
                                listener.onScrolled((View)scrollView, x, y);
                                continue;
                            }
                            listener.onScrolled((View)scrollView, x, y);
                        }
                    }
                }
            });
            host = scrollerView;
        }
        host.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                WXScroller.this.procAppear(0, 0, 0, 0);
                Object view = WXScroller.this.getHostView();
                if (view == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                WXScroller.this.mIsHostAttachedToWindow = true;
                WXScroller.this.procAppear(WXScroller.this.getScrollX(), WXScroller.this.getScrollY(), WXScroller.this.getScrollX(), WXScroller.this.getScrollY());
            }

            public void onViewDetachedFromWindow(View v) {
                WXScroller.this.mIsHostAttachedToWindow = false;
                WXScroller.this.dispatchDisappearEvent();
            }
        };
        host.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        return host;
    }

    @Override
    public int getScrollY() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollX();
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public Map<String, Map<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "offsetAccuracy": {
                int accuracy = WXUtils.getInteger(param, 10);
                this.setOffsetAccuracy(accuracy);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.getInnerView() == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.getInnerView().setVerticalScrollBarEnabled(show);
        } else {
            this.getInnerView().setHorizontalScrollBarEnabled(show);
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        this.isScrollable = scrollable;
        ViewGroup hostView = this.getInnerView();
        if (hostView instanceof WXHorizontalScrollView) {
            ((WXHorizontalScrollView)hostView).setScrollable(scrollable);
        } else if (hostView instanceof WXScrollView) {
            ((WXScrollView)hostView).setScrollable(scrollable);
        }
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int accuracy) {
        float realPx = WXViewUtils.getRealPxByWidth((float)accuracy, this.getInstance().getInstanceViewPortWidthWithFloat());
        this.mOffsetAccuracy = (int)realPx;
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setWatch(0, component, true);
    }

    private void setWatch(int event, WXComponent component, boolean isWatch) {
        AppearanceHelper item = this.mAppearanceComponents.get(component.getRef());
        if (item == null) {
            item = new AppearanceHelper(component);
            this.mAppearanceComponents.put(component.getRef(), item);
        }
        item.setWatchEvent(event, isWatch);
        this.procAppear(0, 0, 0, 0);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setWatch(0, component, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, false);
    }

    @Override
    public void scrollTo(WXComponent component, Map<String, Object> options) {
        float offsetFloat = 0.0f;
        boolean smooth = true;
        if (options != null) {
            String offset = options.get("offset") == null ? "0" : options.get("offset").toString();
            smooth = WXUtils.getBoolean(options.get("animated"), true);
            if (offset != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offset), this.getInstance().getInstanceViewPortWidthWithFloat());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
        }
        if (this.pageEnable) {
            this.mActiveFeature = this.mChildren.indexOf(component);
        }
        int viewYInScroller = component.getAbsoluteY() - this.getAbsoluteY();
        int viewXInScroller = 0;
        if (this.isLayoutRTL()) {
            if (component.getParent() != null && component.getParent() == this) {
                if (this.getInnerView().getChildCount() > 0) {
                    int totalWidth = this.getInnerView().getChildAt(0).getWidth();
                    int displayWidth = this.getInnerView().getMeasuredWidth();
                    viewXInScroller = totalWidth - (component.getAbsoluteX() - this.getAbsoluteX()) - displayWidth;
                } else {
                    viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
                }
            } else {
                int displayWidth = this.getInnerView().getMeasuredWidth();
                viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX() - displayWidth + (int)component.getLayoutWidth();
            }
            offsetFloat = -offsetFloat;
        } else {
            viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
        }
        this.scrollBy(viewXInScroller - this.getScrollX() + (int)offsetFloat, viewYInScroller - this.getScrollY() + (int)offsetFloat, smooth);
    }

    public void scrollBy(int x, int y) {
        this.scrollBy(x, y, false);
    }

    public void scrollBy(final int x, final int y, final boolean smooth) {
        if (this.getInnerView() == null) {
            return;
        }
        this.getInnerView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WXScroller.this.mOrientation == 1) {
                    if (smooth) {
                        ((WXScrollView)WXScroller.this.getInnerView()).smoothScrollBy(0, y);
                    } else {
                        ((WXScrollView)WXScroller.this.getInnerView()).scrollBy(0, y);
                    }
                } else if (smooth) {
                    ((WXHorizontalScrollView)WXScroller.this.getInnerView()).smoothScrollBy(x, 0);
                } else {
                    ((WXHorizontalScrollView)WXScroller.this.getInnerView()).scrollBy(x, 0);
                }
                WXScroller.this.getInnerView().invalidate();
            }
        }, 16L);
    }

    @Override
    public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
        this.procAppear(x, y, oldx, oldy);
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        if (this.containsEvent("appear") || this.containsEvent("disappear")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(DIRECTION, direction);
            this.fireEvent(wxEventType, params);
        }
    }

    private void procAppear(int x, int y, int oldx, int oldy) {
        String direction;
        if (!this.mIsHostAttachedToWindow) {
            return;
        }
        int moveY = y - oldy;
        int moveX = x - oldx;
        String string2 = moveY > 0 ? "up" : (direction = moveY < 0 ? "down" : null);
        if (this.mOrientation == 0 && moveX != 0) {
            direction = moveX > 0 ? "right" : "left";
        }
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearanceComponents.entrySet()) {
            boolean visible;
            int result;
            AppearanceHelper helper = item.getValue();
            if (!helper.isWatch() || (result = helper.setAppearStatus(visible = this.checkItemVisibleInScroller(helper.getAwareChild()))) == 0) continue;
            helper.getAwareChild().notifyAppearStateChange(result == 1 ? "appear" : "disappear", direction);
        }
    }

    private boolean checkItemVisibleInScroller(WXComponent component) {
        boolean visible = false;
        while (component != null && !(component instanceof WXScroller)) {
            if (component.getParent() instanceof WXScroller) {
                int offsetTop;
                int offsetLeft;
                visible = this.mOrientation == 0 ? (float)(offsetLeft = (int)component.getLayoutPosition().getLeft() - this.getScrollX()) > 0.0f - component.getLayoutWidth() && (float)offsetLeft < this.getLayoutWidth() : (float)(offsetTop = (int)component.getLayoutPosition().getTop() - this.getScrollY()) > 0.0f - component.getLayoutHeight() && (float)offsetTop < this.getLayoutHeight();
            }
            component = component.getParent();
        }
        return visible;
    }

    private void dispatchDisappearEvent() {
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearanceComponents.entrySet()) {
            int result;
            AppearanceHelper helper = item.getValue();
            if (!helper.isWatch() || (result = helper.setAppearStatus(false)) == 0) continue;
            helper.getAwareChild().notifyAppearStateChange(result == 1 ? "appear" : "disappear", "");
        }
    }

    @Override
    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScroll(WXScrollView scrollView, int x, int y) {
        this.onLoadMore((FrameLayout)scrollView, x, y);
    }

    protected void onLoadMore(FrameLayout scrollView, int x, int y) {
        try {
            String offset = this.getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                offset = String.valueOf(1);
            }
            int offsetInt = (int)WXViewUtils.getRealPxByWidth(Float.parseFloat(offset), this.getInstance().getInstanceViewPortWidthWithFloat());
            if (scrollView instanceof WXHorizontalScrollView) {
                int contentWidth = scrollView.getChildAt(0).getWidth();
                int offScreenX = contentWidth - x - scrollView.getWidth();
                if (offScreenX < offsetInt && (this.mContentWidth != contentWidth || this.mForceLoadmoreNextTime)) {
                    this.fireEvent("loadmore");
                    this.mContentWidth = contentWidth;
                    this.mForceLoadmoreNextTime = false;
                }
            } else {
                int scrollerH;
                int contentH = scrollView.getChildAt(0).getHeight();
                int offScreenY = contentH - y - (scrollerH = scrollView.getHeight());
                if (offScreenY < offsetInt) {
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
                    }
                    if (this.mContentHeight != contentH || this.mForceLoadmoreNextTime) {
                        this.fireEvent("loadmore");
                        this.mContentHeight = contentH;
                        this.mForceLoadmoreNextTime = false;
                    }
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d("[WXScroller-onScroll] ", e);
        }
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            this.mScrollStartEndHelper = new ScrollStartEndHelper(this);
        }
        return this.mScrollStartEndHelper;
    }

    class MyGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private final WXHorizontalScrollView scrollView;

        public WXHorizontalScrollView getScrollView() {
            return this.scrollView;
        }

        MyGestureDetector(WXHorizontalScrollView horizontalScrollView) {
            this.scrollView = horizontalScrollView;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            int mItems = WXScroller.this.mChildren.size();
            try {
                if (e1.getX() - e2.getX() > 5.0f && Math.abs(velocityX) > 300.0f) {
                    int featureWidth = WXScroller.this.pageSize;
                    WXScroller.this.mActiveFeature = WXScroller.this.mActiveFeature < mItems - 1 ? WXScroller.this.mActiveFeature + 1 : mItems - 1;
                    this.scrollView.smoothScrollTo(WXScroller.this.mActiveFeature * featureWidth, 0);
                    return true;
                }
                if (e2.getX() - e1.getX() > 5.0f && Math.abs(velocityX) > 300.0f) {
                    int featureWidth = WXScroller.this.pageSize;
                    WXScroller.this.mActiveFeature = WXScroller.this.mActiveFeature > 0 ? WXScroller.this.mActiveFeature - 1 : 0;
                    this.scrollView.smoothScrollTo(WXScroller.this.mActiveFeature * featureWidth, 0);
                    return true;
                }
            }
            catch (Exception e) {
                WXLogUtils.e("There was an error processing the Fling event:" + e.getMessage());
            }
            return false;
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            instance.setUseScroller(true);
            return new WXScroller(instance, parent, basicComponentData);
        }
    }
}

