/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.WeakRunnable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BindingXPropertyInterceptor {
    private final Handler sUIHandler = new Handler(Looper.getMainLooper());
    private final LinkedList<IPropertyUpdateInterceptor> mPropertyInterceptors = new LinkedList();
    private static BindingXPropertyInterceptor sInstance = new BindingXPropertyInterceptor();

    private BindingXPropertyInterceptor() {
    }

    @NonNull
    public static BindingXPropertyInterceptor getInstance() {
        return sInstance;
    }

    public void addInterceptor(@Nullable IPropertyUpdateInterceptor interceptor) {
        if (interceptor != null) {
            this.mPropertyInterceptors.add(interceptor);
        }
    }

    public boolean removeInterceptor(@Nullable IPropertyUpdateInterceptor interceptor) {
        if (interceptor != null) {
            return this.mPropertyInterceptors.remove(interceptor);
        }
        return false;
    }

    public void clear() {
        this.mPropertyInterceptors.clear();
    }

    public void performIntercept(final @Nullable View targetView, final @NonNull String propertyName, final @NonNull Object propertyValue, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config, final Object ... extension) {
        if (this.mPropertyInterceptors.isEmpty()) {
            return;
        }
        this.sUIHandler.post((Runnable)new WeakRunnable(new Runnable(){

            @Override
            public void run() {
                for (IPropertyUpdateInterceptor interceptor : BindingXPropertyInterceptor.this.mPropertyInterceptors) {
                    interceptor.updateView(targetView, propertyName, propertyValue, translator, config, extension);
                }
            }
        }));
    }

    public void clearCallbacks() {
        this.sUIHandler.removeCallbacksAndMessages(null);
    }

    @NonNull
    public List<IPropertyUpdateInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.mPropertyInterceptors);
    }

    public static interface IPropertyUpdateInterceptor {
        public boolean updateView(@Nullable View var1, @NonNull String var2, @NonNull Object var3, @NonNull PlatformManager.IDeviceResolutionTranslator var4, @NonNull Map<String, Object> var5, Object ... var6);
    }
}

