/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXSwitchView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

@Component(lazyload=false)
public class WXSwitch
extends WXComponent<WXSwitchView> {
    private CompoundButton.OnCheckedChangeListener mListener;

    @Deprecated
    public WXSwitch(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, isLazy, basicComponentData);
    }

    public WXSwitch(final WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
        this.setContentBoxMeasurement(new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                this.mMeasureWidth = 0.0f;
                this.mMeasureHeight = 0.0f;
                try {
                    WXSwitchView wxSwitchView = new WXSwitchView(instance.getContext());
                    int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    int widthSpec = Float.isNaN(width) ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)((int)width), (int)Integer.MIN_VALUE);
                    wxSwitchView.measure(widthSpec, heightSpec);
                    this.mMeasureWidth = wxSwitchView.getMeasuredWidth();
                    this.mMeasureHeight = wxSwitchView.getMeasuredHeight();
                }
                catch (RuntimeException e) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(e));
                }
            }

            @Override
            public void layoutBefore() {
            }

            @Override
            public void layoutAfter(float computedWidth, float computedHeight) {
            }
        });
    }

    @Override
    protected WXSwitchView initComponentHostView(@NonNull Context context) {
        return new WXSwitchView(context);
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (type != null && type.equals("change") && this.getHostView() != null) {
            if (this.mListener == null) {
                this.mListener = new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        HashMap<String, Object> params = new HashMap<String, Object>(2);
                        params.put("value", isChecked);
                        HashMap<String, Object> domChanges = new HashMap<String, Object>();
                        HashMap<String, String> attrsChanges = new HashMap<String, String>();
                        attrsChanges.put("checked", Boolean.toString(isChecked));
                        domChanges.put("attrs", attrsChanges);
                        WXSwitch.this.fireEvent("change", params, domChanges);
                    }
                };
            }
            ((WXSwitchView)this.getHostView()).setOnCheckedChangeListener(this.mListener);
        }
    }

    @Override
    protected void removeEventFromView(String type) {
        super.removeEventFromView(type);
        if (this.getHostView() != null && "change".equals(type)) {
            ((WXSwitchView)this.getHostView()).setOnCheckedChangeListener(null);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "checked": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setChecked(result);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="checked")
    public void setChecked(boolean checked) {
        ((WXSwitchView)this.getHostView()).setOnCheckedChangeListener(null);
        ((WXSwitchView)this.getHostView()).setChecked(checked);
        ((WXSwitchView)this.getHostView()).setOnCheckedChangeListener(this.mListener);
    }
}

