/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.common;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniModuleFactory;
import io.dcloud.feature.uniapp.common.UniModule;
import io.dcloud.feature.uniapp.common.UniModuleAnno;
import io.dcloud.feature.uniapp.utils.UniLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypeUniModuleFactory<T extends UniModule>
implements UniModuleFactory<T> {
    public static final String TAG = "TypeModuleFactory";
    Class<T> mClazz;
    Map<String, Invoker> mMethodMap;

    public TypeUniModuleFactory(Class<T> clz) {
        this.mClazz = clz;
    }

    private void generateMethodMap() {
        if (WXEnvironment.isApkDebugable()) {
            UniLogUtils.d(TAG, "extractMethodNames:" + this.mClazz.getSimpleName());
        }
        HashMap<String, Invoker> methodMap = new HashMap<String, Invoker>();
        try {
            block2: for (Method method : this.mClazz.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    Annotation methodAnnotation;
                    if (anno == null) continue;
                    if (anno instanceof UniJSMethod) {
                        methodAnnotation = (UniJSMethod)anno;
                        String name = "_".equals(methodAnnotation.alias()) ? method.getName() : methodAnnotation.alias();
                        methodMap.put(name, new MethodInvoker(method, methodAnnotation.uiThread()));
                        continue block2;
                    }
                    if (!(anno instanceof UniModuleAnno)) continue;
                    methodAnnotation = (UniModuleAnno)anno;
                    methodMap.put(method.getName(), new MethodInvoker(method, methodAnnotation.runOnUIThread()));
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            UniLogUtils.e("[WXModuleManager] extractMethodNames:", e);
        }
        this.mMethodMap = methodMap;
    }

    @Override
    public T buildInstance() throws IllegalAccessException, InstantiationException {
        return (T)((UniModule)this.mClazz.newInstance());
    }

    @Override
    public String[] getMethods() {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        Set<String> keys = this.mMethodMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodMap == null) {
            this.generateMethodMap();
        }
        return this.mMethodMap.get(name);
    }
}

