/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview.adapter;

import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.ref.WeakReference;

public class WXRecyclerViewOnScrollListener
extends RecyclerView.OnScrollListener {
    protected LAYOUT_MANAGER_TYPE layoutManagerType;
    private int[] mLastPositions;
    private int[] mFirstPositions;
    private int mLastVisibleItemPosition;
    private int mFirstVisibleItemPosition;
    private int mCurrentScrollState = 0;
    private int mDy = 0;
    private WeakReference<IOnLoadMoreListener> listener;
    private boolean isLayoutRTL = false;

    public void setLayoutRTL(boolean layoutRTL) {
        this.isLayoutRTL = layoutRTL;
    }

    public WXRecyclerViewOnScrollListener(IOnLoadMoreListener listener) {
        this.listener = new WeakReference<IOnLoadMoreListener>(listener);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        this.mCurrentScrollState = newState;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        if (visibleItemCount != 0) {
            int bottomOffset = (totalItemCount - this.mLastVisibleItemPosition - 1) * recyclerView.getHeight() / visibleItemCount;
            if (visibleItemCount > 0 && this.mCurrentScrollState == 0) {
                boolean isHorizontalScroll = recyclerView.isHorizontalScrollBarEnabled();
                if (isHorizontalScroll) {
                    View lastChildView = recyclerView.getLayoutManager().getChildAt(visibleItemCount - 1);
                    int lastPosition = recyclerView.getLayoutManager().getPosition(lastChildView);
                    if (lastChildView != null && lastPosition == totalItemCount - 1) {
                        if (this.isLayoutRTL) {
                            int lastLeft = layoutManager.getDecoratedLeft(lastChildView);
                            if (lastLeft >= -50 && this.listener != null && this.listener.get() != null) {
                                ((IOnLoadMoreListener)this.listener.get()).onLoadMore(bottomOffset);
                            }
                        } else {
                            int lastRight = layoutManager.getDecoratedRight(lastChildView);
                            if (lastRight <= recyclerView.getWidth() && this.listener != null && this.listener.get() != null) {
                                ((IOnLoadMoreListener)this.listener.get()).onLoadMore(bottomOffset);
                            }
                        }
                    }
                } else {
                    int lastBottom;
                    View view = layoutManager.getChildAt(this.mLastVisibleItemPosition);
                    if (view != null ? (lastBottom = layoutManager.getDecoratedBottom(view)) + 50 < recyclerView.getHeight() : this.mDy == 0 || this.mDy < 0) {
                        return;
                    }
                    if (this.listener != null && this.listener.get() != null) {
                        ((IOnLoadMoreListener)this.listener.get()).onLoadMore(bottomOffset);
                    }
                    this.mDy = 0;
                }
            }
        }
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (this.listener == null) {
            return;
        }
        IOnLoadMoreListener iOnLoadMoreListener = (IOnLoadMoreListener)this.listener.get();
        if (iOnLoadMoreListener != null) {
            iOnLoadMoreListener.onBeforeScroll(dx, dy);
            this.mDy = dy;
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.LINEAR;
                LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                this.mLastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
                int firstVisible = linearLayoutManager.findFirstVisibleItemPosition();
                iOnLoadMoreListener.notifyAppearStateChange(firstVisible, this.mLastVisibleItemPosition, dx, dy);
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.GRID;
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                this.mLastVisibleItemPosition = gridLayoutManager.findLastVisibleItemPosition();
                iOnLoadMoreListener.notifyAppearStateChange(gridLayoutManager.findFirstVisibleItemPosition(), this.mLastVisibleItemPosition, dx, dy);
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.STAGGERED_GRID;
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                int newSpanCount = staggeredGridLayoutManager.getSpanCount();
                if (this.mLastPositions == null || newSpanCount != this.mLastPositions.length) {
                    this.mLastPositions = new int[newSpanCount];
                }
                if (this.mFirstPositions == null || newSpanCount != this.mFirstPositions.length) {
                    this.mFirstPositions = new int[newSpanCount];
                }
                try {
                    staggeredGridLayoutManager.findFirstVisibleItemPositions(this.mFirstPositions);
                    this.mFirstVisibleItemPosition = this.findMin(this.mFirstPositions);
                    staggeredGridLayoutManager.findLastVisibleItemPositions(this.mLastPositions);
                    this.mLastVisibleItemPosition = this.findMax(this.mLastPositions);
                    iOnLoadMoreListener.notifyAppearStateChange(this.mFirstVisibleItemPosition, this.mLastVisibleItemPosition, dx, dy);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    WXLogUtils.e(e.toString());
                }
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }
}

