/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.model;

import android.content.ContentValues;
import android.os.Parcel;
import android.os.Parcelable;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FileDownloadModel
implements Parcelable {
    public static final int TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1;
    public static final int DEFAULT_CALLBACK_PROGRESS_TIMES = 100;
    private int id;
    public static final String ID = "_id";
    private String url;
    public static final String URL = "url";
    private String path;
    public static final String PATH = "path";
    private boolean pathAsDirectory;
    public static final String PATH_AS_DIRECTORY = "pathAsDirectory";
    private String filename;
    public static final String FILENAME = "filename";
    private final AtomicInteger status;
    public static final String STATUS = "status";
    private final AtomicLong soFar;
    private long total;
    public static final String SOFAR = "sofar";
    public static final String TOTAL = "total";
    private String errMsg;
    public static final String ERR_MSG = "errMsg";
    private String eTag;
    public static final String ETAG = "etag";
    private int connectionCount;
    public static final String CONNECTION_COUNT = "connectionCount";
    private boolean isLargeFile;
    public static final Parcelable.Creator<FileDownloadModel> CREATOR = new Parcelable.Creator<FileDownloadModel>(){

        public FileDownloadModel createFromParcel(Parcel source) {
            return new FileDownloadModel(source);
        }

        public FileDownloadModel[] newArray(int size) {
            return new FileDownloadModel[size];
        }
    };

    public void setId(int id) {
        this.id = id;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path, boolean pathAsDirectory) {
        this.path = path;
        this.pathAsDirectory = pathAsDirectory;
    }

    public void setStatus(byte status) {
        this.status.set(status);
    }

    public void setSoFar(long soFar) {
        this.soFar.set(soFar);
    }

    public void increaseSoFar(long increaseBytes) {
        this.soFar.addAndGet(increaseBytes);
    }

    public void setTotal(long total) {
        this.isLargeFile = total > Integer.MAX_VALUE;
        this.total = total;
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getTargetFilePath() {
        return FileDownloadUtils.getTargetFilePath(this.getPath(), this.isPathAsDirectory(), this.getFilename());
    }

    public String getTempFilePath() {
        if (this.getTargetFilePath() == null) {
            return null;
        }
        return FileDownloadUtils.getTempPath(this.getTargetFilePath());
    }

    public byte getStatus() {
        return (byte)this.status.get();
    }

    public long getSoFar() {
        return this.soFar.get();
    }

    public long getTotal() {
        return this.total;
    }

    public boolean isChunked() {
        return this.total == -1L;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isPathAsDirectory() {
        return this.pathAsDirectory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setConnectionCount(int connectionCount) {
        this.connectionCount = connectionCount;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public void resetConnectionCount() {
        this.connectionCount = 1;
    }

    public ContentValues toContentValues() {
        ContentValues cv = new ContentValues();
        cv.put(ID, Integer.valueOf(this.getId()));
        cv.put(URL, this.getUrl());
        cv.put(PATH, this.getPath());
        cv.put(STATUS, Byte.valueOf(this.getStatus()));
        cv.put(SOFAR, Long.valueOf(this.getSoFar()));
        cv.put(TOTAL, Long.valueOf(this.getTotal()));
        cv.put(ERR_MSG, this.getErrMsg());
        cv.put(ETAG, this.getETag());
        cv.put(CONNECTION_COUNT, Integer.valueOf(this.getConnectionCount()));
        cv.put(PATH_AS_DIRECTORY, Boolean.valueOf(this.isPathAsDirectory()));
        if (this.isPathAsDirectory() && this.getFilename() != null) {
            cv.put(FILENAME, this.getFilename());
        }
        return cv;
    }

    public boolean isLargeFile() {
        return this.isLargeFile;
    }

    public void deleteTaskFiles() {
        this.deleteTempFile();
        this.deleteTargetFile();
    }

    public void deleteTempFile() {
        File tempFile;
        String tempFilePath = this.getTempFilePath();
        if (tempFilePath != null && (tempFile = new File(tempFilePath)).exists()) {
            tempFile.delete();
        }
    }

    public void deleteTargetFile() {
        File targetFile;
        String targetFilePath = this.getTargetFilePath();
        if (targetFilePath != null && (targetFile = new File(targetFilePath)).exists()) {
            targetFile.delete();
        }
    }

    public String toString() {
        return FileDownloadUtils.formatString("id[%d], url[%s], path[%s], status[%d], sofar[%s], total[%d], etag[%s], %s", this.id, this.url, this.path, this.status.get(), this.soFar, this.total, this.eTag, super.toString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeString(this.url);
        dest.writeString(this.path);
        dest.writeByte(this.pathAsDirectory ? (byte)1 : 0);
        dest.writeString(this.filename);
        dest.writeByte((byte)this.status.get());
        dest.writeLong(this.soFar.get());
        dest.writeLong(this.total);
        dest.writeString(this.errMsg);
        dest.writeString(this.eTag);
        dest.writeInt(this.connectionCount);
        dest.writeByte(this.isLargeFile ? (byte)1 : 0);
    }

    public FileDownloadModel() {
        this.soFar = new AtomicLong();
        this.status = new AtomicInteger();
    }

    protected FileDownloadModel(Parcel in) {
        this.id = in.readInt();
        this.url = in.readString();
        this.path = in.readString();
        this.pathAsDirectory = in.readByte() != 0;
        this.filename = in.readString();
        this.status = new AtomicInteger(in.readByte());
        this.soFar = new AtomicLong(in.readLong());
        this.total = in.readLong();
        this.errMsg = in.readString();
        this.eTag = in.readString();
        this.connectionCount = in.readInt();
        this.isLargeFile = in.readByte() != 0;
    }
}

