/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.center.stream.RCAudioOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RCOutputStreamImpl
extends RCStreamImpl
implements RCRTCOutputStream {
    public RCOutputStreamImpl(String tag, RCRTCMediaType type, String streamId) {
        super(tag, type, streamId);
    }

    public abstract void start();

    public void stop() {
        this.setUri(null);
    }

    @Override
    public void release() {
        super.release();
    }

    public void updateMediaInfo(MediaResourceInfo info) {
        this.setUri(info.getUri());
    }

    public static List<RCOutputStreamImpl> parseOutputStreams(String userid, String json) {
        ArrayList<RCOutputStreamImpl> streams = new ArrayList<RCOutputStreamImpl>();
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = (JSONObject)array.get(i);
                    String streamId = object.getString("msid");
                    int type = object.getInt("mediaType");
                    String uri = object.getString("uri");
                    String tag = "RongCloudRTC";
                    if (object.has("tag")) {
                        tag = object.getString("tag");
                    }
                    RCRTCResourceState state = RCRTCResourceState.valueOf(object.getInt("state"));
                    RCRTCMediaType mediaType = RCRTCMediaType.getMediaType(type);
                    if (mediaType == RCRTCMediaType.APPLICATION) continue;
                    RCOutputStreamImpl stream = mediaType == RCRTCMediaType.VIDEO ? new RCVideoOutStreamImpl(tag, userid) : new RCAudioOutputStreamImpl(tag, userid);
                    stream.setUri(uri);
                    stream.setResourceState(state);
                    streams.add(stream);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return streams;
    }
}

