/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.android.vending.developer.signing.tools.extern.export;

import com.google.wireless.android.vending.developer.signing.tools.extern.export.KeystoreKey;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.annotation.Nullable;

class KeystoreHelper {
    KeystoreHelper() {
    }

    PrivateKey getPrivateKey(KeyStore keystore, KeystoreKey key) throws GeneralSecurityException {
        return this.extractPrivateKey(keystore, key.getKeyAlias(), key.getKeyPassword());
    }

    KeyStore getKeystore(KeystoreKey key) throws GeneralSecurityException, IOException {
        return this.loadKeystore(key.getKeystorePath(), key.getKeystorePassword());
    }

    public KeyStore loadKeystore(Path keystorePath, @Nullable char[] storePass) throws GeneralSecurityException, IOException {
        if (storePass == null) {
            storePass = System.console().readPassword(String.format("Enter password for store '%s':", keystorePath.getFileName()), new Object[0]);
        }
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (FileInputStream keyStoreIn = new FileInputStream(keystorePath.toFile());){
            keyStore.load(keyStoreIn, storePass);
        }
        return keyStore;
    }

    private PrivateKey extractPrivateKey(KeyStore ks, String alias, @Nullable char[] keyPass) throws GeneralSecurityException {
        if (keyPass == null) {
            keyPass = System.console().readPassword(String.format("Enter password for key '%s':", alias), new Object[0]);
        }
        String string = String.valueOf(alias);
        return Utils.checkNotNull((PrivateKey)ks.getKey(alias, keyPass), string.length() != 0 ? "No key for alias: ".concat(string) : new String("No key for alias: "));
    }

    public Certificate getCertificate(KeyStore ks, KeystoreKey key) throws KeyStoreException {
        return ks.getCertificate(key.getKeyAlias());
    }
}

