/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.wonderkiln.camerakit.utils.Size;

public class SurfaceViewContainer
extends FrameLayout {
    private Size mPreviewSize;
    private int mDisplayOrientation;

    public SurfaceViewContainer(@NonNull Context context) {
        super(context);
    }

    public SurfaceViewContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SurfaceViewContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = SurfaceViewContainer.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = SurfaceViewContainer.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (changed && this.getChildCount() > 0) {
            this.layoutChild(r - l, b - t);
        }
    }

    private void layoutChild(int width, int height) {
        View child = this.getChildAt(0);
        int previewWidth = width;
        int previewHeight = height;
        if (this.mPreviewSize != null) {
            previewWidth = this.mPreviewSize.getWidth();
            previewHeight = this.mPreviewSize.getHeight();
        }
        if (width * previewHeight > height * previewWidth) {
            int scaledChildHeight = previewHeight * width / previewWidth;
            child.layout(0, (height - scaledChildHeight) / 2, width, (height + scaledChildHeight) / 2);
        } else {
            int scaledChildWidth = previewWidth * height / previewHeight;
            child.layout((width - scaledChildWidth) / 2, 0, (width + scaledChildWidth) / 2, height);
        }
    }

    public void setPreviewSize(Size previewSize) {
        this.setPreviewSize(previewSize, this.mDisplayOrientation);
    }

    public void setPreviewSize(Size previewSize, int displayOrientation) {
        if (this.mDisplayOrientation == 0 || this.mDisplayOrientation == 180) {
            this.mPreviewSize = previewSize;
        } else if ((displayOrientation == 90 || displayOrientation == 270) && this.mDisplayOrientation != 90 && this.mDisplayOrientation != 270) {
            this.mPreviewSize = new Size(previewSize.getHeight(), previewSize.getWidth());
        }
        if (this.getChildCount() > 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    SurfaceViewContainer.this.layoutChild(SurfaceViewContainer.this.getWidth(), SurfaceViewContainer.this.getHeight());
                }
            });
        }
    }

    public void setDisplayOrientation(int displayOrientation) {
        if (this.mPreviewSize != null) {
            this.setPreviewSize(this.mPreviewSize, displayOrientation);
        } else {
            this.mDisplayOrientation = displayOrientation;
        }
    }
}

