/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.jinmingyunle.midiplaylib.R;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.midifile.MidiFileException;
import com.jinmingyunle.midiplaylib.midifile.MidiOptions;
import com.jinmingyunle.midiplaylib.midifile.Piano;
import com.jinmingyunle.midiplaylib.sheetmusic.SheetMusic;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;

public class MidiPlayer
extends LinearLayout {
    static Bitmap rewindImage;
    static Bitmap playImage;
    static Bitmap pauseImage;
    static Bitmap stopImage;
    static Bitmap fastFwdImage;
    static Bitmap volumeImage;
    static Bitmap settingsImage;
    private ImageButton rewindButton;
    private ImageButton playButton;
    private ImageButton stopButton;
    private ImageButton fastFwdButton;
    private ImageButton settingsButton;
    private TextView speedText;
    private SeekBar speedBar;
    int playstate;
    final int stopped = 1;
    final int playing = 2;
    final int paused = 3;
    final int initStop = 4;
    final int initPause = 5;
    final String tempSoundFile = "playing.mid";
    MediaPlayer player;
    MidiFile midifile;
    MidiOptions options;
    double pulsesPerMsec;
    SheetMusic sheet;
    Piano piano;
    Handler timer;
    long startTime;
    double startPulseTime;
    double currentPulseTime;
    double prevPulseTime;
    Activity activity;
    Runnable ReShade = new Runnable(){

        @Override
        public void run() {
            if (MidiPlayer.this.playstate == 3 || MidiPlayer.this.playstate == 1) {
                MidiPlayer.this.sheet.ShadeNotes((int)MidiPlayer.this.currentPulseTime, -10, 1);
                MidiPlayer.this.piano.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime);
            }
        }
    };
    Runnable DoPlay = new Runnable(){

        @Override
        public void run() {
            MidiPlayer.this.activity.getWindow().addFlags(128);
            if (MidiPlayer.this.options.playMeasuresInLoop) {
                int measure = (int)(MidiPlayer.this.currentPulseTime / (double)MidiPlayer.this.midifile.getTime().getMeasure());
                if (measure < MidiPlayer.this.options.playMeasuresInLoopStart || measure > MidiPlayer.this.options.playMeasuresInLoopEnd) {
                    MidiPlayer.this.currentPulseTime = MidiPlayer.this.options.playMeasuresInLoopStart * MidiPlayer.this.midifile.getTime().getMeasure();
                }
                MidiPlayer.this.startPulseTime = MidiPlayer.this.currentPulseTime;
                MidiPlayer.this.options.pauseTime = (int)(MidiPlayer.this.currentPulseTime - (double)MidiPlayer.this.options.shifttime);
            } else if (MidiPlayer.this.playstate == 3) {
                MidiPlayer.this.startPulseTime = MidiPlayer.this.currentPulseTime;
                MidiPlayer.this.options.pauseTime = (int)(MidiPlayer.this.currentPulseTime - (double)MidiPlayer.this.options.shifttime);
            } else {
                MidiPlayer.this.options.pauseTime = 0;
                MidiPlayer.this.startPulseTime = MidiPlayer.this.options.shifttime;
                MidiPlayer.this.currentPulseTime = MidiPlayer.this.options.shifttime;
                MidiPlayer.this.prevPulseTime = MidiPlayer.this.options.shifttime - MidiPlayer.this.midifile.getTime().getQuarter();
            }
            MidiPlayer.this.CreateMidiFile();
            MidiPlayer.this.playstate = 2;
            MidiPlayer.this.PlaySound("playing.mid");
            MidiPlayer.this.startTime = SystemClock.uptimeMillis();
            MidiPlayer.this.timer.removeCallbacks(MidiPlayer.this.TimerCallback);
            MidiPlayer.this.timer.removeCallbacks(MidiPlayer.this.ReShade);
            MidiPlayer.this.timer.postDelayed(MidiPlayer.this.TimerCallback, 100L);
            MidiPlayer.this.sheet.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime, 2);
            MidiPlayer.this.piano.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime);
        }
    };
    Runnable TimerCallback = new Runnable(){

        @Override
        public void run() {
            if (MidiPlayer.this.midifile == null || MidiPlayer.this.sheet == null) {
                MidiPlayer.this.playstate = 1;
                return;
            }
            if (MidiPlayer.this.playstate == 1 || MidiPlayer.this.playstate == 3) {
                return;
            }
            if (MidiPlayer.this.playstate == 4) {
                return;
            }
            if (MidiPlayer.this.playstate == 2) {
                double nearEndTime;
                int measure;
                long msec = SystemClock.uptimeMillis() - MidiPlayer.this.startTime;
                MidiPlayer.this.prevPulseTime = MidiPlayer.this.currentPulseTime;
                MidiPlayer.this.currentPulseTime = MidiPlayer.this.startPulseTime + (double)msec * MidiPlayer.this.pulsesPerMsec;
                if (MidiPlayer.this.options.playMeasuresInLoop && (measure = (int)((nearEndTime = MidiPlayer.this.currentPulseTime + MidiPlayer.this.pulsesPerMsec * 10.0) / (double)MidiPlayer.this.midifile.getTime().getMeasure())) > MidiPlayer.this.options.playMeasuresInLoopEnd) {
                    MidiPlayer.this.RestartPlayMeasuresInLoop();
                    return;
                }
                if (MidiPlayer.this.currentPulseTime > (double)MidiPlayer.this.midifile.getTotalPulses()) {
                    MidiPlayer.this.DoStop();
                    return;
                }
                MidiPlayer.this.sheet.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime, 2);
                MidiPlayer.this.piano.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime);
                MidiPlayer.this.timer.postDelayed(MidiPlayer.this.TimerCallback, 100L);
                return;
            }
            if (MidiPlayer.this.playstate == 5) {
                long msec = SystemClock.uptimeMillis() - MidiPlayer.this.startTime;
                MidiPlayer.this.StopSound();
                MidiPlayer.this.prevPulseTime = MidiPlayer.this.currentPulseTime;
                MidiPlayer.this.currentPulseTime = MidiPlayer.this.startPulseTime + (double)msec * MidiPlayer.this.pulsesPerMsec;
                MidiPlayer.this.sheet.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime, 1);
                MidiPlayer.this.piano.ShadeNotes((int)MidiPlayer.this.currentPulseTime, (int)MidiPlayer.this.prevPulseTime);
                MidiPlayer.this.playstate = 3;
                MidiPlayer.this.timer.postDelayed(MidiPlayer.this.ReShade, 1000L);
                return;
            }
        }
    };

    public static void LoadImages(Context context) {
        if (rewindImage != null) {
            return;
        }
        Resources res = context.getResources();
        rewindImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.rewind);
        playImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.play);
        pauseImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.pause);
        stopImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.stop);
        fastFwdImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.fastforward);
        settingsImage = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.settings);
    }

    public MidiPlayer(Activity activity) {
        super((Context)activity);
        MidiPlayer.LoadImages((Context)activity);
        this.activity = activity;
        this.midifile = null;
        this.options = null;
        this.sheet = null;
        this.playstate = 1;
        this.startTime = SystemClock.uptimeMillis();
        this.startPulseTime = 0.0;
        this.currentPulseTime = 0.0;
        this.prevPulseTime = -10.0;
        this.setPadding(0, 0, 0, 0);
        this.CreateButtons();
        int screenwidth = activity.getWindowManager().getDefaultDisplay().getWidth();
        int screenheight = activity.getWindowManager().getDefaultDisplay().getHeight();
        Point newsize = MidiPlayer.getPreferredSize(screenwidth, screenheight);
        this.resizeButtons(newsize.x, newsize.y);
        this.player = new MediaPlayer();
        this.setBackgroundColor(-16777216);
    }

    public static Point getPreferredSize(int screenwidth, int screenheight) {
        int height = (int)(5.0 * (double)screenwidth / 44.0);
        height = height * 2 / 3;
        Point result = new Point(screenwidth, height);
        return result;
    }

    protected void onMeasure(int widthspec, int heightspec) {
        super.onMeasure(widthspec, heightspec);
        int screenwidth = View.MeasureSpec.getSize((int)widthspec);
        int screenheight = View.MeasureSpec.getSize((int)heightspec);
        int width = screenwidth;
        int height = (int)(5.0 * (double)screenwidth / 44.0);
        height = height * 2 / 3;
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int newwidth, int newheight, int oldwidth, int oldheight) {
        this.resizeButtons(newwidth, newheight);
        super.onSizeChanged(newwidth, newheight, oldwidth, oldheight);
    }

    void CreateButtons() {
        this.setOrientation(0);
        this.rewindButton = new ImageButton((Context)this.activity);
        this.rewindButton.setBackgroundColor(-16777216);
        this.rewindButton.setImageBitmap(rewindImage);
        this.rewindButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.rewindButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MidiPlayer.this.Rewind();
            }
        });
        this.addView((View)this.rewindButton);
        this.stopButton = new ImageButton((Context)this.activity);
        this.stopButton.setBackgroundColor(-16777216);
        this.stopButton.setImageBitmap(stopImage);
        this.stopButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.stopButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MidiPlayer.this.Stop();
            }
        });
        this.addView((View)this.stopButton);
        this.playButton = new ImageButton((Context)this.activity);
        this.playButton.setBackgroundColor(-16777216);
        this.playButton.setImageBitmap(playImage);
        this.playButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.playButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MidiPlayer.this.Play();
            }
        });
        this.addView((View)this.playButton);
        this.fastFwdButton = new ImageButton((Context)this.activity);
        this.fastFwdButton.setBackgroundColor(-16777216);
        this.fastFwdButton.setImageBitmap(fastFwdImage);
        this.fastFwdButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.fastFwdButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MidiPlayer.this.FastForward();
            }
        });
        this.addView((View)this.fastFwdButton);
        this.speedText = new TextView((Context)this.activity);
        this.speedText.setText((CharSequence)"   Speed: 100   ");
        this.speedText.setTextColor(-1);
        this.speedText.setGravity(17);
        this.addView((View)this.speedText);
        this.speedBar = new SeekBar((Context)this.activity);
        this.speedBar.setMax(270);
        this.speedBar.setMin(45);
        this.speedBar.setProgress(100);
        this.speedBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar bar, int progress, boolean fromUser) {
                MidiPlayer.this.speedText.setText((CharSequence)("   Speed: " + String.format(Locale.US, "%03d", progress) + "   "));
            }

            public void onStartTrackingTouch(SeekBar bar) {
            }

            public void onStopTrackingTouch(SeekBar bar) {
            }
        });
        this.addView((View)this.speedBar);
        this.settingsButton = new ImageButton((Context)this.activity);
        this.settingsButton.setBackgroundColor(-16777216);
        this.settingsButton.setImageBitmap(settingsImage);
        this.settingsButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MidiPlayer.this.activity.openOptionsMenu();
            }
        });
        this.addView((View)this.settingsButton);
        this.timer = new Handler();
    }

    void resizeButtons(int newwidth, int newheight) {
        int buttonheight = newheight;
        int pad = buttonheight / 6;
        this.rewindButton.setPadding(pad, pad, pad, pad);
        this.stopButton.setPadding(pad, pad, pad, pad);
        this.playButton.setPadding(pad, pad, pad, pad);
        this.fastFwdButton.setPadding(pad, pad, pad, pad);
        this.settingsButton.setPadding(pad, pad, pad, pad);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(buttonheight, buttonheight);
        params.width = buttonheight;
        params.height = buttonheight;
        params.bottomMargin = 0;
        params.topMargin = 0;
        params.rightMargin = 0;
        params.leftMargin = buttonheight / 6;
        this.rewindButton.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(buttonheight, buttonheight);
        params.bottomMargin = 0;
        params.topMargin = 0;
        params.rightMargin = 0;
        params.leftMargin = 0;
        this.playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.stopButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.fastFwdButton.setLayoutParams((ViewGroup.LayoutParams)params);
        params = (LinearLayout.LayoutParams)this.speedText.getLayoutParams();
        params.height = buttonheight;
        this.speedText.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(buttonheight * 5, buttonheight);
        params.width = buttonheight * 5;
        params.bottomMargin = 0;
        params.leftMargin = 0;
        params.topMargin = 0;
        params.rightMargin = 0;
        this.speedBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.speedBar.setPadding(pad, pad, pad, pad);
        params = new LinearLayout.LayoutParams(buttonheight, buttonheight);
        params.bottomMargin = 0;
        params.topMargin = 0;
        params.rightMargin = 0;
        params.leftMargin = buttonheight / 8;
        this.settingsButton.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void SetPiano(Piano p) {
        this.piano = p;
    }

    public void SetMidiFile(MidiFile file, MidiOptions opt, SheetMusic s) {
        if (file == this.midifile && this.midifile != null && this.playstate == 3) {
            this.options = opt;
            this.sheet = s;
            this.sheet.ShadeNotes((int)this.currentPulseTime, -1, 3);
            this.timer.removeCallbacks(this.TimerCallback);
            this.timer.postDelayed(this.ReShade, 500L);
        } else {
            this.Stop();
            this.midifile = file;
            this.options = opt;
            this.sheet = s;
        }
    }

    private int numberTracks() {
        int count = 0;
        for (int i = 0; i < this.options.tracks.length; ++i) {
            if (!this.options.tracks[i] || this.options.mute[i]) continue;
            ++count;
        }
        return count;
    }

    private void CreateMidiFile() {
        double inverse_tempo = 1.0 / (double)this.midifile.getTime().getTempo();
        double inverse_tempo_scaled = inverse_tempo * (double)this.speedBar.getProgress() / 100.0;
        this.options.tempo = (int)(1.0 / inverse_tempo_scaled);
        this.pulsesPerMsec = (double)this.midifile.getTime().getQuarter() * (1000.0 / (double)this.options.tempo);
        try {
            FileOutputStream dest = this.activity.openFileOutput("playing.mid", 0);
            this.midifile.ChangeSound(dest, this.options);
            dest.close();
        }
        catch (IOException e) {
            Toast toast = Toast.makeText((Context)this.activity, (CharSequence)"Error: Unable to create MIDI file for playing.", (int)1);
            toast.show();
        }
    }

    private void checkFile(String name) {
        try {
            FileInputStream in = this.activity.openFileInput(name);
            byte[] data = new byte[4096];
            int total = 0;
            int len = 0;
            while ((len = in.read(data, 0, 4096)) > 0) {
                total += len;
            }
            in.close();
            data = new byte[total];
            in = this.activity.openFileInput(name);
            int offset = 0;
            while (offset < total) {
                len = in.read(data, offset, total - offset);
                if (len <= 0) continue;
                offset += len;
            }
            in.close();
            MidiFile midiFile = new MidiFile(data, name);
        }
        catch (IOException e) {
            Toast toast = Toast.makeText((Context)this.activity, (CharSequence)("CheckFile: " + e.toString()), (int)1);
            toast.show();
        }
        catch (MidiFileException e) {
            Toast toast = Toast.makeText((Context)this.activity, (CharSequence)("CheckFile midi: " + e.toString()), (int)1);
            toast.show();
        }
    }

    private void PlaySound(String filename) {
        if (this.player == null) {
            return;
        }
        try {
            FileInputStream input = this.activity.openFileInput(filename);
            this.player.reset();
            this.player.setDataSource(input.getFD());
            input.close();
            this.player.prepare();
            this.player.start();
        }
        catch (IOException e) {
            Toast toast = Toast.makeText((Context)this.activity, (CharSequence)"Error: Unable to play MIDI sound", (int)1);
            toast.show();
        }
    }

    private void StopSound() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
        this.player.reset();
    }

    private void Play() {
        if (this.midifile == null || this.sheet == null || this.numberTracks() == 0) {
            return;
        }
        if (this.playstate == 4 || this.playstate == 5 || this.playstate == 2) {
            return;
        }
        this.setVisibility(8);
        this.timer.removeCallbacks(this.TimerCallback);
        this.timer.postDelayed(this.DoPlay, 1000L);
    }

    public void Pause() {
        this.setVisibility(0);
        LinearLayout layout = (LinearLayout)this.getParent();
        layout.requestLayout();
        this.requestLayout();
        this.invalidate();
        this.activity.getWindow().clearFlags(128);
        if (this.midifile == null || this.sheet == null || this.numberTracks() == 0) {
            return;
        }
        if (this.playstate == 2) {
            this.playstate = 5;
            return;
        }
    }

    void Stop() {
        this.setVisibility(0);
        if (this.midifile == null || this.sheet == null || this.playstate == 1) {
            return;
        }
        if (this.playstate == 5 || this.playstate == 4 || this.playstate == 2) {
            this.playstate = 4;
            this.DoStop();
        } else if (this.playstate == 3) {
            this.DoStop();
        }
    }

    void DoStop() {
        this.playstate = 1;
        this.timer.removeCallbacks(this.TimerCallback);
        this.sheet.ShadeNotes(-10, (int)this.prevPulseTime, 3);
        this.sheet.ShadeNotes(-10, (int)this.currentPulseTime, 3);
        this.piano.ShadeNotes(-10, (int)this.prevPulseTime);
        this.piano.ShadeNotes(-10, (int)this.currentPulseTime);
        this.startPulseTime = 0.0;
        this.currentPulseTime = 0.0;
        this.prevPulseTime = 0.0;
        this.setVisibility(0);
        this.StopSound();
    }

    void Rewind() {
        if (this.midifile == null || this.sheet == null || this.playstate != 3) {
            return;
        }
        this.sheet.ShadeNotes(-10, (int)this.currentPulseTime, 3);
        this.piano.ShadeNotes(-10, (int)this.currentPulseTime);
        this.prevPulseTime = this.currentPulseTime;
        this.currentPulseTime -= (double)this.midifile.getTime().getMeasure();
        if (this.currentPulseTime < (double)this.options.shifttime) {
            this.currentPulseTime = this.options.shifttime;
        }
        this.sheet.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime, 1);
        this.piano.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime);
    }

    void FastForward() {
        if (this.midifile == null || this.sheet == null) {
            return;
        }
        if (this.playstate != 3 && this.playstate != 1) {
            return;
        }
        this.playstate = 3;
        this.sheet.ShadeNotes(-10, (int)this.currentPulseTime, 3);
        this.piano.ShadeNotes(-10, (int)this.currentPulseTime);
        this.prevPulseTime = this.currentPulseTime;
        this.currentPulseTime += (double)this.midifile.getTime().getMeasure();
        if (this.currentPulseTime > (double)this.midifile.getTotalPulses()) {
            this.currentPulseTime -= (double)this.midifile.getTime().getMeasure();
        }
        this.sheet.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime, 1);
        this.piano.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime);
    }

    public void MoveToClicked(int x, int y) {
        if (this.midifile == null || this.sheet == null) {
            return;
        }
        if (this.playstate != 3 && this.playstate != 1) {
            return;
        }
        this.playstate = 3;
        this.sheet.ShadeNotes(-10, (int)this.currentPulseTime, 3);
        this.piano.ShadeNotes(-10, (int)this.currentPulseTime);
        this.currentPulseTime = this.sheet.PulseTimeForPoint(new Point(x, y));
        this.prevPulseTime = this.currentPulseTime - (double)this.midifile.getTime().getMeasure();
        if (this.currentPulseTime > (double)this.midifile.getTotalPulses()) {
            this.currentPulseTime -= (double)this.midifile.getTime().getMeasure();
        }
        this.sheet.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime, 3);
        this.piano.ShadeNotes((int)this.currentPulseTime, (int)this.prevPulseTime);
    }

    private void RestartPlayMeasuresInLoop() {
        this.playstate = 1;
        this.piano.ShadeNotes(-10, (int)this.prevPulseTime);
        this.sheet.ShadeNotes(-10, (int)this.prevPulseTime, 3);
        this.currentPulseTime = 0.0;
        this.prevPulseTime = -1.0;
        this.StopSound();
        this.timer.postDelayed(this.DoPlay, 300L);
    }
}

