/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.utils.TPThreadPoolExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class TPThreadPool {
    private static final String TAG = "TPCore[TPThreadPool]";
    private static final String PRE_THREAD_NAME = "TPCoreHdr";
    private static final String SHARE_THREAD_NAME = "TPCore-ShareThread";
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 20;
    private static volatile HandlerThread sHandlerThread = null;
    private static volatile Handler sMainThreadHandler = null;
    private static int sShareThreadCount = 0;
    private static volatile ExecutorService sShareSingleExecutor = null;
    private static volatile ExecutorService sCustomExecutor = null;
    private static volatile ScheduledExecutorService sScheduler = null;
    private static volatile TPThreadPool sInstance;

    private TPThreadPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPThreadPool getInstance() {
        if (sInstance != null) return sInstance;
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TPThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public HandlerThread obtainHandleThread(String string) {
        return this.obtainHandleThread(string, 0);
    }

    public HandlerThread obtainHandleThread(String string, int n2) {
        if (n2 >= 19 || n2 <= -19) {
            n2 = 0;
        }
        String string2 = TextUtils.isEmpty((CharSequence)string) ? PRE_THREAD_NAME : string;
        HandlerThread handlerThread = new HandlerThread(string2, n2);
        handlerThread.start();
        return handlerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerThread obtainShareThread() {
        TPThreadPool.initHandlerThread();
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            TPNativeLog.printLog(2, TAG, "handlerThread obtainShareThread mShareThreadCount:" + ++sShareThreadCount);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sHandlerThread;
        }
    }

    public void postRunnableOnMainThreadFront(Runnable runnable) {
        TPThreadPool.initMainThreadHandler();
        if (sMainThreadHandler != null) {
            sMainThreadHandler.postAtFrontOfQueue(runnable);
        }
    }

    public void postRunnableOnMainThread(Runnable runnable) {
        TPThreadPool.initMainThreadHandler();
        if (sMainThreadHandler != null) {
            sMainThreadHandler.post(runnable);
        }
    }

    public void postDelayRunnableOnMainThread(Runnable runnable, long l2) {
        TPThreadPool.initMainThreadHandler();
        if (sMainThreadHandler != null) {
            sMainThreadHandler.postDelayed(runnable, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExecutorService obtainSingleThreadExecutor() {
        if (sShareSingleExecutor != null) return sShareSingleExecutor;
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sShareSingleExecutor != null) return sShareSingleExecutor;
            sShareSingleExecutor = Executors.newSingleThreadExecutor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sShareSingleExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExecutorService obtainThreadExecutor() {
        if (sCustomExecutor != null) return sCustomExecutor;
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sCustomExecutor != null) return sCustomExecutor;
            sCustomExecutor = TPThreadPoolExecutor.newCustomThreadExecutor(1, 20);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCustomExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScheduledExecutorService obtainScheduledExecutorService() {
        if (sScheduler != null) return sScheduler;
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sScheduler != null) return sScheduler;
            sScheduler = Executors.newScheduledThreadPool(1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sScheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(HandlerThread handlerThread, Handler handler) {
        if (handlerThread == null) {
            return;
        }
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        if (handlerThread.equals(sHandlerThread)) {
            Class<TPThreadPool> clazz = TPThreadPool.class;
            synchronized (TPThreadPool.class) {
                TPNativeLog.printLog(2, TAG, "handlerThread recycle mShareThreadCount:" + --sShareThreadCount);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        handlerThread.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initHandlerThread() {
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sHandlerThread == null) {
                sHandlerThread = new HandlerThread(SHARE_THREAD_NAME);
                sHandlerThread.start();
            } else if (!sHandlerThread.isAlive()) {
                sHandlerThread.start();
            }
            if (sHandlerThread.getLooper() == null) {
                sHandlerThread.quit();
                sHandlerThread = new HandlerThread(SHARE_THREAD_NAME);
                sHandlerThread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMainThreadHandler() {
        if (sMainThreadHandler != null) {
            return;
        }
        Class<TPThreadPool> clazz = TPThreadPool.class;
        synchronized (TPThreadPool.class) {
            if (sMainThreadHandler != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                sMainThreadHandler = new Handler(looper);
            } else {
                sMainThreadHandler = null;
                TPNativeLog.printLog(4, TAG, "cannot get thread looper");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

