/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import com.daya.orchestra.accompany.utils.ALOG;
import java.lang.ref.WeakReference;

public class VolumeManager {
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    private VolumeChangeListener mVolumeChangeListener;
    private VolumeBroadcastReceiver mVolumeBroadcastReceiver;
    private Context mContext;
    private AudioManager mAudioManager;
    private boolean mRegistered = false;

    public VolumeManager(Context context) {
        this.mContext = context;
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }
    }

    public int getCurrentMusicVolume() {
        return this.mAudioManager != null ? this.mAudioManager.getStreamVolume(3) : -1;
    }

    public void setCurrentMusicVolume(int value) {
        if (this.mAudioManager != null) {
            ALOG.i("setStreamVolume:" + value);
            ALOG.i("setStreamVolume thread:" + Thread.currentThread().getName());
            boolean volumeFixed = this.mAudioManager.isVolumeFixed();
            ALOG.i("setStreamVolume isVolumeFixed:" + volumeFixed);
            this.mAudioManager.setStreamVolume(3, value, 8);
        }
    }

    public int getMaxMusicVolume() {
        return this.mAudioManager != null ? this.mAudioManager.getStreamMaxVolume(3) : 15;
    }

    public VolumeChangeListener getVolumeChangeListener() {
        return this.mVolumeChangeListener;
    }

    public void setVolumeChangeListener(VolumeChangeListener volumeChangeListener) {
        this.mVolumeChangeListener = volumeChangeListener;
    }

    public void registerReceiver() {
        this.mVolumeBroadcastReceiver = new VolumeBroadcastReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction(VOLUME_CHANGED_ACTION);
        this.mContext.registerReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver, filter);
        this.mRegistered = true;
    }

    public void unregisterReceiver() {
        if (this.mRegistered) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver);
                this.mVolumeChangeListener = null;
                this.mRegistered = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface VolumeChangeListener {
        public void onVolumeChanged(int var1);
    }

    private static class VolumeBroadcastReceiver
    extends BroadcastReceiver {
        private WeakReference<VolumeManager> mObserverWeakReference;

        public VolumeBroadcastReceiver(VolumeManager volumeChangeObserver) {
            this.mObserverWeakReference = new WeakReference<VolumeManager>(volumeChangeObserver);
        }

        public void onReceive(Context context, Intent intent) {
            int volume;
            VolumeChangeListener listener;
            VolumeManager observer1;
            ALOG.i("onReceive");
            if (VolumeManager.VOLUME_CHANGED_ACTION.equals(intent.getAction()) && intent.getIntExtra(VolumeManager.EXTRA_VOLUME_STREAM_TYPE, -1) == 3 && (observer1 = (VolumeManager)this.mObserverWeakReference.get()) != null && (listener = observer1.getVolumeChangeListener()) != null && (volume = observer1.getCurrentMusicVolume()) >= 0) {
                listener.onVolumeChanged(volume);
            }
        }
    }
}

