/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp;

import android.text.TextUtils;
import com.tencent.rtmp.TXPlayerGlobalSetting;

public class TXPlayerDrmBuilder {
    private static final String DEFAULT_COM_PROVISION_URL = "https://www.googleapis.com/certificateprovisioning/v1/devicecertificates/create?key=AIzaSyB-5OLKTx2iU5mko18DfdwK5611JIjbUhE";
    private static final String DEFAULT_CN_PROVISION_URL = "https://www.googleapis.cn/certificateprovisioning/v1/devicecertificates/create?key=AIzaSyB-5OLKTx2iU5mko18DfdwK5611JIjbUhE";
    String mDeviceCertificateUrl;
    String mKeyLicenseUrl;
    String mPlayUrl;

    public TXPlayerDrmBuilder() {
    }

    public TXPlayerDrmBuilder(String licenseUrl, String playUrl) {
        this.mKeyLicenseUrl = licenseUrl;
        this.mPlayUrl = playUrl;
    }

    public TXPlayerDrmBuilder setDeviceCertificateUrl(String deviceCertificateUrl) {
        this.mDeviceCertificateUrl = deviceCertificateUrl;
        return this;
    }

    public String getDeviceCertificateUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.mDeviceCertificateUrl)) {
            return this.mDeviceCertificateUrl;
        }
        if (TXPlayerGlobalSetting.getDrmProvisionEnv() == TXPlayerGlobalSetting.DrmProvisionEnv.DRM_PROVISION_ENV_COM) {
            return DEFAULT_COM_PROVISION_URL;
        }
        return DEFAULT_CN_PROVISION_URL;
    }

    public TXPlayerDrmBuilder setKeyLicenseUrl(String keyLicenseUrl) {
        this.mKeyLicenseUrl = keyLicenseUrl;
        return this;
    }

    public String getKeyLicenseUrl() {
        return this.mKeyLicenseUrl;
    }

    public TXPlayerDrmBuilder setPlayUrl(String playUrl) {
        this.mPlayUrl = playUrl;
        return this;
    }

    public String getPlayUrl() {
        return this.mPlayUrl;
    }

    public String toString() {
        return "TXPlayerDrmBuilder{deviceCertificateUrl='" + this.mDeviceCertificateUrl + '\'' + ", licenseUrl='" + this.mKeyLicenseUrl + '\'' + ", playUrl='" + this.mPlayUrl + '\'' + '}';
    }
}

