/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.decoder;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.tencent.thumbplayer.core.common.TPCodecUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.decoder.TPBaseMediaCodecDecoder;
import com.tencent.thumbplayer.core.decoder.TPFrameInfo;
import com.tencent.thumbplayer.g.b;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@SuppressLint(value={"NewApi"})
public class TPMediaCodecAudioDecoder
extends TPBaseMediaCodecDecoder {
    private static final String TAG = "TPMediaCodecAudioDecoder";
    private ArrayList<String> mMimeCandidates = new ArrayList();
    private int mSampleRate = 0;
    private int mChannelCount = 0;
    private int mAudioFormat = 0;
    private byte[] mCsd0Data = null;
    private boolean mIsAdts = false;
    private boolean mEnableAudioPassThrough = false;

    public TPMediaCodecAudioDecoder(int n2) {
        super(n2);
    }

    @Override
    public boolean initDecoder(String string, int n2, int n3, int n4, int n5) {
        TPNativeLog.printLog(2, TAG, "initDecoder, mimeType:" + string + " sampleRate:" + n2 + " channelCount:" + n3 + " drmType:" + n4 + " audioFormat:" + n5);
        this.mSampleRate = n2;
        this.mChannelCount = n3;
        this.mDrmType = n4;
        this.mAudioFormat = n5;
        this.mMimeCandidates.clear();
        this.mMimeCandidates.add(string);
        return true;
    }

    @Override
    public boolean initDecoder(String string, int n2, int n3, int n4, Surface surface, int n5, int n6, int n7) {
        return false;
    }

    ArrayList<String> getMimeCandidates() {
        return this.mMimeCandidates;
    }

    @Override
    String getCodecName(String string, boolean bl2) {
        return TPCodecUtils.getDecoderName(string, bl2);
    }

    @Override
    void configCodec(b b2, String string) {
        TPNativeLog.printLog(2, TAG, "configCodec: ");
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)string, (int)this.mSampleRate, (int)this.mChannelCount);
        if (this.mCsd0Data != null) {
            mediaFormat.setByteBuffer("csd-0", ByteBuffer.wrap(this.mCsd0Data));
        }
        if (this.mIsAdts) {
            TPNativeLog.printLog(2, TAG, "configCodec: set is adts");
            mediaFormat.setInteger("is-adts", 1);
        }
        b2.a(mediaFormat, null, this.mMediaCrypto, 0);
    }

    @Override
    void processOutputConfigData(b b2, int n2, MediaCodec.BufferInfo bufferInfo, TPFrameInfo tPFrameInfo) {
        b2.a(n2, false);
        tPFrameInfo.errCode = 1;
    }

    @Override
    void processOutputFormatChanged(MediaFormat mediaFormat) {
        int n2 = 2;
        try {
            if (mediaFormat.containsKey("sample-rate")) {
                this.mSampleRate = mediaFormat.getInteger("sample-rate");
            }
            if (mediaFormat.containsKey("channel-count")) {
                this.mChannelCount = mediaFormat.getInteger("channel-count");
            }
            if (Build.VERSION.SDK_INT >= 24 && mediaFormat.containsKey("pcm-encoding")) {
                n2 = mediaFormat.getInteger("pcm-encoding");
                TPNativeLog.printLog(2, TAG, "processOutputFormatChanged: MediaFormat.KEY_PCM_ENCODING: ".concat(String.valueOf(n2)));
            }
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "processOutputFormatChanged got one exception: " + this.getStackTrace(exception));
        }
        TPNativeLog.printLog(2, TAG, "processOutputFormatChanged, mEnableAudioPassThrough:" + this.mEnableAudioPassThrough + ", mSampleRate: " + this.mSampleRate + ", mChannelCount: " + this.mChannelCount + " mAudioFormat: " + this.mAudioFormat + " pcmFormat:" + n2);
    }

    @Override
    void processOutputBuffer(b b2, int n2, MediaCodec.BufferInfo bufferInfo, TPFrameInfo tPFrameInfo) {
        tPFrameInfo.sampleRate = this.mSampleRate;
        tPFrameInfo.channelCount = this.mChannelCount;
        tPFrameInfo.format = this.mAudioFormat;
        ByteBuffer byteBuffer = Build.VERSION.SDK_INT >= 21 ? b2.a(n2) : b2.k()[n2];
        byte[] byArray = null;
        if (byteBuffer != null) {
            byArray = new byte[bufferInfo.size];
            byteBuffer.get(byArray, bufferInfo.offset, bufferInfo.size);
        }
        tPFrameInfo.data = byArray;
        if (bufferInfo.flags == 4 && bufferInfo.size <= 0) {
            TPNativeLog.printLog(2, TAG, "processOutputBuffer: bufferInfo.flags is BUFFER_FLAG_END_OF_STREAM, return EOS!");
            tPFrameInfo.errCode = 2;
        }
        b2.a(n2, false);
    }

    @Override
    void processMediaCodecException(Exception exception) {
    }

    @Override
    String getLogTag() {
        return TAG;
    }

    @Override
    public boolean setParamBool(int n2, boolean bl2) {
        if (n2 == 2) {
            this.mIsAdts = bl2;
            return true;
        }
        if (n2 == 3) {
            this.mEnableAudioPassThrough = bl2;
            TPNativeLog.printLog(2, this.getLogTag(), "setParamBool mEnableAudioPassThrough:" + this.mEnableAudioPassThrough);
            return true;
        }
        return super.setParamBool(n2, bl2);
    }

    @Override
    public boolean setParamBytes(int n2, byte[] byArray) {
        if (n2 == 200) {
            this.mCsd0Data = byArray;
        }
        return super.setParamBytes(n2, byArray);
    }

    @Override
    public boolean setParamObject(int n2, Object object) {
        return super.setParamObject(n2, object);
    }

    @Override
    public int setOperateRate(float f2) {
        return super.setOperateRate(f2);
    }
}

