/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.service;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.downloadproxy.aidl.ITPDownloadProxyAidl;
import com.tencent.thumbplayer.core.downloadproxy.aidl.ITPPlayListenerAidl;
import com.tencent.thumbplayer.core.downloadproxy.aidl.ITPPreLoadListenerAidl;
import com.tencent.thumbplayer.core.downloadproxy.aidl.TPDownloadParamAidl;
import com.tencent.thumbplayer.core.downloadproxy.aidl.TPDownloadProxyFactoryAidl;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPlayListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDLProxyInitParam;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadParam;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyFactory;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyHelper;
import com.tencent.thumbplayer.core.downloadproxy.apiinner.TPListenerManager;
import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TPDownloadProxyService
extends Service {
    private static final String FILE_NAME = "TPDownloadProxyService";
    private int pid = -1;
    private TPDownloadProxyFactoryAidl.Stub downloadProxyFactory = null;

    public IBinder onBind(Intent intent) {
        if (this.downloadProxyFactory == null) {
            this.downloadProxyFactory = new DownloadProxyFactory();
        }
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "on bind!");
        this.isExistMainProcess();
        return this.downloadProxyFactory;
    }

    public boolean onUnbind(Intent intent) {
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "on unbind!");
        super.onUnbind(intent);
        if (!this.isExistMainProcess()) {
            try {
                TPDownloadProxyNative.getInstance().stopAllDownload(3);
                TPListenerManager.getInstance().removeAllPlayListener();
                TPListenerManager.getInstance().removeAllPreLoadListener();
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", throwable.toString());
            }
        }
        return true;
    }

    public void onRebind(Intent intent) {
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "on rebind!");
        this.isExistMainProcess();
        super.onRebind(intent);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "on start command!");
        return 2;
    }

    private boolean isExistMainProcess() {
        try {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)this.getSystemService("activity")).getRunningAppProcesses()) {
                String string = runningAppProcessInfo.processName;
                if (TextUtils.isEmpty((CharSequence)string) || !string.equals(this.getPackageName())) continue;
                if (this.pid != -1 && this.pid != runningAppProcessInfo.pid) {
                    this.pid = runningAppProcessInfo.pid;
                    return false;
                }
                this.pid = runningAppProcessInfo.pid;
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "app main exist!");
                return true;
            }
        }
        catch (Throwable throwable) {
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "isExistMainProcess failed, error:" + throwable.toString());
        }
        return false;
    }

    class DownloadProxy
    extends ITPDownloadProxyAidl.Stub {
        private ITPDownloadProxy downloadProxy = null;

        public DownloadProxy(int serverType) {
            this.downloadProxy = TPDownloadProxyFactory.getTPDownloadProxy(serverType);
        }

        @Override
        public int init(String paramObj) {
            try {
                TPDLProxyInitParam tPDLProxyInitParam = (TPDLProxyInitParam)TPDLProxyUtils.serializeToObject(paramObj);
                if (tPDLProxyInitParam == null) {
                    TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "param is null");
                    return -1;
                }
                return this.downloadProxy.init(TPDownloadProxyHelper.getContext(), tPDLProxyInitParam);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "init failed, error:" + throwable.toString());
                return -2;
            }
        }

        @Override
        public int startPlay(String fileId, TPDownloadParamAidl dlParam, final ITPPlayListenerAidl playListener) {
            try {
                TPDownloadParam tPDownloadParam = new TPDownloadParam(dlParam.getUrlList(), dlParam.getDlType(), dlParam.getExtInfoMap());
                ITPPlayListener iTPPlayListener = new ITPPlayListener(){

                    @Override
                    public void onDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownlaodProgressUpdate failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadFinish() {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadFinish();
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownlaodFinish failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadError(int moduleId, int errorCode, String extInfo) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadError(moduleId, errorCode, extInfo);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadError failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public Object onPlayCallback(int messageType, Object ext1, Object ext2, Object ext3, Object ext4) {
                        try {
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            if (ext1 != null) {
                                arrayList.add(ext1);
                            }
                            if (ext2 != null) {
                                arrayList.add(ext2);
                            }
                            if (ext3 != null) {
                                arrayList.add(ext3);
                            }
                            if (playListener != null) {
                                playListener.onPlayCallback(messageType, arrayList);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPlayCallback failed, error:" + throwable.toString());
                        }
                        return null;
                    }

                    @Override
                    public void onDownloadCdnUrlUpdate(String url) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadCdnUrlUpdate(url);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlUpdate failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadCdnUrlInfoUpdate(String url, String cdnIp, String uip, String errorCodeStr) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadCdnUrlInfoUpdate(url, cdnIp, uip, errorCodeStr);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlInfoUpdate failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadCdnUrlExpired(Map<String, String> info) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadCdnUrlExpired(info);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlExpired failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadStatusUpdate(int statusCode) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadStatusUpdate(statusCode);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadStatusUpdate failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public void onDownloadProtocolUpdate(String protocol, String protocolVer) {
                        try {
                            if (playListener != null) {
                                playListener.onDownloadProtocolUpdate(protocol, protocolVer);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadProtocolUpdate failed, error:" + throwable.toString());
                            return;
                        }
                    }

                    @Override
                    public long getPlayerBufferLength() {
                        try {
                            if (playListener != null) {
                                return playListener.getPlayerBufferLength();
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayerBufferLength failed, error:" + throwable.toString());
                        }
                        return -1L;
                    }

                    @Override
                    public long getCurrentPosition() {
                        try {
                            if (playListener != null) {
                                return playListener.getCurrentPosition();
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPosition failed, error:" + throwable.toString());
                        }
                        return -1L;
                    }

                    @Override
                    public long getCurrentPlayOffset() {
                        try {
                            if (playListener != null) {
                                return playListener.getCurrentPlayOffset();
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPlayOffset failed, error:" + throwable.toString());
                        }
                        return -1L;
                    }

                    @Override
                    public int getCurrentPlayClipNo() {
                        try {
                            if (playListener != null) {
                                return playListener.getCurrentPlayClipNo();
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPlayClipInfo failed, error:" + throwable.toString());
                        }
                        return -1;
                    }

                    @Override
                    public long getAdvRemainTime() {
                        try {
                            if (playListener != null) {
                                return playListener.getAdvRemainTime();
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getAdvRemainTime failed, error:" + throwable.toString());
                        }
                        return -1L;
                    }

                    @Override
                    public Object getPlayInfo(long type) {
                        try {
                            return playListener.getPlayInfo(Long.toString(type));
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayInfo type failed, error:" + throwable.toString());
                            return null;
                        }
                    }

                    @Override
                    public Object getPlayInfo(String key) {
                        try {
                            return playListener.getPlayInfo(key);
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayInfo key failed, error:" + throwable.toString());
                            return null;
                        }
                    }

                    @Override
                    public int onStartReadData(int fileId, String fileKey, long requestStart, long requestEnd) {
                        try {
                            if (playListener != null) {
                                return playListener.onStartReadData(fileId, fileKey, requestStart, requestEnd);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onStartReadData key failed, error:" + throwable.toString());
                        }
                        return -1;
                    }

                    @Override
                    public int onReadData(int fileId, String fileKey, long offset, long length) {
                        try {
                            if (playListener != null) {
                                return playListener.onReadData(fileId, fileKey, offset, length);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onReadData key failed, error:" + throwable.toString());
                        }
                        return -1;
                    }

                    @Override
                    public int onStopReadData(int fileId, String fileKey, int requestId) {
                        try {
                            if (playListener != null) {
                                return playListener.onStopReadData(fileId, fileKey, requestId);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onStopReadData key failed, error:" + throwable.toString());
                        }
                        return -1;
                    }

                    @Override
                    public long getDataTotalSize(int fileId, String fileKey) {
                        try {
                            if (playListener != null) {
                                return playListener.getDataTotalSize(fileId, fileKey);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getDataTotalSize key failed, error:" + throwable.toString());
                        }
                        return -1L;
                    }

                    @Override
                    public String getDataFilePath(int fileId, String fileKey) {
                        try {
                            if (playListener != null) {
                                return playListener.getDataFilePath(fileId, fileKey);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getDataFilePath key failed, error:" + throwable.toString());
                        }
                        return "";
                    }

                    @Override
                    public String getContentType(int fileId, String fileKey) {
                        try {
                            if (playListener != null) {
                                return playListener.getContentType(fileId, fileKey);
                            }
                        }
                        catch (Throwable throwable) {
                            TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getContentType key failed, error:" + throwable.toString());
                        }
                        return "";
                    }
                };
                return this.downloadProxy.startPlay(fileId, tPDownloadParam, iTPPlayListener);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "startPlay failed, error:" + throwable.toString());
                return -1;
            }
        }

        @Override
        public int startClipPlay(String fileId, int clipCount, final ITPPlayListenerAidl playListener) {
            ITPPlayListener iTPPlayListener = new ITPPlayListener(){

                @Override
                public void onDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadProgressUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadFinish() {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadFinish();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadFinish failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadError(int moduleId, int errorCode, String extInfo) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadError(moduleId, errorCode, extInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadError failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public Object onPlayCallback(int messageType, Object ext1, Object ext2, Object ext3, Object ext4) {
                    try {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        if (ext1 != null) {
                            arrayList.add(ext1);
                        }
                        if (ext1 != null) {
                            arrayList.add(ext2);
                        }
                        if (ext1 != null) {
                            arrayList.add(ext3);
                        }
                        if (playListener != null) {
                            playListener.onPlayCallback(messageType, arrayList);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPlayCallback failed, error:" + throwable.toString());
                    }
                    return null;
                }

                @Override
                public void onDownloadCdnUrlUpdate(String url) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadCdnUrlUpdate(url);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadCdnUrlInfoUpdate(String url, String cdnIp, String uip, String errorCodeStr) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadCdnUrlInfoUpdate(url, cdnIp, uip, errorCodeStr);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlInfoUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadCdnUrlExpired(Map<String, String> info) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadCdnUrlExpired(info);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadCdnUrlExpired failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadStatusUpdate(int statusCode) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadStatusUpdate(statusCode);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadStatusUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onDownloadProtocolUpdate(String protocol, String protocolVer) {
                    try {
                        if (playListener != null) {
                            playListener.onDownloadProtocolUpdate(protocol, protocolVer);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onDownloadProtocolUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public long getPlayerBufferLength() {
                    try {
                        if (playListener != null) {
                            return playListener.getPlayerBufferLength();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayerBufferLength failed, error:" + throwable.toString());
                    }
                    return -1L;
                }

                @Override
                public long getCurrentPosition() {
                    try {
                        if (playListener != null) {
                            return playListener.getCurrentPosition();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPosition failed, error:" + throwable.toString());
                    }
                    return -1L;
                }

                @Override
                public long getCurrentPlayOffset() {
                    try {
                        if (playListener != null) {
                            return playListener.getCurrentPlayOffset();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPlayOffset failed, error:" + throwable.toString());
                    }
                    return -1L;
                }

                @Override
                public int getCurrentPlayClipNo() {
                    try {
                        if (playListener != null) {
                            return playListener.getCurrentPlayClipNo();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getCurrentPlayClipNo failed, error:" + throwable.toString());
                    }
                    return -1;
                }

                @Override
                public long getAdvRemainTime() {
                    try {
                        if (playListener != null) {
                            return playListener.getAdvRemainTime();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getAdvRemainTime failed, error:" + throwable.toString());
                    }
                    return -1L;
                }

                @Override
                public Object getPlayInfo(long type) {
                    try {
                        if (playListener != null) {
                            return playListener.getPlayInfo(Long.toString(type));
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayInfo type failed, error:" + throwable.toString());
                    }
                    return null;
                }

                @Override
                public Object getPlayInfo(String key) {
                    try {
                        if (playListener != null) {
                            return playListener.getPlayInfo(key);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getPlayInfo key failed, error:" + throwable.toString());
                    }
                    return null;
                }

                @Override
                public int onStartReadData(int fileId, String fileKey, long requestStart, long requestEnd) {
                    try {
                        if (playListener != null) {
                            return playListener.onStartReadData(fileId, fileKey, requestStart, requestEnd);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onStartReadData key failed, error:" + throwable.toString());
                    }
                    return -1;
                }

                @Override
                public int onReadData(int fileId, String fileKey, long offset, long length) {
                    try {
                        if (playListener != null) {
                            return playListener.onReadData(fileId, fileKey, offset, length);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onReadData key failed, error:" + throwable.toString());
                    }
                    return -1;
                }

                @Override
                public int onStopReadData(int fileId, String fileKey, int requestId) {
                    try {
                        if (playListener != null) {
                            return playListener.onStopReadData(fileId, fileKey, requestId);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onStopReadData key failed, error:" + throwable.toString());
                    }
                    return -1;
                }

                @Override
                public long getDataTotalSize(int fileId, String fileKey) {
                    try {
                        if (playListener != null) {
                            return playListener.getDataTotalSize(fileId, fileKey);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getDataTotalSize key failed, error:" + throwable.toString());
                    }
                    return -1L;
                }

                @Override
                public String getDataFilePath(int fileId, String fileKey) {
                    try {
                        if (playListener != null) {
                            return playListener.getDataFilePath(fileId, fileKey);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getDataFilePath key failed, error:" + throwable.toString());
                    }
                    return "";
                }

                @Override
                public String getContentType(int fileId, String fileKey) {
                    try {
                        if (playListener != null) {
                            return playListener.getContentType(fileId, fileKey);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getContentType key failed, error:" + throwable.toString());
                    }
                    return "";
                }
            };
            return this.downloadProxy.startClipPlay(fileId, clipCount, iTPPlayListener);
        }

        @Override
        public boolean setClipInfo(int playId, int clipNo, String clipFileId, TPDownloadParamAidl dlParam) {
            TPDownloadParam tPDownloadParam = new TPDownloadParam(dlParam.getUrlList(), dlParam.getDlType(), dlParam.getExtInfoMap());
            return this.downloadProxy.setClipInfo(playId, clipNo, clipFileId, tPDownloadParam);
        }

        @Override
        public String getPlayUrl(int playId, int urlType) {
            return this.downloadProxy.getPlayUrl(playId, urlType);
        }

        @Override
        public String getClipPlayUrl(int playId, int clipNo, int urlType) {
            return this.downloadProxy.getClipPlayUrl(playId, clipNo, urlType);
        }

        @Override
        public String getPlayErrorCodeStr(int playId) {
            return this.downloadProxy.getPlayErrorCodeStr(playId);
        }

        @Override
        public void stopPlay(int playId) {
            this.downloadProxy.stopPlay(playId);
        }

        @Override
        public int pauseDownload(int playId) {
            return this.downloadProxy.pauseDownload(playId);
        }

        @Override
        public int resumeDownload(int playId) {
            return this.downloadProxy.resumeDownload(playId);
        }

        @Override
        public int startPreload(String fileId, TPDownloadParamAidl dlParam, final ITPPreLoadListenerAidl preloadListener) {
            TPDownloadParam tPDownloadParam = new TPDownloadParam(dlParam.getUrlList(), dlParam.getDlType(), dlParam.getExtInfoMap());
            ITPPreLoadListener iTPPreLoadListener = new ITPPreLoadListener(){

                @Override
                public void onPrepareOK() {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareOK();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareOK failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onPrepareError(int moduleId, int errorCode, String extInfo) {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareError(moduleId, errorCode, extInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareError failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onPrepareDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareDownloadProgressUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }
            };
            return this.downloadProxy.startPreload(fileId, tPDownloadParam, iTPPreLoadListener);
        }

        @Override
        public int startClipPreload(String fileId, int clipCount, final ITPPreLoadListenerAidl preloadListener) {
            ITPPreLoadListener iTPPreLoadListener = new ITPPreLoadListener(){

                @Override
                public void onPrepareOK() {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareOK();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareOK failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onPrepareError(int moduleId, int errorCode, String extInfo) {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareError(moduleId, errorCode, extInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareError failed, error:" + throwable.toString());
                        return;
                    }
                }

                @Override
                public void onPrepareDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                    try {
                        if (preloadListener != null) {
                            preloadListener.onPrepareDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "onPrepareDownloadProgressUpdate failed, error:" + throwable.toString());
                        return;
                    }
                }
            };
            return this.downloadProxy.startClipPreload(fileId, clipCount, iTPPreLoadListener);
        }

        @Override
        public void stopPreload(int preloadId) {
            this.downloadProxy.stopPreload(preloadId);
        }

        @Override
        public void startTask(int taskId) {
            this.downloadProxy.startTask(taskId);
        }

        @Override
        public void setUserData(Map userDataMap) {
            if (userDataMap != null) {
                for (Map.Entry entry : userDataMap.entrySet()) {
                    if (entry == null) continue;
                    try {
                        if (entry.getValue() == null) continue;
                        this.downloadProxy.setUserData((String)entry.getKey(), entry.getValue());
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "setUserData failed, error:" + throwable.toString());
                    }
                }
            }
        }

        @Override
        public String getNativeInfo(int key) {
            String string = null;
            try {
                string = this.downloadProxy.getNativeInfo(key);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getNativeInfo failed, error:" + throwable.toString());
            }
            return string;
        }

        @Override
        public int checkResourceStatus(String diskPath, String resourceID, int fileFormat) {
            int n2 = -1;
            try {
                n2 = this.downloadProxy.checkResourceStatus(diskPath, resourceID, fileFormat);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "checkResourceStatus failed, error:" + throwable.toString());
            }
            return n2;
        }

        @Override
        public long getResourceSize(String diskPath, String resourceID) {
            long l2 = -1L;
            try {
                l2 = this.downloadProxy.getResourceSize(diskPath, resourceID);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getResourceSize failed, error:" + throwable.toString());
            }
            return l2;
        }

        @Override
        public void pushEvent(int event) {
            this.downloadProxy.pushEvent(event);
        }

        @Override
        public void setPlayState(int playId, int state) {
            this.downloadProxy.setPlayState(playId, state);
        }

        @Override
        public void setMaxStorageSizeMB(long size) {
            this.downloadProxy.setMaxStorageSizeMB(size);
        }

        @Override
        public void updateTaskInfo(int playId, Map taskInfoMap) {
            if (taskInfoMap != null) {
                for (Map.Entry entry : taskInfoMap.entrySet()) {
                    if (entry == null) continue;
                    try {
                        if (entry.getValue() == null) continue;
                        this.downloadProxy.updateTaskInfo(playId, (String)entry.getKey(), entry.getValue());
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "updateTaskInfo failed, error:" + throwable.toString());
                    }
                }
            }
        }

        @Override
        public int removeStorageCache(String fileId, long preferredResolution) throws RemoteException {
            int n2 = -1;
            try {
                n2 = this.downloadProxy.removeStorageCache(fileId, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "removeStorageCache failed, error:" + throwable.toString());
            }
            return n2;
        }

        @Override
        public int clearCache(String diskPath, String resourceID, int mode, long preferredResolution) {
            int n2 = -1;
            try {
                n2 = this.downloadProxy.clearCache(diskPath, resourceID, mode, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "clearCache failed, error:" + throwable.toString());
            }
            return n2;
        }

        @Override
        public boolean checkResourceExist(String diskPath, String resourceID, long preferredResolution) throws RemoteException {
            boolean bl2 = false;
            try {
                bl2 = this.downloadProxy.checkResourceExist(diskPath, resourceID, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "checkResourceExist failed, error:" + throwable.toString());
            }
            return bl2;
        }

        @Override
        public float getResourceDownloadProgress(String diskPath, String resourceID, long preferredResolution) throws RemoteException {
            float f2 = 0.0f;
            try {
                f2 = this.downloadProxy.getResourceDownloadProgress(diskPath, resourceID, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getResourceDownloadProgress failed, error:" + throwable.toString());
            }
            return f2;
        }

        @Override
        public byte[] getOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
            byte[] byArray = null;
            try {
                byArray = this.downloadProxy.getOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "getOfflineLicenseKeySetId failed, error:" + throwable.toString());
            }
            return byArray;
        }

        @Override
        public int deleteOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
            int n2 = -1;
            try {
                n2 = this.downloadProxy.deleteOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(TPDownloadProxyService.FILE_NAME, 0, "tpdlnative", "deleteOfflineLicenseKeySetId failed, error:" + throwable.toString());
            }
            return n2;
        }
    }

    class DownloadProxyFactory
    extends TPDownloadProxyFactoryAidl.Stub {
        private HashMap<Integer, ITPDownloadProxyAidl> mvTPDownloadProxyMap = new HashMap();

        private DownloadProxyFactory() {
        }

        @Override
        public synchronized ITPDownloadProxyAidl getTPDownloadProxy(int serviceType) {
            ITPDownloadProxyAidl iTPDownloadProxyAidl = this.mvTPDownloadProxyMap.get(serviceType);
            if (iTPDownloadProxyAidl == null) {
                iTPDownloadProxyAidl = new DownloadProxy(serviceType);
                this.mvTPDownloadProxyMap.put(serviceType, iTPDownloadProxyAidl);
            }
            return iTPDownloadProxyAidl;
        }

        @Override
        public boolean isReadyForPlay() {
            return TPDownloadProxyFactory.isReadyForPlay();
        }

        @Override
        public boolean isReadyForDownload() {
            return TPDownloadProxyFactory.isReadyForDownload();
        }

        @Override
        public String getNativeVersion() {
            return TPDownloadProxyFactory.getNativeVersion();
        }
    }
}

