/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class UGCFrameQueue<T> {
    private final Deque<T> mDeque = new LinkedList<T>();
    private UGCFrameQueueListener mListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(T data) {
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            this.mDeque.addLast(data);
            this.mDeque.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T dequeue(long timeOut) {
        T t2;
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            try {
                if (this.mDeque.isEmpty()) {
                    this.mDeque.wait(timeOut);
                }
                t2 = this.mDeque.pollFirst();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (t2 != null) {
            this.notifyFrameBeenDequeued();
        }
        return t2;
    }

    public T dequeue() {
        return this.dequeue(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peek() {
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            return this.mDeque.peekFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            return this.mDeque.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            this.mDeque.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUGCFrameQueueListener(UGCFrameQueueListener listener) {
        UGCFrameQueue uGCFrameQueue = this;
        synchronized (uGCFrameQueue) {
            this.mListener = listener;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> dequeueAll() {
        LinkedList<T> linkedList = new LinkedList<T>();
        Deque<T> deque = this.mDeque;
        synchronized (deque) {
            while (!this.mDeque.isEmpty()) {
                linkedList.add(this.mDeque.pollFirst());
            }
        }
        return linkedList;
    }

    private void notifyFrameBeenDequeued() {
        UGCFrameQueueListener uGCFrameQueueListener = this.mListener;
        if (uGCFrameQueueListener != null) {
            uGCFrameQueueListener.onFrameDequeued();
        }
    }

    public static interface UGCFrameQueueListener {
        public void onFrameDequeued();
    }
}

