/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.os.HandlerThread;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.w;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.bl;
import com.tencent.liteav.videoconsumer.decoder.bm;
import com.tencent.liteav.videoconsumer.decoder.u;
import com.tencent.liteav.videoproducer.capture.ax;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.decoder.UGCVideoDecodeControllerListener;
import com.tencent.ugc.decoder.b;
import com.tencent.ugc.decoder.c;
import com.tencent.ugc.decoder.d;
import com.tencent.ugc.decoder.e;
import com.tencent.ugc.decoder.f;
import com.tencent.ugc.decoder.g;
import com.tencent.ugc.decoder.h;
import com.tencent.ugc.decoder.i;
import com.tencent.ugc.decoder.j;
import java.util.concurrent.atomic.AtomicBoolean;

public class UGCVideoDecodeController {
    private static final int INTERVAL_DRAIN_DECODED_FRAME = 15;
    private static final int MAX_CACHE_FRAME_COUNT = 1;
    private static final int MAX_DECODE_FRAME_FAIL_COUNT = 30;
    private static final int MAX_DECODING_FRAME_COUNT = 30;
    private static final int MAX_DECODING_FRAME_TIME = 2500;
    private final String mTAG;
    private final com.tencent.liteav.base.b.b mThrottlers;
    private final AtomicBoolean mHasDecodeError;
    private final UGCFrameQueue<EncodedVideoFrame> mPendingFrameQueue;
    private CustomHandler mWorkHandler;
    private w mDecodeTimer;
    private UGCVideoDecodeControllerListener mListener;
    private a mDecoderListener;
    private bl mDecoder;
    private boolean mIsUsingHardwareDecoder = true;
    private boolean mIsRedecodingFromBeginOfThisGop = false;
    private Long mLastOutputFramePts = null;
    private int mDecodingFrameCount = 0;
    private int mSendFrameFailCount = 0;
    private long mInputFramePts = 0L;
    private long mOutputFramePts = 0L;
    private final UGCFrameQueue.UGCFrameQueueListener mUGCFrameQueueListener = new UGCFrameQueue.UGCFrameQueueListener(){

        @Override
        public final void onFrameDequeued() {
            UGCVideoDecodeController.this.runOnWorkThread(g.a(this));
        }

        static /* synthetic */ void a(1 var0) {
            if (var0.UGCVideoDecodeController.this.mListener != null) {
                var0.UGCVideoDecodeController.this.mListener.onFrameEnqueuedToDecoder();
            }
        }
    };

    public UGCVideoDecodeController() {
        this.mTAG = "UGCVideoDecodeController_" + this.hashCode();
        this.mThrottlers = new com.tencent.liteav.base.b.b();
        this.mHasDecodeError = new AtomicBoolean(false);
        this.mPendingFrameQueue = new UGCFrameQueue();
        this.mPendingFrameQueue.setUGCFrameQueueListener(this.mUGCFrameQueueListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@NonNull UGCVideoDecodeControllerListener listener) {
        LiteavLog.i(this.mThrottlers.a("start"), this.mTAG, "start", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        synchronized (uGCVideoDecodeController) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(this.mThrottlers.a("startWorkHandler"), this.mTAG, "UGCDecodeController is start", new Object[0]);
                return;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-decoder-controller");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
            UGCVideoDecodeController uGCVideoDecodeController2 = this;
            this.mDecodeTimer = new w(this.mWorkHandler.getLooper(), new com.tencent.ugc.decoder.a(uGCVideoDecodeController2));
            this.mDecodeTimer.a(0, 15);
        }
        UGCVideoDecodeController uGCVideoDecodeController3 = this;
        uGCVideoDecodeController3.runOnWorkThread(b.a(uGCVideoDecodeController3, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LiteavLog.i(this.mThrottlers.a("stop"), this.mTAG, "stop", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(c.a(uGCVideoDecodeController));
        UGCVideoDecodeController uGCVideoDecodeController2 = this;
        synchronized (uGCVideoDecodeController2) {
            if (this.mWorkHandler != null) {
                this.mWorkHandler.quitLooperAndWaitDone();
                this.mWorkHandler = null;
            }
            return;
        }
    }

    public void decode(EncodedVideoFrame frame) {
        if (frame == null) {
            return;
        }
        this.mPendingFrameQueue.queue(frame);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(d.a(uGCVideoDecodeController, frame));
    }

    public void abandonDecodingFrames() {
        LiteavLog.i(this.mThrottlers.a("abandonFrames"), this.mTAG, "abandonDecodingFrames", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(e.a(uGCVideoDecodeController));
    }

    public void signalEndOfStream() {
        LiteavLog.i(this.mThrottlers.a("signalEndOfStream"), this.mTAG, "signalEndOfStream", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(f.a(uGCVideoDecodeController));
    }

    public boolean isInputQueueFull() {
        return this.mPendingFrameQueue.size() > 0;
    }

    private void notifyAbandonDecodingFramesCompleted() {
        LiteavLog.i(this.mThrottlers.a("onAbandonCompleted"), this.mTAG, "onAbandonDecodingFramesCompleted", new Object[0]);
        if (this.mListener != null) {
            this.mListener.onAbandonDecodingFramesCompleted();
        }
    }

    private void notifyDecodeCompleted() {
        LiteavLog.i(this.mThrottlers.a("onDecodeCompleted"), this.mTAG, "onDecodeCompleted", new Object[0]);
        if (this.mListener != null) {
            this.mListener.onDecodeCompleted();
        }
    }

    private void handleDecoderError() {
        if (!this.isDecoderError()) {
            return;
        }
        if (this.mIsUsingHardwareDecoder) {
            LiteavLog.i(this.mThrottlers.a("handleDecoderError"), this.mTAG, "handle Hardware Decoder Error", new Object[0]);
            this.mIsUsingHardwareDecoder = false;
            this.mIsRedecodingFromBeginOfThisGop = true;
            this.destroyDecoder();
            this.clearFrameQueue();
            if (this.mListener != null) {
                this.mListener.onRequestSeekToLastKeyFrame(this.mLastOutputFramePts == null ? 0L : this.mLastOutputFramePts);
            }
        } else {
            LiteavLog.i(this.mThrottlers.a("handleDecoderError"), this.mTAG, "notify DecodeFailed", new Object[0]);
            if (this.mListener != null) {
                this.mListener.onDecodeFailed();
            }
        }
        this.mHasDecodeError.set(false);
        this.mSendFrameFailCount = 0;
        this.mDecodingFrameCount = 0;
        this.mInputFramePts = 0L;
        this.mOutputFramePts = 0L;
    }

    private boolean isDecoderError() {
        if (this.mHasDecodeError.get()) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "mIsDecodeError is true", new Object[0]);
            return true;
        }
        if (this.mSendFrameFailCount > 30) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "mSendFrameFailCount = " + this.mSendFrameFailCount, new Object[0]);
            return true;
        }
        if (this.mDecodingFrameCount > 30 && this.mInputFramePts - this.mOutputFramePts > 2500L) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "internal decoder cache too big", new Object[0]);
            return true;
        }
        return false;
    }

    private void decodeInternal() {
        EncodedVideoFrame encodedVideoFrame;
        this.handleDecoderError();
        if (this.mDecoder == null) {
            UGCVideoDecodeController uGCVideoDecodeController = this;
            if (!uGCVideoDecodeController.createDecoder(uGCVideoDecodeController.mIsUsingHardwareDecoder)) {
                return;
            }
        }
        if ((encodedVideoFrame = this.mPendingFrameQueue.peek()) == null) {
            this.mDecoder.decode(null);
            return;
        }
        if (this.mDecoder.decode(encodedVideoFrame)) {
            ++this.mDecodingFrameCount;
            this.mInputFramePts = encodedVideoFrame.pts;
            this.mSendFrameFailCount = 0;
            this.mPendingFrameQueue.dequeue();
            return;
        }
        ++this.mSendFrameFailCount;
    }

    private void onDecodeFrameInternal(PixelFrame pixelFrame) {
        long l2;
        --this.mDecodingFrameCount;
        this.mOutputFramePts = pixelFrame.getTimestamp();
        long l3 = l2 = this.mLastOutputFramePts == null ? 0L : this.mLastOutputFramePts;
        if (!this.mIsRedecodingFromBeginOfThisGop || pixelFrame.getTimestamp() > l2) {
            if (this.mListener != null) {
                this.mListener.onFrameDecoded(pixelFrame);
            }
            this.mLastOutputFramePts = pixelFrame.getTimestamp();
            this.mIsRedecodingFromBeginOfThisGop = false;
        }
        this.decodeInternal();
    }

    private void stopInternal() {
        LiteavLog.i(this.mThrottlers.a("stopInternal"), this.mTAG, "stopInternal", new Object[0]);
        this.mIsUsingHardwareDecoder = true;
        this.mIsRedecodingFromBeginOfThisGop = false;
        this.mListener = null;
        this.mLastOutputFramePts = null;
        this.mHasDecodeError.set(false);
        this.mDecodingFrameCount = 0;
        this.mSendFrameFailCount = 0;
        this.mInputFramePts = 0L;
        this.mOutputFramePts = 0L;
        this.destroyDecoder();
        this.clearFrameQueue();
        if (this.mDecodeTimer != null) {
            this.mDecodeTimer.a();
            this.mDecodeTimer = null;
        }
    }

    private boolean createDecoder(boolean useHardwareDecoder) {
        EncodedVideoFrame encodedVideoFrame = this.getIDRFrameFromQueue();
        if (encodedVideoFrame == null) {
            return false;
        }
        this.mDecoder = useHardwareDecoder ? this.createHardwareDecoder(encodedVideoFrame) : new SoftwareVideoDecoder(new com.tencent.liteav.videobase.videobase.f(), encodedVideoFrame.isH265());
        this.mDecoder.initialize();
        this.mDecoderListener = new a(0);
        this.mDecoder.start(ax.a().b(), this.mDecoderListener);
        this.mDecoder.decode(encodedVideoFrame);
        return true;
    }

    private EncodedVideoFrame getIDRFrameFromQueue() {
        while (this.mPendingFrameQueue.size() != 0) {
            EncodedVideoFrame encodedVideoFrame = this.mPendingFrameQueue.dequeue();
            if (encodedVideoFrame == null) continue;
            if (encodedVideoFrame.isIDRFrame()) {
                return encodedVideoFrame;
            }
            encodedVideoFrame.release();
        }
        return null;
    }

    private bl createHardwareDecoder(EncodedVideoFrame idrFrame) {
        u.a a2 = new u.a();
        if (idrFrame.videoFormat != null) {
            a2.f = idrFrame.videoFormat;
        } else {
            a2.b = idrFrame.isH265();
            a2.e = new Size(idrFrame.width, idrFrame.height);
        }
        return new u(a2, new com.tencent.liteav.videobase.videobase.f(), null);
    }

    private void clearFrameQueue() {
        for (EncodedVideoFrame encodedVideoFrame : this.mPendingFrameQueue.dequeueAll()) {
            if (encodedVideoFrame == null) continue;
            encodedVideoFrame.release();
        }
    }

    private void destroyDecoder() {
        if (this.mDecoder != null) {
            this.mDecoder.stop();
            this.mDecoder.uninitialize();
            this.mDecoder = null;
            this.mDecoderListener = null;
        }
    }

    private boolean runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        return customHandler != null && customHandler.runOrPost(runnable);
    }

    static /* synthetic */ void lambda$signalEndOfStream$3(UGCVideoDecodeController this_) {
        if (this_.mDecoder != null) {
            EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
            new EncodedVideoFrame().isEosFrame = true;
            this_.mPendingFrameQueue.queue(encodedVideoFrame);
            return;
        }
        this_.notifyDecodeCompleted();
    }

    static /* synthetic */ void lambda$abandonDecodingFrames$2(UGCVideoDecodeController this_) {
        this_.clearFrameQueue();
        this_.mIsRedecodingFromBeginOfThisGop = false;
        this_.mDecodingFrameCount = 0;
        this_.mInputFramePts = 0L;
        this_.mOutputFramePts = 0L;
        if (this_.mDecoder != null) {
            this_.mDecoder.abandonDecodingFrames();
            return;
        }
        this_.notifyAbandonDecodingFramesCompleted();
    }

    static /* synthetic */ void lambda$decode$1(UGCVideoDecodeController this_, EncodedVideoFrame frame) {
        if (this_.mLastOutputFramePts == null) {
            this_.mLastOutputFramePts = frame.pts - 1L;
        }
        this_.mSendFrameFailCount = 0;
        this_.decodeInternal();
    }

    static /* synthetic */ void lambda$start$0(@NonNull UGCVideoDecodeController this_, UGCVideoDecodeControllerListener listener) {
        this_.mListener = listener;
    }

    static /* synthetic */ void access$500(UGCVideoDecodeController x0) {
        x0.notifyDecodeCompleted();
    }

    static /* synthetic */ void access$600(UGCVideoDecodeController x0) {
        x0.notifyAbandonDecodingFramesCompleted();
    }

    static /* synthetic */ void access$700(UGCVideoDecodeController x0, PixelFrame x1) {
        x0.onDecodeFrameInternal(x1);
    }

    static /* synthetic */ void access$lambda$0(UGCVideoDecodeController uGCVideoDecodeController) {
        uGCVideoDecodeController.decodeInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCVideoDecodeController uGCVideoDecodeController) {
        uGCVideoDecodeController.stopInternal();
    }

    final class a
    extends bm {
        private a() {
        }

        @Override
        public final void a(PixelFrame pixelFrame, long l2) {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener || pixelFrame == null) {
                return;
            }
            pixelFrame.retain();
            UGCVideoDecodeController.this.runOnWorkThread(h.a(this, pixelFrame));
        }

        @Override
        public final void i() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            LiteavLog.i(UGCVideoDecodeController.this.mThrottlers.a("onDecodeFailed"), UGCVideoDecodeController.this.mTAG, "onDecodeFailed", new Object[0]);
            UGCVideoDecodeController.this.mHasDecodeError.set(true);
        }

        @Override
        public final void j() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            UGCVideoDecodeController.this.runOnWorkThread(i.a(UGCVideoDecodeController.this));
        }

        @Override
        public final void k() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            UGCVideoDecodeController.this.runOnWorkThread(j.a(UGCVideoDecodeController.this));
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }
}

