/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.daya.orchestra.accompany.helper.QMUILangHelper;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"PrivateApi"})
public class QMUIDeviceHelper {
    private static final String TAG = "QMUIDeviceHelper";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    private static final String FLYME = "flyme";
    private static final String ZTEC2016 = "zte c2016";
    private static final String ZUKZ1 = "zuk z1";
    private static final String ESSENTIAL = "essential";
    private static final String[] MEIZUBOARD = new String[]{"m9", "M9", "mx", "MX"};
    private static String sMiuiVersionName;
    private static String sFlymeVersionName;
    private static boolean sIsTabletChecked;
    private static boolean sIsTabletValue;
    private static final String BRAND;

    private static boolean _isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isTablet(Context context) {
        if (sIsTabletChecked) {
            return sIsTabletValue;
        }
        sIsTabletValue = QMUIDeviceHelper._isTablet(context);
        sIsTabletChecked = true;
        return sIsTabletValue;
    }

    public static boolean isFlyme() {
        return !TextUtils.isEmpty((CharSequence)sFlymeVersionName) && sFlymeVersionName.contains(FLYME);
    }

    public static boolean isMIUI() {
        return !TextUtils.isEmpty((CharSequence)sMiuiVersionName);
    }

    public static boolean isMIUIV5() {
        return "v5".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV6() {
        return "v6".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV7() {
        return "v7".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV8() {
        return "v8".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV9() {
        return "v9".equals(sMiuiVersionName);
    }

    public static boolean isFlymeLowerThan(int majorVersion) {
        return QMUIDeviceHelper.isFlymeLowerThan(majorVersion, 0, 0);
    }

    public static boolean isFlymeLowerThan(int majorVersion, int minorVersion, int patchVersion) {
        boolean isLower = false;
        if (sFlymeVersionName != null && !sFlymeVersionName.equals("")) {
            try {
                String versionString;
                Pattern pattern = Pattern.compile("(\\d+\\.){2}\\d");
                Matcher matcher = pattern.matcher(sFlymeVersionName);
                if (matcher.find() && (versionString = matcher.group()).length() > 0) {
                    String[] version = versionString.split("\\.");
                    if (version.length >= 1 && Integer.parseInt(version[0]) < majorVersion) {
                        isLower = true;
                    }
                    if (version.length >= 2 && minorVersion > 0 && Integer.parseInt(version[1]) < majorVersion) {
                        isLower = true;
                    }
                    if (version.length >= 3 && patchVersion > 0 && Integer.parseInt(version[2]) < majorVersion) {
                        isLower = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return QMUIDeviceHelper.isMeizu() && isLower;
    }

    public static boolean isMeizu() {
        return QMUIDeviceHelper.isPhone(MEIZUBOARD) || QMUIDeviceHelper.isFlyme();
    }

    public static boolean isXiaomi() {
        return Build.MANUFACTURER.toLowerCase().equals("xiaomi");
    }

    public static boolean isVivo() {
        return BRAND.contains("vivo") || BRAND.contains("bbk");
    }

    public static boolean isOppo() {
        return BRAND.contains("oppo");
    }

    public static boolean isHuawei() {
        return BRAND.contains("huawei") || BRAND.contains("honor");
    }

    public static boolean isEssentialPhone() {
        return BRAND.contains(ESSENTIAL);
    }

    public static boolean isZUKZ1() {
        String board = Build.MODEL;
        return board != null && board.toLowerCase().contains(ZUKZ1);
    }

    public static boolean isZTKC2016() {
        String board = Build.MODEL;
        return board != null && board.toLowerCase().contains(ZTEC2016);
    }

    private static boolean isPhone(String[] boards) {
        String board = Build.BOARD;
        if (board == null) {
            return false;
        }
        for (String board1 : boards) {
            if (!board.equals(board1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFloatWindowOpAllowed(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return QMUIDeviceHelper.checkOp(context, 24);
        }
        try {
            return (context.getApplicationInfo().flags & 0x8000000) == 0x8000000;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @TargetApi(value=19)
    private static boolean checkOp(Context context, int op) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = manager.getClass().getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                int property = (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
                return 0 == property;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Nullable
    private static String getLowerCaseName(Properties p, Method get, String key) {
        String name = p.getProperty(key);
        if (name == null) {
            try {
                name = (String)get.invoke(null, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }

    static {
        sIsTabletChecked = false;
        sIsTabletValue = false;
        BRAND = Build.BRAND.toLowerCase();
        Properties properties = new Properties();
        if (Build.VERSION.SDK_INT < 26) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                properties.load(fileInputStream);
            }
            catch (Exception e) {
                try {
                    Log.i((String)TAG, (String)"read file error");
                }
                catch (Throwable throwable) {
                    QMUILangHelper.close(fileInputStream);
                    throw throwable;
                }
                QMUILangHelper.close(fileInputStream);
            }
            QMUILangHelper.close(fileInputStream);
        }
        Class<?> clzSystemProperties = null;
        try {
            clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            sMiuiVersionName = QMUIDeviceHelper.getLowerCaseName(properties, getMethod, KEY_MIUI_VERSION_NAME);
            sFlymeVersionName = QMUIDeviceHelper.getLowerCaseName(properties, getMethod, KEY_FLYME_VERSION_NAME);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"read SystemProperties error");
        }
    }
}

