/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.utils;

import android.graphics.Rect;
import android.media.ExifInterface;
import com.wonderkiln.camerakit.utils.AspectRatio;
import com.wonderkiln.camerakit.utils.JpegTransformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PostProcessor {
    private byte[] picture;
    private int jpegQuality;
    private int facing;
    private AspectRatio cropAspectRatio;

    public PostProcessor(byte[] picture) {
        this.picture = picture;
    }

    public void setJpegQuality(int jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public void setCropOutput(AspectRatio aspectRatio) {
        this.cropAspectRatio = aspectRatio;
    }

    public byte[] getJpeg() {
        JpegTransformer jpegTransformer = new JpegTransformer(this.picture);
        int width = jpegTransformer.getWidth();
        int height = jpegTransformer.getHeight();
        ExifPostProcessor exifPostProcessor = new ExifPostProcessor(this.picture);
        exifPostProcessor.apply(jpegTransformer);
        if (this.facing == 1) {
            jpegTransformer.flipHorizontal();
        }
        if (this.cropAspectRatio != null) {
            int cropWidth = width;
            int cropHeight = height;
            if (exifPostProcessor.areDimensionsFlipped()) {
                cropWidth = height;
                cropHeight = width;
            }
            new CenterCrop(cropWidth, cropHeight, this.cropAspectRatio).apply(jpegTransformer);
        }
        return jpegTransformer.getJpeg();
    }

    private static class ExifPostProcessor {
        private int orientation = 0;

        public ExifPostProcessor(byte[] picture) {
            try {
                this.orientation = ExifPostProcessor.getExifOrientation(new ByteArrayInputStream(picture));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void apply(JpegTransformer transformer) {
            switch (this.orientation) {
                case 2: {
                    transformer.flipHorizontal();
                    break;
                }
                case 3: {
                    transformer.rotate(180);
                    break;
                }
                case 4: {
                    transformer.flipVertical();
                    break;
                }
                case 5: {
                    transformer.rotate(90);
                    transformer.flipHorizontal();
                    break;
                }
                case 6: {
                    transformer.rotate(90);
                    break;
                }
                case 7: {
                    transformer.rotate(270);
                    transformer.flipHorizontal();
                    break;
                }
                case 8: {
                    transformer.rotate(90);
                    break;
                }
            }
        }

        public boolean areDimensionsFlipped() {
            switch (this.orientation) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            return false;
        }

        private static int getExifOrientation(InputStream inputStream) throws IOException {
            ExifInterface exif = new ExifInterface(inputStream);
            return exif.getAttributeInt("Orientation", 1);
        }
    }

    private static class CenterCrop {
        private int width;
        private int height;
        private AspectRatio aspectRatio;

        public CenterCrop(int width, int height, AspectRatio aspectRatio) {
            this.width = width;
            this.height = height;
            this.aspectRatio = aspectRatio;
        }

        public void apply(JpegTransformer transformer) {
            Rect crop = CenterCrop.getCrop(this.width, this.height, this.aspectRatio);
            transformer.crop(crop);
        }

        private static Rect getCrop(int currentWidth, int currentHeight, AspectRatio targetRatio) {
            Rect crop;
            AspectRatio currentRatio = AspectRatio.of(currentWidth, currentHeight);
            if (currentRatio.toFloat() > targetRatio.toFloat()) {
                int width = (int)((float)currentHeight * targetRatio.toFloat());
                int widthOffset = (currentWidth - width) / 2;
                crop = new Rect(widthOffset, 0, currentWidth - widthOffset, currentHeight);
            } else {
                int height = (int)((float)currentWidth * targetRatio.inverse().toFloat());
                int heightOffset = (currentHeight - height) / 2;
                crop = new Rect(0, heightOffset, currentWidth, currentHeight - heightOffset);
            }
            return crop;
        }
    }
}

