/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.http;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

class Options {
    private String method;
    private String url;
    private Map<String, String> headers;
    private JSONObject tlsConfig;
    private String body;
    private Type type = Type.text;
    private int timeout = 60000;
    private boolean sslVerify = false;
    private boolean isFirstIpv4 = false;
    private String inputType;

    private Options(String method, String url, Map<String, String> headers, String body, Type type, int timeout) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.type = type;
        if (timeout == 0) {
            timeout = 60000;
        }
        this.timeout = timeout;
    }

    private Options(String method, String url, Map<String, String> headers, String body, Type type, int timeout, boolean sslVerify, boolean sFirstIpv4) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.type = type;
        if (timeout == 0) {
            timeout = 60000;
        }
        this.timeout = timeout;
        this.sslVerify = sslVerify;
        this.isFirstIpv4 = sFirstIpv4;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public Type getType() {
        return this.type;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getSslVerify() {
        return this.sslVerify;
    }

    public boolean isFirstIpv4() {
        return this.isFirstIpv4;
    }

    public JSONObject getTlsConfig() {
        return this.tlsConfig;
    }

    public void setTlsConfig(JSONObject tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public static class Builder {
        private String method;
        private String url;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;
        private Type type;
        private String inputType;
        private int timeout;
        private boolean sslVerify;
        private boolean isFirstIpv4;
        private JSONObject androidTLSConfig;

        public Builder setAndroidTlsConfig(JSONObject config) {
            this.androidTLSConfig = config;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setSslVerify(boolean sslVerify) {
            this.sslVerify = sslVerify;
            return this;
        }

        public Builder setFirstIpv4(boolean firstIpv4) {
            this.isFirstIpv4 = firstIpv4;
            return this;
        }

        public Builder setType(String type) {
            this.type = Type.json.name().equals(type) ? Type.json : (Type.jsonp.name().equals(type) ? Type.jsonp : (Type.base64.name().equals(type) ? Type.base64 : Type.text));
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setInputTypes(String type) {
            this.inputType = type;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Options createOptions() {
            Options newOption = new Options(this.method, this.url, this.headers, this.body, this.type, this.timeout, this.sslVerify, this.isFirstIpv4);
            newOption.setInputType(this.inputType);
            newOption.setTlsConfig(this.androidTLSConfig);
            return newOption;
        }
    }

    public static enum Type {
        json,
        text,
        jsonp,
        base64;

    }
}

