/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.ui.action.IExecutable;
import com.taobao.weex.utils.WXLogUtils;

public abstract class BasicGraphicAction
implements IExecutable,
Runnable {
    private WXSDKInstance mInstance;
    private final String mRef;
    public int mActionType = 0;
    public static final int ActionTypeBatchBegin = 1;
    public static final int ActionTypeBatchEnd = 2;
    public static final int ActionTypeNormal = 0;

    public BasicGraphicAction(WXSDKInstance instance, String ref) {
        this.mInstance = instance;
        this.mRef = ref;
    }

    public final WXSDKInstance getWXSDKIntance() {
        return this.mInstance;
    }

    public final String getPageId() {
        return this.mInstance != null ? this.mInstance.getInstanceId() : null;
    }

    public final String getRef() {
        return this.mRef;
    }

    public void executeActionOnRender() {
        if (this.mInstance != null) {
            if (TextUtils.isEmpty((CharSequence)this.mInstance.getInstanceId())) {
                WXLogUtils.e("[BasicGraphicAction] pageId can not be null");
                if (WXEnvironment.isApkDebugable()) {
                    throw new RuntimeException("[" + this.getClass().getName() + "] pageId can not be null");
                }
                return;
            }
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(this.mInstance.getInstanceId(), this);
        }
    }

    @Override
    public void run() {
        try {
            this.executeAction();
        }
        catch (Throwable e) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("BasicGraphicAction", "SafeRunnable run throw expection:" + e.getMessage());
                throw e;
            }
            WXLogUtils.w("BasicGraphicAction", e);
        }
    }
}

