/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.dom;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Arrays;

public abstract class AbsCSSShorthand<T extends Enum<? extends CSSProperty>>
implements Cloneable {
    private float[] values;

    public AbsCSSShorthand(float[] values) {
        this.replace(values);
    }

    public AbsCSSShorthand() {
        this(false);
    }

    AbsCSSShorthand(boolean fillWithNaN) {
        this.values = new float[Math.max(EDGE.values().length, CORNER.values().length)];
        if (fillWithNaN) {
            Arrays.fill(this.values, Float.NaN);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void set(@NonNull Enum<? extends CSSProperty> edge, float value) {
        this.setInternal(edge, value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void set(@NonNull CORNER edge, float value) {
        this.setInternal(edge, value);
    }

    public float get(@NonNull Enum<? extends CSSProperty> edge) {
        return this.getInternal(edge);
    }

    public float get(@NonNull CORNER edge) {
        return this.getInternal(edge);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void replace(float[] values) {
        this.values = values;
    }

    public AbsCSSShorthand clone() throws CloneNotSupportedException {
        return (AbsCSSShorthand)super.clone();
    }

    private void setInternal(@NonNull Enum<? extends CSSProperty> edge, float value) {
        if (edge.name().equals(EDGE.ALL.name()) || edge.name().equals(CORNER.ALL.name())) {
            Arrays.fill(this.values, value);
        } else {
            this.values[edge.ordinal()] = value;
        }
    }

    private float getInternal(@NonNull Enum<? extends CSSProperty> edge) {
        return edge.name().equals(EDGE.ALL.name()) || edge.name().equals(CORNER.ALL.name()) ? 0.0f : this.values[edge.ordinal()];
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString() {
        return TextUtils.isEmpty((CharSequence)this.values.toString()) ? "" : Arrays.toString(this.values);
    }

    public static enum TYPE {
        MARGIN,
        PADDING,
        BORDER;

    }

    public static enum CORNER implements CSSProperty
    {
        BORDER_TOP_LEFT,
        BORDER_TOP_RIGHT,
        BORDER_BOTTOM_RIGHT,
        BORDER_BOTTOM_LEFT,
        ALL;

    }

    public static enum EDGE implements CSSProperty
    {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        ALL;

    }

    protected static interface CSSProperty {
    }
}

