/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.net.Uri;
import android.util.Base64;
import com.alibaba.fastjson.JSONArray;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.CertDTO;
import com.taobao.weex.http.WXStreamModule;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.ConnectionPool;
import dc.squareup.okhttp3.Dns;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.tls.OkHostnameVerifier;
import io.dcloud.common.adapter.util.DCOKDns;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import io.dcloud.feature.weex.config.AndroidTlsConfig;
import io.dcloud.feature.weex.config.UserCustomTrustManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class DCWXHttpAdapter
implements IWXHttpAdapter {
    private ExecutorService mExecutorService;
    private static ConnectionPool mConnectPool;
    private static javax.net.ssl.SSLSocketFactory sslSocketFactory;

    private void execute(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(10);
        }
        this.mExecutorService.execute(runnable);
    }

    @Override
    public void sendRequest(final WXRequest request, final IWXHttpAdapter.OnHttpListener listener) {
        if (listener != null) {
            listener.onHttpStart();
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                boolean isNetRequestSucceed;
                WXSDKInstance instance;
                block8: {
                    instance = WXSDKManager.getInstance().getAllInstanceMap().get(request.instanceId);
                    if (null != instance && !instance.isDestroy()) {
                        instance.getApmForInstance().actionNetRequest();
                    }
                    isNetRequestSucceed = true;
                    WXResponse response = new WXResponse();
                    try {
                        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
                        Request okRequest = DCWXHttpAdapter.this.getOKRequest(httpBuilder, request, listener);
                        OkHttpClient client = httpBuilder.build();
                        Call call = client.newCall(okRequest);
                        Response okResponse = call.execute();
                        Headers headers = okResponse.headers();
                        Map headerMap = headers.toMultimap();
                        int responseCode = okResponse.code();
                        response.statusCode = String.valueOf(responseCode);
                        if (listener != null) {
                            listener.onHeadersReceived(responseCode, headerMap);
                        }
                        if (okResponse.isSuccessful()) {
                            InputStream rawStream = okResponse.body().byteStream();
                            response.originalData = DCWXHttpAdapter.this.readInputStreamAsBytes(rawStream, listener);
                        } else {
                            response.errorMsg = DCWXHttpAdapter.this.readInputStream(okResponse.body().byteStream(), listener);
                            isNetRequestSucceed = false;
                        }
                        if (listener != null) {
                            listener.onHttpFinish(response);
                        }
                    }
                    catch (Exception e) {
                        isNetRequestSucceed = false;
                        e.printStackTrace();
                        response.statusCode = "-1";
                        response.errorCode = "-1";
                        response.errorMsg = e.getMessage();
                        if (listener == null) break block8;
                        listener.onHttpFinish(response);
                    }
                }
                if (null != instance && !instance.isDestroy()) {
                    instance.getApmForInstance().actionNetResult(isNetRequestSucceed, null);
                }
            }
        });
    }

    public Request getOKRequest(OkHttpClient.Builder httpBuilder, WXRequest request, IWXHttpAdapter.OnHttpListener listener) {
        httpBuilder.connectTimeout((long)request.timeoutMs, TimeUnit.MILLISECONDS).readTimeout((long)request.timeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)request.timeoutMs, TimeUnit.MILLISECONDS).callTimeout((long)request.timeoutMs, TimeUnit.MILLISECONDS).protocols(Collections.singletonList(Protocol.HTTP_1_1));
        if (request.isFirstIpv4) {
            httpBuilder.dns((Dns)new DCOKDns());
        }
        String requestHost = Uri.parse((String)request.url).getHost();
        if (request.tls != null) {
            AndroidTlsConfig androidTlsConfig = new AndroidTlsConfig();
            androidTlsConfig.setKeystore(request.tls.getString("keystore"));
            androidTlsConfig.setStorePass(request.tls.getString("storePass"));
            JSONArray caArray = request.tls.getJSONArray("ca");
            String[] caParam = null;
            if (caArray != null) {
                caParam = (String[])caArray.toArray((Object[])new String[0]);
            }
            androidTlsConfig.setCa(caParam);
            WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(request.instanceId);
            httpBuilder.sslSocketFactory(UserCustomTrustManager.getSSLSocketFactory(androidTlsConfig, instance));
            httpBuilder.hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
        } else if (WXStreamModule.certMap != null && WXStreamModule.certMap.containsKey(requestHost)) {
            CertDTO certDTO = WXStreamModule.certMap.get(requestHost);
            WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(request.instanceId);
            httpBuilder.sslSocketFactory(UserCustomTrustManager.getSSLSocketFactory(certDTO, instance));
            httpBuilder.hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
        } else if (request.sslVerify) {
            try {
                if (sslSocketFactory == null) {
                    sslSocketFactory = DCloudTrustManager.getSSLSocketFactory();
                }
                if (sslSocketFactory != null) {
                    httpBuilder.sslSocketFactory(sslSocketFactory);
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            httpBuilder.hostnameVerifier((HostnameVerifier)this.getHostnameVerifier(request.sslVerify));
        }
        if (mConnectPool == null) {
            mConnectPool = new ConnectionPool();
        }
        httpBuilder.connectionPool(mConnectPool);
        OkHttpClient okHttpClient = httpBuilder.build();
        Request.Builder builder = new Request.Builder();
        builder.url(request.url);
        String contentType = "application/x-www-form-urlencoded";
        if (request.paramMap != null) {
            Set<String> keySets = request.paramMap.keySet();
            for (String key : keySets) {
                if (key.equalsIgnoreCase("Content-Type")) {
                    contentType = request.paramMap.get(key);
                }
                builder.addHeader(key, request.paramMap.get(key));
            }
        }
        if ("POST".equals(request.method) || "PUT".equals(request.method) || "PATCH".equals(request.method) || "DELETE".equals(request.method)) {
            if (request.body != null && listener != null) {
                listener.onHttpUploadProgress(0);
            }
            if ("BASE64".equalsIgnoreCase(request.inputType)) {
                byte[] bodyBytes = Base64.decode((String)request.body, (int)2);
                RequestBody body = RequestBody.createWithBytes((MediaType)MediaType.parse((String)contentType), (byte[])bodyBytes);
                builder.method(request.method, body);
                if (listener != null) {
                    listener.onHttpUploadProgress(100);
                }
            } else {
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)request.body);
                builder.method(request.method, body);
                if (listener != null) {
                    listener.onHttpUploadProgress(100);
                }
            }
        }
        return builder.build();
    }

    private byte[] readInputStreamAsBytes(InputStream inputStream, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        int nRead;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int readCount = 0;
        byte[] data = new byte[2048];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
            readCount += nRead;
            if (listener == null) continue;
            listener.onHttpResponseProgress(readCount);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private String readInputStream(InputStream inputStream, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        int len;
        if (inputStream == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        char[] data = new char[2048];
        while ((len = localBufferedReader.read(data)) != -1) {
            builder.append(data, 0, len);
            if (listener == null) continue;
            listener.onHttpResponseProgress(builder.length());
        }
        localBufferedReader.close();
        return builder.toString();
    }

    public X509HostnameVerifier getHostnameVerifier(boolean sslVerify) {
        if (!sslVerify) {
            return SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        }
        return SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
    }
}

