/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_websocket;

import android.os.Looper;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.WebSocketCloseCodes;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.Map;

public class UniWebSocketModule
extends WXSDKEngine.DestroyableModule {
    private static final String TAG = "WebSocketModule";
    private static final String KEY_ID = "id";
    private static final String KEY_DATA = "data";
    private static final String KEY_CODE = "code";
    private static final String KEY_REASON = "reason";
    private static final String KEY_WAS_CLEAN = "wasClean";
    private String currentId;
    private Map<String, IWebSocketAdapter> webSocketAdapterMap;
    private Map<String, WebSocketEventListener> webSocketEventListenerMap;
    private JSCallback callback_onopen;
    private JSCallback callback_onmessage;
    private JSCallback callback_onclose;
    private JSCallback callback_onerror;

    public UniWebSocketModule() {
        WXLogUtils.e(TAG, "create new instance");
    }

    @JSMethod(uiThread=false)
    public void WebSocket(String param) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = new String(param.getBytes(), "utf-8");
                JSONObject jsObj = JSON.parseObject((String)param);
                String id2 = jsObj.getString(KEY_ID);
                String url = jsObj.getString("url");
                String protocol = jsObj.getString("protocol");
                String headerJson = jsObj.getString("header");
                if (this.webSocketAdapterMap == null) {
                    this.webSocketAdapterMap = new HashMap<String, IWebSocketAdapter>();
                    this.webSocketEventListenerMap = new HashMap<String, WebSocketEventListener>();
                }
                if (this.webSocketAdapterMap.get(id2) != null && this.webSocketEventListenerMap.get(id2) != null) {
                    return;
                }
                if (this.webSocketAdapterMap.get(id2) != null && this.webSocketEventListenerMap.get(id2) == null) {
                    this.webSocketAdapterMap.remove(id2);
                }
                IWebSocketAdapter webSocketAdapter = this.mWXSDKInstance.getWXWebSocketAdapter();
                WebSocketEventListener eventListener = new WebSocketEventListener(id2);
                eventListener.onOpen = this.callback_onopen;
                eventListener.onMessage = this.callback_onmessage;
                eventListener.onClose = this.callback_onclose;
                eventListener.onError = this.callback_onerror;
                webSocketAdapter.connect(url, protocol, headerJson, eventListener);
                this.webSocketEventListenerMap.put(id2, eventListener);
                this.currentId = id2;
                this.webSocketAdapterMap.put(id2, webSocketAdapter);
            }
            catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread=false)
    public void send(String param) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = new String(param.getBytes(), "utf-8");
                JSONObject jsObj = JSON.parseObject((String)param);
                String id2 = jsObj.getString(KEY_ID);
                String data = jsObj.getString(KEY_DATA);
                this.webSocketAdapterMap.get(id2).send(data);
            }
            catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread=false)
    public void close(String param) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = new String(param.getBytes(), "utf-8");
                JSONObject jsObj = JSON.parseObject((String)param);
                String id2 = jsObj.getString(KEY_ID);
                String code = jsObj.getString(KEY_CODE);
                String reason = jsObj.getString(KEY_REASON);
                int codeNumber = WebSocketCloseCodes.CLOSE_NORMAL.getCode();
                if (code != null) {
                    try {
                        codeNumber = Integer.parseInt(code);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.webSocketAdapterMap.get(id2).close(codeNumber, reason);
            }
            catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread=false)
    public void onopen(JSCallback callback) {
        this.callback_onopen = callback;
        if (this.webSocketEventListenerMap != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : this.webSocketEventListenerMap.entrySet()) {
                entry.getValue().onOpen = this.callback_onopen;
            }
        }
    }

    @JSMethod(uiThread=false)
    public void onmessage(JSCallback callback) {
        this.callback_onmessage = callback;
        if (this.webSocketEventListenerMap != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : this.webSocketEventListenerMap.entrySet()) {
                entry.getValue().onMessage = this.callback_onmessage;
            }
        }
    }

    @JSMethod(uiThread=false)
    public void onclose(JSCallback callback) {
        this.callback_onclose = callback;
        if (this.webSocketEventListenerMap != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : this.webSocketEventListenerMap.entrySet()) {
                entry.getValue().onClose = this.callback_onclose;
            }
        }
    }

    @JSMethod(uiThread=false)
    public void onerror(JSCallback callback) {
        this.callback_onerror = callback;
        if (this.webSocketEventListenerMap != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : this.webSocketEventListenerMap.entrySet()) {
                entry.getValue().onError = this.callback_onerror;
            }
        }
    }

    @Override
    public void destroy() {
        Runnable destroyTask = new Runnable(){

            @Override
            public void run() {
                WXLogUtils.w(UniWebSocketModule.TAG, "close session with instance id " + UniWebSocketModule.this.mWXSDKInstance.getInstanceId());
                if (UniWebSocketModule.this.webSocketAdapterMap != null) {
                    for (Map.Entry entry : UniWebSocketModule.this.webSocketAdapterMap.entrySet()) {
                        ((IWebSocketAdapter)entry.getValue()).destroy();
                    }
                    UniWebSocketModule.this.webSocketAdapterMap.clear();
                    UniWebSocketModule.this.webSocketAdapterMap = null;
                }
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.clear();
                }
                UniWebSocketModule.this.webSocketEventListenerMap = null;
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            WXBridgeManager.getInstance().post(destroyTask);
        } else {
            destroyTask.run();
        }
    }

    private class WebSocketEventListener
    implements IWebSocketAdapter.EventListener {
        private JSCallback onOpen;
        private JSCallback onClose;
        private JSCallback onError;
        private JSCallback onMessage;
        private String id;

        public WebSocketEventListener(String id2) {
            this.id = id2;
        }

        @Override
        public void onOpen() {
            if (this.onOpen != null) {
                HashMap<String, String> msg = new HashMap<String, String>();
                msg.put(UniWebSocketModule.KEY_ID, this.id);
                this.onOpen.invokeAndKeepAlive(msg);
            }
        }

        @Override
        public void onMessage(String data) {
            if (this.onMessage != null) {
                HashMap<String, String> msg = new HashMap<String, String>(2);
                msg.put(UniWebSocketModule.KEY_ID, this.id);
                try {
                    JSONObject object = JSON.parseObject((String)data);
                    if (object.containsKey((Object)"@type") && object.containsKey((Object)"base64")) {
                        msg.put(UniWebSocketModule.KEY_DATA, (String)object);
                    } else {
                        msg.put(UniWebSocketModule.KEY_DATA, data);
                    }
                }
                catch (Exception e) {
                    msg.put(UniWebSocketModule.KEY_DATA, data);
                }
                this.onMessage.invokeAndKeepAlive(msg);
            }
        }

        @Override
        public void onClose(int code, String reason, boolean wasClean) {
            if (this.onClose != null) {
                HashMap<String, Object> msg = new HashMap<String, Object>(4);
                msg.put(UniWebSocketModule.KEY_ID, this.id);
                msg.put(UniWebSocketModule.KEY_CODE, code);
                msg.put(UniWebSocketModule.KEY_REASON, reason);
                msg.put(UniWebSocketModule.KEY_WAS_CLEAN, wasClean);
                this.onClose.invokeAndKeepAlive(msg);
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.remove(this.id);
                }
            }
        }

        @Override
        public void onError(String msg) {
            if (this.onError != null) {
                HashMap<String, String> info = new HashMap<String, String>(2);
                info.put(UniWebSocketModule.KEY_ID, this.id);
                info.put(UniWebSocketModule.KEY_DATA, msg);
                this.onError.invokeAndKeepAlive(info);
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.remove(this.id);
                }
            }
        }
    }
}

