/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.gl;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlPreview
extends GlFilter {
    public static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nuniform float uCRatio;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\nvec4 scaledPos = aPosition;\nscaledPos.x = scaledPos.x * uCRatio;\ngl_Position = uMVPMatrix * scaledPos;\nvTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private final int texTarget;

    public GlPreview(int texTarget) {
        super(VERTEX_SHADER, GlPreview.createFragmentShaderSourceOESIfNeed(texTarget));
        this.texTarget = texTarget;
    }

    private static String createFragmentShaderSourceOESIfNeed(int texTarget) {
        if (texTarget == 36197) {
            return "#extension GL_OES_EGL_image_external : require\n" + "precision mediump float;\nvarying highp vec2 vTextureCoord;\nuniform lowp sampler2D sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n".replace("sampler2D", "samplerExternalOES");
        }
        return "precision mediump float;\nvarying highp vec2 vTextureCoord;\nuniform lowp sampler2D sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    }

    @Override
    public void setup() {
        super.setup();
        this.getHandle("uMVPMatrix");
        this.getHandle("uSTMatrix");
        this.getHandle("uCRatio");
        this.getHandle("aPosition");
        this.getHandle("aTextureCoord");
    }

    public void draw(int texName, float[] mvpMatrix, float[] stMatrix, float aspectRatio) {
        this.useProgram();
        GLES20.glUniformMatrix4fv((int)this.getHandle("uMVPMatrix"), (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.getHandle("uSTMatrix"), (int)1, (boolean)false, (float[])stMatrix, (int)0);
        GLES20.glUniform1f((int)this.getHandle("uCRatio"), (float)aspectRatio);
        GLES20.glBindBuffer((int)34962, (int)this.getVertexBufferName());
        GLES20.glEnableVertexAttribArray((int)this.getHandle("aPosition"));
        GLES20.glVertexAttribPointer((int)this.getHandle("aPosition"), (int)3, (int)5126, (boolean)false, (int)20, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.getHandle("aTextureCoord"));
        GLES20.glVertexAttribPointer((int)this.getHandle("aTextureCoord"), (int)2, (int)5126, (boolean)false, (int)20, (int)12);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.texTarget, (int)texName);
        GLES20.glUniform1i((int)this.getHandle("sTexture"), (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.getHandle("aPosition"));
        GLES20.glDisableVertexAttribArray((int)this.getHandle("aTextureCoord"));
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
    }
}

