/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.WXRenderStrategy;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.weex.WXBaseWrapper;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.HashMap;
import java.util.Map;

public class WXServiceWrapper
extends WXBaseWrapper
implements IWXRenderListener {
    ViewGroup mRootView;
    IApp mApp;
    org.json.JSONObject mData;
    String mTemplate;
    ISysEventListener mSysEventListener;
    long time = 0L;

    public WXServiceWrapper(IApp app, ViewGroup rootView, String weexId, org.json.JSONObject data) {
        super(rootView.getContext());
        this.mApp = app;
        this.mRootView = rootView;
        this.mWxId = weexId;
        this.mData = data;
        this.mSrcPath = this.mData.optString("path");
        this.mTemplate = this.mData.optString("template");
        this.render(this.mTemplate, this.getOptions(), null);
    }

    public IApp obtanApp() {
        return this.mApp;
    }

    @Override
    public String evalJs(String js, int type) {
        return null;
    }

    void render(String template, Map<String, Object> options, String jsonInitData) {
        if (this.mWXSDKInstance == null) {
            this.mWXSDKInstance = new UniSDKInstance(this.mRootView.getContext());
            this.mWXSDKInstance.registerRenderListener(this);
            this.mWXSDKInstance.setBundleUrl(this.mSrcPath);
        }
        this.mWXSDKInstance.render(this.mWxId, template, options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
        JSONObject modules = WXModuleManager.getRegisterJsModules();
        if (modules != null) {
            WeexInstanceMgr.self().setUniNViewModules(modules.toJSONString());
        }
    }

    @Override
    public void onViewCreated(WXSDKInstance instance, View view) {
        if (this.mRootView != null) {
            this.mRootView.addView((View)this, new ViewGroup.LayoutParams(-1, -1));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            this.addView(view, (ViewGroup.LayoutParams)layoutParams);
            this.setVisibility(8);
        }
    }

    @Override
    public void reload() {
        if (this.time != 0L && System.currentTimeMillis() - this.time < 600L) {
            return;
        }
        this.time = System.currentTimeMillis();
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.registerRenderListener(null);
            this.mWXSDKInstance.destroy();
            this.mWXSDKInstance = null;
            this.removeAllViews();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTemplate)) {
            this.render(this.mTemplate, this.getOptions(), null);
        }
    }

    public Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("plus_appid", this.mApp.obtainAppId());
        options.put("bundleUrl", this.mSrcPath);
        return options;
    }

    @Override
    public String getType() {
        return "service";
    }

    @Override
    public void onDestroy() {
        if (this.mApp != null) {
            this.mApp = null;
        }
        if (this.mRootView != null) {
            this.mRootView.removeView((View)this);
        }
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onActivityDestroy();
            this.mWXSDKInstance = null;
        }
        this.mData = null;
    }

    public void findWebViewToLoadUrL(String sp, String id2) {
        if (this.mApp == null) {
            return;
        }
        IWebview webview = WeexInstanceMgr.self().findWebview(null, this.mApp, this.mApp.obtainAppId(), id2);
        if (webview != null) {
            webview.loadUrl(sp);
        }
    }

    @Override
    public void onRenderSuccess(WXSDKInstance instance, int width, int height) {
    }

    @Override
    public void onRefreshSuccess(WXSDKInstance instance, int width, int height) {
    }

    @Override
    public void onException(WXSDKInstance instance, String errCode, String msg) {
    }
}

