/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.binding;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.el.parse.Parser;
import com.taobao.weex.el.parse.Token;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Set;

public class ELUtils {
    public static final String BINDING = "@binding";
    public static final String IS_COMPONENT_ROOT = "@isComponentRoot";
    public static final String COMPONENT_PROPS = "@componentProps";
    public static final String[] EXCLUDES_BINDING = new String[]{"clickEventParams"};

    public static boolean isBinding(Object value) {
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            if (object.containsKey((Object)BINDING)) {
                return true;
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.size(); ++i) {
                if (!ELUtils.isBinding(array.get(i))) continue;
                return true;
            }
        } else if (value instanceof String) {
            return ((String)value).indexOf(BINDING) >= 0;
        }
        return false;
    }

    public static Object bindingBlock(Object value) {
        if (value instanceof JSONObject) {
            Object binding;
            JSONObject object = (JSONObject)value;
            if (object.containsKey((Object)BINDING) && !((binding = object.get((Object)BINDING)) instanceof Token)) {
                object.put(BINDING, (Object)Parser.parse(binding.toString()));
            }
            Set keys = object.keySet();
            for (Object propsKey : keys) {
                JSONObject propsValue;
                Object binding2;
                if (!(object.get(propsKey) instanceof JSONObject) || !((JSONObject)object.get(propsKey)).containsKey((Object)BINDING) || (binding2 = (propsValue = (JSONObject)object.get(propsKey)).get((Object)BINDING)) instanceof Token) continue;
                propsValue.put(BINDING, (Object)Parser.parse(binding2.toString()));
            }
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i = 0; i < array.size(); ++i) {
                ELUtils.bindingBlock(array.get(i));
            }
        } else if (value instanceof String) {
            String json = value.toString();
            if (json.startsWith("{")) {
                return ELUtils.bindingBlock(JSON.parseObject((String)json));
            }
            if (json.startsWith("[")) {
                return ELUtils.bindingBlock(JSON.parseArray((String)json));
            }
        }
        return value;
    }

    public static Object vforBlock(Object vfor) {
        if (vfor instanceof JSONObject) {
            Object list;
            if (((JSONObject)vfor).containsKey((Object)"@expression") && !((list = ((JSONObject)vfor).get((Object)"@expression")) instanceof Token)) {
                ((JSONObject)vfor).put("@expression", (Object)Parser.parse(list.toString()));
            }
        } else {
            if (vfor instanceof String) {
                return ELUtils.vforBlock(JSONObject.parseObject((String)vfor.toString()));
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("weex", "weex vfor is illegal " + vfor);
            }
        }
        return vfor;
    }
}

