/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_barcode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.alibaba.fastjson.JSONArray;
import com.dcloud.zxing2.Result;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.feature.barcode2.decoding.CaptureActivityHandler;
import java.util.HashMap;

public class BarcodeModule
extends WXModule {
    @JSMethod
    public void scan(String filepath, JSCallback callback, JSONArray filter, boolean needAutoCharset) {
        try {
            String path = this.mWXSDKInstance.rewriteUri(Uri.parse((String)filepath), "image").getPath();
            Bitmap map = BitmapFactory.decodeFile((String)path);
            Result result = CaptureActivityHandler.decode((Bitmap)map, (boolean)needAutoCharset);
            if (result != null) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("type", "success");
                values.put("code", result.getBarcodeFormat().toString());
                values.put("message", JSONUtil.toJSONableString((String)result.getText()));
                values.put("file", path == null ? "" : path);
                values.put("charSet", result.textCharset);
                HashMap<String, HashMap<String, String>> details = new HashMap<String, HashMap<String, String>>();
                details.put("detail", values);
                callback.invoke(details);
            } else {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("type", "fail");
                values.put("code", 8);
                values.put("message", "");
                values.put("charSet", result.textCharset);
                HashMap<String, HashMap<String, Object>> details = new HashMap<String, HashMap<String, Object>>();
                details.put("detail", values);
                callback.invoke(details);
            }
        }
        catch (Exception e) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("type", "fail");
            values.put("code", 8);
            values.put("message", e.getMessage());
            HashMap<String, HashMap<String, Object>> details = new HashMap<String, HashMap<String, Object>>();
            details.put("detail", values);
            callback.invoke(details);
        }
    }
}

