/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.helper;

import android.os.Handler;
import android.os.Looper;
import androidx.recyclerview.widget.RecyclerView;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;

public class ScrollStartEndHelper
implements Runnable {
    private Handler handler;
    private WXComponent component;
    private boolean hasStart;
    private boolean canStart = false;
    private long minInterval;
    private int oldState = 0;
    private int x;
    private int y;
    private boolean hasScrollEnd;

    public ScrollStartEndHelper(WXComponent component) {
        this.component = component;
        this.handler = new Handler(Looper.getMainLooper());
        this.minInterval = WXUtils.getNumberInt(component.getAttrs().get("minscrolldelayinterval"), 32);
    }

    public void onScrolled(int x, int y) {
        if (this.component.getEvents().contains("scrollstart") || this.component.getEvents().contains("scrollend")) {
            this.x = x;
            this.y = y;
            if (!this.hasStart && this.canStart) {
                Map<String, Object> event;
                if (this.component.getEvents().contains("scrollstart") && null != (event = this.getScrollEvent(x, y)) && !event.isEmpty()) {
                    this.component.fireEvent("scrollstart", event);
                }
                this.hasStart = true;
                this.canStart = false;
            }
            this.handler.removeCallbacks((Runnable)this);
            this.handler.postDelayed((Runnable)this, this.minInterval);
        }
    }

    @Override
    public void run() {
        if (this.component.isDestoryed()) {
            return;
        }
        if (!this.hasScrollEnd) {
            return;
        }
        if (this.canStart) {
            this.component.fireEvent("scrollstart", this.getScrollEvent(this.x, this.y));
            this.canStart = false;
        }
        if (this.component.getEvents().contains("scrollend")) {
            this.component.fireEvent("scrollend", this.getScrollEvent(this.x, this.y));
        }
        this.hasStart = false;
        this.hasScrollEnd = false;
    }

    private Map<String, Object> getScrollEvent(int offsetX, int offsetY) {
        if (this.component instanceof BasicListComponent) {
            ListComponentView componentView;
            BasicListComponent basicListComponent = (BasicListComponent)this.component;
            if (basicListComponent.getHostView() instanceof ListComponentView && (componentView = (ListComponentView)basicListComponent.getHostView()) != null) {
                return basicListComponent.getScrollEvent(componentView.getInnerView(), offsetX, offsetY);
            }
        } else {
            if (this.component instanceof WXRecyclerTemplateList) {
                WXRecyclerTemplateList templateList = (WXRecyclerTemplateList)this.component;
                return templateList.getScrollEvent((RecyclerView)((BounceRecyclerView)templateList.getHostView()).getInnerView(), offsetX, offsetY);
            }
            if (this.component instanceof DCWXScroller) {
                return ((DCWXScroller)this.component).getScrollEvent(offsetX, offsetY);
            }
            if (this.component instanceof WXBaseScroller) {
                WXBaseScroller scroller = (WXBaseScroller)this.component;
                return scroller.getScrollEvent(offsetX, offsetY);
            }
        }
        return null;
    }

    public void onScrollStateChanged(int newState) {
        if (this.oldState == 0) {
            this.canStart = true;
        }
        if (newState == 0) {
            this.hasScrollEnd = true;
            this.handler.removeCallbacks((Runnable)this);
            this.handler.postDelayed((Runnable)this, this.minInterval);
        }
        this.oldState = newState;
    }

    public static boolean isScrollEvent(String type) {
        if ("scroll".equals(type)) {
            return true;
        }
        if ("scrollstart".equals(type)) {
            return true;
        }
        return "scrollend".equals(type);
    }
}

