/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.exception;

import android.util.Log;
import com.ksyun.ks3.exception.Ks3ServerError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Ks3Error {
    public static final int ERROR_CODE_UNKNOWN_ERROR = -1;
    public static final int ERROR_CODE_BAD_DIGEST = 0;
    public static final int ERROR_CODE_INVALID_ACL_STR = 1;
    public static final int ERROR_CODE_INVALID_AUTHORIZATION_STR = 2;
    public static final int ERROR_CODE_INVALID_BUCKET_NAME = 3;
    public static final int ERROR_CODE_INVALID_DATE_FORMAT = 4;
    public static final int ERROR_CODE_INVALID_DIGEST = 5;
    public static final int ERROR_CODE_INVALID_ENCYPTION_ALGORITHM = 6;
    public static final int ERROR_CODE_INVALID_HOST_HEADER = 7;
    public static final int ERROR_CODE_INVALID_PARAMETER = 8;
    public static final int ERROR_CODE_INVALID_PATH = 9;
    public static final int ERROR_CODE_INVALID_QUERY_STR = 10;
    public static final int ERROR_CODE_META_DATA_TOO_LARGE = 11;
    public static final int ERROR_CODE_MISSING_DATA_HEADER = 12;
    public static final int ERROR_CODE_MISSING_HOST_HEADER = 13;
    public static final int ERROR_CODE_TOO_MANY_BUCKETS = 14;
    public static final int ERROR_CODE_BAD_PARAMS = 15;
    public static final int ERROR_CODE_IMAGE_TYPE_NOT_SUPPORT = 16;
    public static final int ERROR_CODE_MISSING_FROM_ARGS = 17;
    public static final int ERROR_CODE_CONTENT_RANGE_ERROR = 18;
    public static final int ERROR_CODE_CONTENT_LENGTH_OUT_OF_RANGE = 19;
    public static final int ERROR_CODE_POLICY_ERROR = 20;
    public static final int ERROR_CODE_EXPIRATION_ERROR = 21;
    public static final int ERROR_CODE_FORM_UNMATCH_POLICY = 22;
    public static final int ERROR_CODE_ACCESS_DENIED = 23;
    public static final int ERROR_CODE_INVALID_ACCESS_KEY = 24;
    public static final int ERROR_CODE_REQUEST_TIME_TOO_SKEWED = 25;
    public static final int ERROR_CODE_SIGNATURE_DOES_NOT_MATCH = 26;
    public static final int ERROR_CODE_URL_EXPIRED = 27;
    public static final int ERROR_CODE_NO_SUCH_BUCKET = 28;
    public static final int ERROR_CODE_NO_SUCH_KEY = 29;
    public static final int ERROR_CODE_METHOD_NOT_ALLOWED = 30;
    public static final int ERROR_CODE_BUCKET_ALREADY_EXISTS = 31;
    public static final int ERROR_CODE_BUCKET_ALREADY_OWNED_BY_YOU = 32;
    public static final int ERROR_CODE_BUCKET_NOT_EMPTY = 33;
    public static final int ERROR_CODE_INVALID_RANGE = 34;
    public static final int ERROR_CODE_INTERNAL_ERROR = 35;
    public static final int ERROR_CODE_NOT_IMPLEMENTED = 36;
    private int errorCode;
    private String errorMessage;
    private Ks3ServerError ks3ServerError;

    public Ks3Error(int statesCode, byte[] response, Throwable throwable) {
        if (response != null) {
            Log.e((String)"ks3_sdk_android", (String)new String(response));
        } else {
            Log.e((String)"ks3_sdk_android", (String)"response string is null");
        }
        if (this.parseServerError(response)) {
            this.errorCode = this.judgeErrorCode(statesCode, throwable);
            this.errorMessage = this.ks3ServerError.getServerErrorMessage();
        } else {
            Log.e((String)"ks3_sdk_android", (String)(" Ks3Error is " + throwable.getMessage()));
        }
    }

    private int judgeErrorCode(int statesCode, Throwable throwable) {
        String serverErrorCode = this.ks3ServerError.getServerErrorCode();
        if (serverErrorCode != null) {
            switch (statesCode) {
                case 0: {
                    break;
                }
                case 400: {
                    if (serverErrorCode.equals("BadDigest")) {
                        return 0;
                    }
                    if (serverErrorCode.equals("InvalidACLString")) {
                        return 1;
                    }
                    if (serverErrorCode.equals("InvalidAuthorizationString")) {
                        return 2;
                    }
                    if (serverErrorCode.equals("InvalidBucketName")) {
                        return 3;
                    }
                    if (serverErrorCode.equals("InvalidDateFormat")) {
                        return 4;
                    }
                    if (serverErrorCode.equals("InvalidDigest")) {
                        return 5;
                    }
                    if (serverErrorCode.equals("InvalidEncryptionAlgorithm")) {
                        return 6;
                    }
                    if (serverErrorCode.equals("InvalidHostHeader")) {
                        return 7;
                    }
                    if (serverErrorCode.equals("InvalidParameter")) {
                        return 8;
                    }
                    if (serverErrorCode.equals("InvalidPath")) {
                        return 9;
                    }
                    if (serverErrorCode.equals("InvalidQueryString")) {
                        return 10;
                    }
                    if (serverErrorCode.equals("MetadataTooLarge")) {
                        return 11;
                    }
                    if (serverErrorCode.equals("MissingDateHeader")) {
                        return 12;
                    }
                    if (serverErrorCode.equals("MissingHostHeader")) {
                        return 13;
                    }
                    if (serverErrorCode.equals("TooManyBuckets")) {
                        return 14;
                    }
                    if (serverErrorCode.equals("BadParams")) {
                        return 15;
                    }
                    if (serverErrorCode.equals("ImageTypeNotSupport")) {
                        return 16;
                    }
                    if (serverErrorCode.equals("MissingFormArgs")) {
                        return 17;
                    }
                    if (serverErrorCode.equals("ContentRangeError")) {
                        return 18;
                    }
                    if (serverErrorCode.equals("ContentLengthOutOfRange")) {
                        return 19;
                    }
                    if (serverErrorCode.equals("PolicyError")) {
                        return 20;
                    }
                    if (serverErrorCode.equals("ExpirationError")) {
                        return 21;
                    }
                    if (!serverErrorCode.equals("FormUnmatchPolicy")) break;
                    return 22;
                }
                case 403: {
                    if (serverErrorCode.equals("AccessDenied")) {
                        return 23;
                    }
                    if (serverErrorCode.equals("InvalidAccessKey")) {
                        return 24;
                    }
                    if (serverErrorCode.equals("RequestTimeTooSkewed")) {
                        return 25;
                    }
                    if (serverErrorCode.equals("SignatureDoesNotMatch")) {
                        return 26;
                    }
                    if (!serverErrorCode.equals("URLExpired")) break;
                    return 27;
                }
                case 404: {
                    if (serverErrorCode.equals("NoSuchBucket")) {
                        return 28;
                    }
                    if (!serverErrorCode.equals("NoSuchKey")) break;
                    return 29;
                }
                case 405: {
                    if (!serverErrorCode.equals("MethodNotAllowed")) break;
                    return 30;
                }
                case 409: {
                    if (serverErrorCode.equals("BucketAlreadyExists")) {
                        return 31;
                    }
                    if (serverErrorCode.equals("BucketAlreadyOwnedByYou")) {
                        return 32;
                    }
                    if (!serverErrorCode.equals("BucketNotEmpty")) break;
                    return 33;
                }
                case 416: {
                    if (!serverErrorCode.equals("InvalidRange")) break;
                    return 34;
                }
                case 500: {
                    if (!serverErrorCode.equals("InternalError")) break;
                    return 35;
                }
                case 501: {
                    if (!serverErrorCode.equals("NotImplemented")) break;
                    return 36;
                }
            }
        }
        return -1;
    }

    private boolean parseServerError(byte[] response) {
        if (response != null) {
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                XmlPullParser parse = factory.newPullParser();
                parse.setInput((InputStream)new ByteArrayInputStream(response), "UTF-8");
                int eventType = parse.getEventType();
                while (1 != eventType) {
                    String nodeName = parse.getName();
                    switch (eventType) {
                        case 0: {
                            this.ks3ServerError = new Ks3ServerError();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (nodeName.equalsIgnoreCase("Code")) {
                                this.ks3ServerError.setServerErrorCode(parse.nextText());
                            }
                            if (nodeName.equalsIgnoreCase("Message")) {
                                this.ks3ServerError.setServerErrorMessage(parse.nextText());
                            }
                            if (nodeName.equalsIgnoreCase("Resource")) {
                                this.ks3ServerError.setServerErrorResource(parse.nextText());
                            }
                            if (!nodeName.equalsIgnoreCase("RequestId")) break;
                            this.ks3ServerError.setServerErrorRequsetId(parse.nextText());
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    eventType = parse.next();
                }
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Ks3ServerError getKs3ServerError() {
        return this.ks3ServerError;
    }

    public void setKs3ServerError(Ks3ServerError ks3ServerError) {
        this.ks3ServerError = ks3ServerError;
    }
}

