/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.internal.Euler;
import com.alibaba.android.bindingx.core.internal.Vector3;

class Quaternion {
    double x;
    double y;
    double z;
    double w;

    Quaternion() {
    }

    Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Nullable
    Quaternion setFromEuler(Euler euler) {
        if (euler == null || !euler.isEuler) {
            return null;
        }
        double c1 = Math.cos(euler.x / 2.0);
        double c2 = Math.cos(euler.y / 2.0);
        double c3 = Math.cos(euler.z / 2.0);
        double s1 = Math.sin(euler.x / 2.0);
        double s2 = Math.sin(euler.y / 2.0);
        double s3 = Math.sin(euler.z / 2.0);
        String order = euler.order;
        if ("XYZ".equals(order)) {
            this.x = s1 * c2 * c3 + c1 * s2 * s3;
            this.y = c1 * s2 * c3 - s1 * c2 * s3;
            this.z = c1 * c2 * s3 + s1 * s2 * c3;
            this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if ("YXZ".equals(order)) {
            this.x = s1 * c2 * c3 + c1 * s2 * s3;
            this.y = c1 * s2 * c3 - s1 * c2 * s3;
            this.z = c1 * c2 * s3 - s1 * s2 * c3;
            this.w = c1 * c2 * c3 + s1 * s2 * s3;
        } else if ("ZXY".equals(order)) {
            this.x = s1 * c2 * c3 - c1 * s2 * s3;
            this.y = c1 * s2 * c3 + s1 * c2 * s3;
            this.z = c1 * c2 * s3 + s1 * s2 * c3;
            this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if ("ZYX".equals(order)) {
            this.x = s1 * c2 * c3 - c1 * s2 * s3;
            this.y = c1 * s2 * c3 + s1 * c2 * s3;
            this.z = c1 * c2 * s3 - s1 * s2 * c3;
            this.w = c1 * c2 * c3 + s1 * s2 * s3;
        } else if ("YZX".equals(order)) {
            this.x = s1 * c2 * c3 + c1 * s2 * s3;
            this.y = c1 * s2 * c3 + s1 * c2 * s3;
            this.z = c1 * c2 * s3 - s1 * s2 * c3;
            this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if ("XZY".equals(order)) {
            this.x = s1 * c2 * c3 - c1 * s2 * s3;
            this.y = c1 * s2 * c3 - s1 * c2 * s3;
            this.z = c1 * c2 * s3 + s1 * s2 * c3;
            this.w = c1 * c2 * c3 + s1 * s2 * s3;
        }
        return this;
    }

    Quaternion setFromAxisAngle(Vector3 axis, double angle) {
        double halfAngle = angle / 2.0;
        double s = Math.sin(halfAngle);
        this.x = axis.x * s;
        this.y = axis.y * s;
        this.z = axis.z * s;
        this.w = Math.cos(halfAngle);
        return this;
    }

    Quaternion multiply(Quaternion q) {
        return this.multiplyQuaternions(this, q);
    }

    Quaternion multiplyQuaternions(Quaternion a, Quaternion b) {
        double qax = a.x;
        double qay = a.y;
        double qaz = a.z;
        double qaw = a.w;
        double qbx = b.x;
        double qby = b.y;
        double qbz = b.z;
        double qbw = b.w;
        this.x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
        this.y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
        this.z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
        this.w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;
        return this;
    }

    public String toString() {
        return "Quaternion{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }
}

