/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.view.animation.AnimationUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.AnimationFrame;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.JSMath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BindingXTimingHandler
extends AbstractEventHandler
implements AnimationFrame.Callback {
    private long mStartTime = 0L;
    private AnimationFrame mAnimationFrame;
    private boolean isFinish = false;

    public BindingXTimingHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
        if (this.mAnimationFrame == null) {
            this.mAnimationFrame = AnimationFrame.newInstance();
        } else {
            this.mAnimationFrame.clear();
        }
    }

    @VisibleForTesting
    BindingXTimingHandler(Context context, PlatformManager manager, AnimationFrame frame, Object ... extension) {
        super(context, manager, extension);
        this.mAnimationFrame = frame;
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        return true;
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    @Override
    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        super.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
        if (this.mAnimationFrame == null) {
            this.mAnimationFrame = AnimationFrame.newInstance();
        }
        this.fireEventByState("start", 0L, new Object[0]);
        this.mAnimationFrame.clear();
        this.mAnimationFrame.requestAnimationFrame(this);
    }

    @WorkerThread
    private void handleTimingCallback() {
        long deltaT;
        if (this.mStartTime == 0L) {
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            deltaT = 0L;
            this.isFinish = false;
        } else {
            deltaT = AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
        }
        try {
            if (LogProxy.sEnableLog) {
                LogProxy.d(String.format(Locale.getDefault(), "[TimingHandler] timing elapsed. (t:%d)", deltaT));
            }
            JSMath.applyTimingValuesToScope(this.mScope, deltaT);
            if (!this.isFinish) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "timing");
            }
            this.isFinish = this.evaluateExitExpression(this.mExitExpressionPair, this.mScope);
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        this.fireEventByState("end", System.currentTimeMillis() - this.mStartTime, new Object[0]);
        this.clearExpressions();
        if (this.mAnimationFrame != null) {
            this.mAnimationFrame.clear();
        }
        this.mStartTime = 0L;
        return true;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.clearExpressions();
        if (this.mAnimationFrame != null) {
            this.mAnimationFrame.terminate();
            this.mAnimationFrame = null;
        }
        this.mStartTime = 0L;
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double t = (Double)scope.get("t");
        this.fireEventByState("exit", (long)t, new Object[0]);
        if (this.mAnimationFrame != null) {
            this.mAnimationFrame.clear();
        }
        this.mStartTime = 0L;
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double t = (Double)scope.get("t");
        this.fireEventByState("interceptor", (long)t, Collections.singletonMap("interceptor", interceptorName));
    }

    private void fireEventByState(String state, long t, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            param.put("t", t);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + t + ")");
        }
    }

    @Override
    public void doFrame() {
        this.handleTimingCallback();
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }
}

