/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import android.util.Log;
import com.ksyun.ks3.auth.ValidateUtil;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.ObjectMetadata;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.CannedAccessControlList;
import com.ksyun.ks3.model.transfer.InputSubStream;
import com.ksyun.ks3.model.transfer.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.model.transfer.RepeatableFileInputStream;
import com.ksyun.ks3.services.request.Ks3HttpRequest;
import com.ksyun.ks3.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class UploadPartRequest
extends Ks3HttpRequest {
    private static final long serialVersionUID = -376145159039630694L;
    private String uploadId;
    private int partNumber;
    private long partSize;
    private InputStream inputStream;
    private File file;
    private long fileOffset;
    private boolean isLastPart;
    public long contentLength = -1L;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();
    private String redirectLocation;

    public UploadPartRequest(String bucketName, String key, String uploadId, File file, long offset, int partNumber, long partSize) {
        this.setBucketname(bucketName);
        this.setObjectkey(key);
        this.uploadId = uploadId;
        this.file = file;
        this.fileOffset = offset;
        this.partNumber = partNumber;
        this.partSize = partSize;
        if (file.length() - offset < partSize) {
            this.contentLength = file.length() - offset;
            this.isLastPart = true;
        } else {
            this.contentLength = partSize;
            this.isLastPart = false;
        }
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.PUT);
        this.addParams("uploadId", this.uploadId);
        this.addParams("partNumber", String.valueOf(this.partNumber));
        if (StringUtils.isBlank(this.getContentType())) {
            this.addHeader(HttpHeaders.ContentType, "application/octet-stream");
        }
        MD5DigestCalculatingInputStream inputStream = null;
        try {
            inputStream = new MD5DigestCalculatingInputStream(new InputSubStream(new RepeatableFileInputStream(this.file), this.fileOffset, this.contentLength, true));
            Log.d((String)"ks3_android_sdk", (String)("bucketName :" + this.getBucketname() + ",objectkey :" + this.getObjectkey() + ",partNumber :" + this.partNumber + ",partSzie :" + this.partSize + ",conentLength:" + this.contentLength));
        }
        catch (FileNotFoundException e) {
            throw new Ks3ClientException(e);
        }
        this.addHeader(HttpHeaders.ContentLength, String.valueOf(this.contentLength));
        this.setRequestBody(inputStream);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (ValidateUtil.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("bucket name is not correct");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("object key can not be null");
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw new Ks3ClientException("uploadId can not be null");
        }
        if (this.partSize <= 0L) {
            throw new Ks3ClientException("part size can not should bigger than 0");
        }
        if (this.partNumber < 1 || this.partNumber > 10000) {
            throw new Ks3ClientException("partNumber shoud between 1 and 10000");
        }
        if (this.file == null) {
            throw new Ks3ClientException("file and content can not both be null");
        }
        if (this.fileOffset < 0L) {
            throw new Ks3ClientException("fileoffset(" + this.fileOffset + ") should >= 0");
        }
        if (this.partSize > 0x40000000L) {
            throw new Ks3ClientException("partsize(" + this.partSize + ") should be small than" + 0x40000000);
        }
        if (this.partSize <= 0L) {
            throw new Ks3ClientException("partsize(" + this.partSize + ") should be larger than" + 0);
        }
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public boolean isLastPart() {
        return this.isLastPart;
    }

    public void setLastPart(boolean isLastPart) {
        this.isLastPart = isLastPart;
    }
}

