/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import android.text.TextUtils;
import com.ksyun.ks3.auth.ValidateUtil;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.CannedAccessControlList;
import com.ksyun.ks3.model.acl.Grant;
import com.ksyun.ks3.model.acl.Permission;
import com.ksyun.ks3.services.request.common.Ks3HttpObjectRequest;
import com.ksyun.ks3.services.request.tag.ObjectTagging;
import com.ksyun.ks3.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class CopyObjectRequest
extends Ks3HttpObjectRequest {
    private static final long serialVersionUID = -2905675368285940188L;
    private String sourceBucket;
    private String sourceKey;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey) {
        super.setBucketname(destinationBucket);
        super.setObjectkey(destinationObject);
        this.setSourceBucket(sourceBucket);
        this.setSourceKey(sourceKey);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, ObjectTagging objectTagging) {
        super.setBucketname(destinationBucket);
        super.setObjectkey(destinationObject);
        this.setSourceBucket(sourceBucket);
        this.setSourceKey(sourceKey);
        if (objectTagging != null && objectTagging.getTagSet() != null && objectTagging.getTagSet().size() > 0) {
            this.setTagging(objectTagging);
        }
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, CannedAccessControlList cannedAcl) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setCannedAcl(cannedAcl);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, CannedAccessControlList cannedAcl, ObjectTagging objectTagging) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setCannedAcl(cannedAcl);
        if (objectTagging != null && objectTagging.getTagSet() != null && objectTagging.getTagSet().size() > 0) {
            this.setTagging(objectTagging);
        }
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, AccessControlList accessControlList) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setAccessControlList(accessControlList);
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.PUT);
        try {
            this.addHeader(HttpHeaders.XKssCopySource, "/" + this.getSourceBucket() + "/" + URLEncoder.encode(this.getSourceKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.cannedAcl != null) {
            this.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.accessControlList != null) {
            ArrayList<String> grants_fullcontrol = new ArrayList<String>();
            ArrayList<String> grants_read = new ArrayList<String>();
            ArrayList<String> grants_write = new ArrayList<String>();
            for (Grant grant : this.accessControlList.getGrants()) {
                if (grant.getPermission().equals((Object)Permission.FullControl)) {
                    grants_fullcontrol.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (grant.getPermission().equals((Object)Permission.Read)) {
                    grants_read.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (!grant.getPermission().equals((Object)Permission.Write)) continue;
                grants_write.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
            }
            if (grants_fullcontrol.size() > 0) {
                this.addHeader(HttpHeaders.GrantFullControl, TextUtils.join((CharSequence)",", grants_fullcontrol));
            }
            if (grants_read.size() > 0) {
                this.addHeader(HttpHeaders.GrantRead, TextUtils.join((CharSequence)",", grants_read));
            }
            if (grants_write.size() > 0) {
                this.addHeader(HttpHeaders.GrantWrite, TextUtils.join((CharSequence)",", grants_write));
            }
        }
        this.setTagHeader();
        if (this.getTagging() != null) {
            this.addHeader(HttpHeaders.XKssObjectTagDIRECTIVE, this.getTagging().getTaggingDirective());
        }
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (ValidateUtil.validateBucketName(this.sourceBucket) == null) {
            throw new Ks3ClientException("source-bucket name is not correct");
        }
        if (StringUtils.isBlank(this.sourceKey)) {
            throw new Ks3ClientException("sourceKey can not be null");
        }
        if (ValidateUtil.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("destination-bucket name is not correct");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("destinationObject can not be null");
        }
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }
}

