/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.callback.IRCRTCEngineEventListener;
import cn.rongcloud.rtc.base.RCRTCAudioEventCode;
import cn.rongcloud.rtc.base.RCRTCConnectionState;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCVideoEventCode;
import cn.rongcloud.rtc.base.RTCErrorCode;

public class RCEngineEventListenerWrapper
extends IRCRTCEngineEventListener {
    private IRCRTCEngineEventListener engineEventListener;
    private Handler mCallBackHandler;

    public RCEngineEventListenerWrapper(Handler callBackHandler, IRCRTCEngineEventListener eventListener) {
        this.engineEventListener = eventListener;
        this.mCallBackHandler = callBackHandler;
    }

    public void setEventsListener(IRCRTCEngineEventListener eventsListener) {
        this.engineEventListener = eventsListener;
    }

    public void release() {
        this.mCallBackHandler = null;
        this.engineEventListener = null;
    }

    private void postCallbackThread(Runnable runnable) {
        if (this.engineEventListener != null) {
            this.mCallBackHandler.post(runnable);
        }
    }

    @Override
    public void onError(final RTCErrorCode errorCode) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                if (RCEngineEventListenerWrapper.this.engineEventListener != null) {
                    RCEngineEventListenerWrapper.this.engineEventListener.onError(errorCode);
                }
            }
        });
    }

    @Override
    public void onKicked(final String roomId, final RCRTCParamsType.RCRTCKickedReason kickedReason) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                if (RCEngineEventListenerWrapper.this.engineEventListener != null) {
                    RCEngineEventListenerWrapper.this.engineEventListener.onKicked(roomId, kickedReason);
                }
            }
        });
    }

    @Override
    public void onLocalAudioEventNotify(final RCRTCAudioEventCode event) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                IRCRTCEngineEventListener engineEventListener = RCEngineEventListenerWrapper.this.engineEventListener;
                if (engineEventListener != null) {
                    engineEventListener.onLocalAudioEventNotify(event);
                }
            }
        });
    }

    @Override
    public void onLocalVideoEventNotify(final RCRTCVideoEventCode event) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                IRCRTCEngineEventListener engineEventListener = RCEngineEventListenerWrapper.this.engineEventListener;
                if (engineEventListener != null) {
                    engineEventListener.onLocalVideoEventNotify(event);
                }
            }
        });
    }

    @Override
    public void onConnectionStateChanged(final RCRTCConnectionState state) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                IRCRTCEngineEventListener engineEventListener = RCEngineEventListenerWrapper.this.engineEventListener;
                if (engineEventListener != null) {
                    engineEventListener.onConnectionStateChanged(state);
                }
            }
        });
    }
}

