/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.notification;

import android.util.SparseArray;
import com.liulishuo.filedownloader.notification.BaseNotificationItem;

public class FileDownloadNotificationHelper<T extends BaseNotificationItem> {
    private final SparseArray<T> notificationArray = new SparseArray();

    public T get(int id) {
        return (T)((BaseNotificationItem)this.notificationArray.get(id));
    }

    public boolean contains(int id) {
        return this.get(id) != null;
    }

    public T remove(int id) {
        T n = this.get(id);
        if (n != null) {
            this.notificationArray.remove(id);
            return n;
        }
        return null;
    }

    public void add(T notification) {
        this.notificationArray.remove(((BaseNotificationItem)notification).getId());
        this.notificationArray.put(((BaseNotificationItem)notification).getId(), notification);
    }

    public void showProgress(int id, int sofar, int total) {
        T notification = this.get(id);
        if (notification == null) {
            return;
        }
        ((BaseNotificationItem)notification).updateStatus(3);
        ((BaseNotificationItem)notification).update(sofar, total);
    }

    public void showIndeterminate(int id, int status) {
        T notification = this.get(id);
        if (notification == null) {
            return;
        }
        ((BaseNotificationItem)notification).updateStatus(status);
        ((BaseNotificationItem)notification).show(false);
    }

    public void cancel(int id) {
        T notification = this.remove(id);
        if (notification == null) {
            return;
        }
        ((BaseNotificationItem)notification).cancel();
    }

    public void clear() {
        SparseArray cloneArray = this.notificationArray.clone();
        this.notificationArray.clear();
        for (int i = 0; i < cloneArray.size(); ++i) {
            BaseNotificationItem n = (BaseNotificationItem)cloneArray.get(cloneArray.keyAt(i));
            n.cancel();
        }
    }
}

