/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.config;

import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.http.CertDTO;
import io.dcloud.feature.weex.config.AndroidTlsConfig;
import io.dcloud.feature.weex.config.MimeInfoParser;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class UserCustomTrustManager {
    private static HashMap<AndroidTlsConfig, SSLSocketFactory> cacheSSLFactory = new HashMap();
    private static HashMap<CertDTO, SSLSocketFactory> cacheCertSSLFactory = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactory getSSLSocketFactory(AndroidTlsConfig androidTlsConfig, WXSDKInstance wxsdkInstance) {
        SSLSocketFactory ret;
        if (androidTlsConfig == null) {
            return null;
        }
        if (cacheSSLFactory.containsKey(androidTlsConfig) && (ret = cacheSSLFactory.get(androidTlsConfig)) != null) {
            return ret;
        }
        if (wxsdkInstance == null) {
            return null;
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (!TextUtils.isEmpty((CharSequence)androidTlsConfig.getKeystore()) & !TextUtils.isEmpty((CharSequence)androidTlsConfig.getStorePass())) {
                MimeInfoParser.MimeInfo mimeInfo = MimeInfoParser.getInstance().obtainMimeInfo(androidTlsConfig.getKeystore());
                if (mimeInfo == null) return null;
                InputStream bksInputStream = mimeInfo.getDataBytes(wxsdkInstance);
                clientKeyStore.load(bksInputStream, androidTlsConfig.getStorePass().toCharArray());
                keyManagerFactory.init(clientKeyStore, androidTlsConfig.getStorePass().toCharArray());
            } else {
                keyManagerFactory = null;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore caKeyStore = KeyStore.getInstance("PKCS12");
            for (int i = 0; i < androidTlsConfig.getCa().length; ++i) {
                MimeInfoParser.MimeInfo perMimeInfo = MimeInfoParser.getInstance().obtainMimeInfo(androidTlsConfig.getCa()[i]);
                if (perMimeInfo == null) continue;
                InputStream certificate = perMimeInfo.getDataBytes(wxsdkInstance);
                caKeyStore.load(null);
                String certificateAlias = Integer.toString(i);
                caKeyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            if (keyManagerFactory == null) {
                ctx.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            } else {
                ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            }
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            if (cacheSSLFactory.size() > 3) {
                cacheSSLFactory.clear();
            }
            cacheSSLFactory.put(androidTlsConfig, sslSocketFactory);
            return sslSocketFactory;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SSLSocketFactory getSSLSocketFactory(CertDTO certDTO, WXSDKInstance wxsdkInstance) {
        SSLSocketFactory ret;
        if (certDTO == null) {
            return null;
        }
        if (cacheCertSSLFactory.containsKey(certDTO) && (ret = cacheCertSSLFactory.get(certDTO)) != null) {
            return ret;
        }
        if (wxsdkInstance == null) {
            return null;
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (!TextUtils.isEmpty((CharSequence)certDTO.client) & !TextUtils.isEmpty((CharSequence)certDTO.clientPassword)) {
                MimeInfoParser.MimeInfo mimeInfo = MimeInfoParser.getInstance().obtainMimeInfo(certDTO.client);
                InputStream bksInputStream = null;
                bksInputStream = mimeInfo != null ? mimeInfo.getDataBytes(wxsdkInstance) : MimeInfoParser.getFilePathStream(wxsdkInstance, certDTO.client);
                if (bksInputStream != null) {
                    clientKeyStore.load(bksInputStream, certDTO.getClientPassword().toCharArray());
                    keyManagerFactory.init(clientKeyStore, certDTO.getClientPassword().toCharArray());
                }
            } else {
                keyManagerFactory = null;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore caKeyStore = KeyStore.getInstance("PKCS12");
            for (int i = 0; i < certDTO.getServer().length; ++i) {
                MimeInfoParser.MimeInfo perMimeInfo = MimeInfoParser.getInstance().obtainMimeInfo(certDTO.getServer()[i]);
                InputStream certificate = null;
                certificate = perMimeInfo != null ? perMimeInfo.getDataBytes(wxsdkInstance) : MimeInfoParser.getFilePathStream(wxsdkInstance, certDTO.getServer()[i]);
                if (certificate == null) continue;
                caKeyStore.load(null);
                String certificateAlias = Integer.toString(i);
                caKeyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            if (keyManagerFactory == null) {
                ctx.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            } else {
                ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            }
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            if (cacheCertSSLFactory.size() > 3) {
                cacheCertSSLFactory.clear();
            }
            cacheCertSSLFactory.put(certDTO, sslSocketFactory);
            return sslSocketFactory;
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        return null;
    }
}

