/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.hardware.display.DisplayManagerCompat;
import androidx.core.view.ViewCompat;
import com.camerakit.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.TextRecognizer;
import com.wonderkiln.camerakit.CameraKitController;
import com.wonderkiln.camerakit.CameraProperties;
import com.wonderkiln.camerakit.FocusMarkerLayout;
import com.wonderkiln.camerakit.api16.Camera1;
import com.wonderkiln.camerakit.base.CameraImpl;
import com.wonderkiln.camerakit.base.CameraViewLayout;
import com.wonderkiln.camerakit.base.PreviewImpl;
import com.wonderkiln.camerakit.base.SurfaceViewPreview;
import com.wonderkiln.camerakit.events.CameraKitEventCallback;
import com.wonderkiln.camerakit.events.CameraKitEventListener;
import com.wonderkiln.camerakit.events.CameraKitImage;
import com.wonderkiln.camerakit.events.CameraKitVideo;
import com.wonderkiln.camerakit.events.CameraStartRecord;
import com.wonderkiln.camerakit.events.EventDispatcher;
import com.wonderkiln.camerakit.utils.AspectRatio;
import com.wonderkiln.camerakit.utils.DisplayOrientationDetector;
import com.wonderkiln.camerakit.utils.PostProcessor;
import com.wonderkiln.camerakit.utils.Size;
import com.wonderkiln.camerakit.vision.CameraKitTextDetect;
import com.wonderkiln.camerakit.vision.GooglePlayServicesUnavailableException;
import com.wonderkiln.camerakit.vision.TextProcessor;
import java.io.File;
import java.util.ArrayList;

public class CameraView
extends CameraViewLayout {
    private static Handler sWorkerHandler;
    private int mFacing;
    private int mFlash;
    private int mFocus;
    private int mMethod;
    private boolean mPinchToZoom;
    private float mZoom;
    private int mPermissions;
    private int mVideoQuality;
    private int mJpegQuality;
    private int mVideoBitRate;
    private int mDeviceOrientation;
    private boolean mLockVideoAspectRatio;
    private boolean mCropOutput;
    private boolean mDoubleTapToToggleFacing;
    private boolean mAdjustViewBounds;
    private DisplayOrientationDetector mDisplayOrientationDetector;
    private CameraImpl mCameraImpl;
    private PreviewImpl mPreviewImpl;
    private boolean mIsStarted;
    private EventDispatcher mEventDispatcher;
    private FocusMarkerLayout focusMarkerLayout;

    public CameraView(@NonNull Context context) {
        this(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean isChromebookInLaptopMode;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CameraView, 0, 0);
            try {
                this.mFacing = a.getInteger(R.styleable.CameraView_ckFacing, 0);
                this.mFlash = a.getInteger(R.styleable.CameraView_ckFlash, 0);
                this.mFocus = a.getInteger(R.styleable.CameraView_ckFocus, 1);
                this.mMethod = a.getInteger(R.styleable.CameraView_ckMethod, 0);
                this.mPinchToZoom = a.getBoolean(R.styleable.CameraView_ckPinchToZoom, true);
                this.mZoom = a.getFloat(R.styleable.CameraView_ckZoom, 1.0f);
                this.mPermissions = a.getInteger(R.styleable.CameraView_ckPermissions, 0);
                this.mVideoQuality = a.getInteger(R.styleable.CameraView_ckVideoQuality, 0);
                this.mJpegQuality = a.getInteger(R.styleable.CameraView_ckJpegQuality, 100);
                this.mCropOutput = a.getBoolean(R.styleable.CameraView_ckCropOutput, false);
                this.mVideoBitRate = a.getInteger(R.styleable.CameraView_ckVideoBitRate, 0);
                this.mDeviceOrientation = a.getInteger(R.styleable.CameraView_deviceOrientation, 0);
                this.mDoubleTapToToggleFacing = a.getBoolean(R.styleable.CameraView_ckDoubleTapToToggleFacing, false);
                this.mLockVideoAspectRatio = a.getBoolean(R.styleable.CameraView_ckLockVideoAspectRatio, true);
                this.mAdjustViewBounds = a.getBoolean(R.styleable.CameraView_android_adjustViewBounds, false);
            }
            finally {
                a.recycle();
            }
        }
        this.mEventDispatcher = new EventDispatcher();
        this.mPreviewImpl = new SurfaceViewPreview(context, (ViewGroup)this);
        this.mCameraImpl = new Camera1(this.mEventDispatcher, this.mPreviewImpl);
        this.mIsStarted = false;
        WindowManager windowService = (WindowManager)context.getSystemService("window");
        boolean bl = isChromebookInLaptopMode = context.getPackageManager().hasSystemFeature("org.chromium.arc.device_management") && windowService.getDefaultDisplay().getRotation() == 0;
        if (this.mCameraImpl.frontCameraOnly() || isChromebookInLaptopMode) {
            this.mFacing = 1;
        }
        this.setDeviceOrientation(this.mDeviceOrientation);
        this.setFacing(this.mFacing);
        this.setFlash(this.mFlash);
        this.setFocus(this.mFocus);
        this.setMethod(this.mMethod);
        this.setPinchToZoom(this.mPinchToZoom);
        this.setZoom(this.mZoom);
        this.setPermissions(this.mPermissions);
        this.setVideoQuality(this.mVideoQuality);
        this.setVideoBitRate(this.mVideoBitRate);
        this.setLockVideoAspectRatio(this.mLockVideoAspectRatio);
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector = new DisplayOrientationDetector(context){

                @Override
                public void onDisplayOrDeviceOrientationChanged(int displayOrientation, int deviceOrientation) {
                    CameraView.this.mCameraImpl.setDisplayAndDeviceOrientation(displayOrientation, deviceOrientation);
                    CameraView.this.mPreviewImpl.setDisplayOrientation(displayOrientation);
                }
            };
            this.focusMarkerLayout = new FocusMarkerLayout(this.getContext());
            this.addView((View)this.focusMarkerLayout);
        }
    }

    private void setDeviceOrientation(int mDeviceOrientation) {
        if (mDeviceOrientation == 0) {
            this.mCameraImpl.setDeviceOrientation(90);
        } else {
            this.mCameraImpl.setDeviceOrientation(180);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.enable(ViewCompat.isAttachedToWindow((View)this) ? DisplayManagerCompat.getInstance((Context)this.getContext().getApplicationContext()).getDisplay(0) : null);
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.disable();
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAdjustViewBounds) {
            Size previewSize = this.getPreviewSize();
            if (previewSize != null) {
                if (this.getLayoutParams().width == -2) {
                    int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    float ratio = (float)height / (float)previewSize.getHeight();
                    int width = (int)((float)previewSize.getWidth() * ratio);
                    super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), heightMeasureSpec);
                    return;
                }
                if (this.getLayoutParams().height == -2) {
                    int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
                    float ratio = (float)width / (float)previewSize.getWidth();
                    int height = (int)((float)previewSize.getHeight() * ratio);
                    super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
                    return;
                }
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    public void addController(CameraKitController controller) {
    }

    public void start() {
        if (this.mIsStarted || !this.isEnabled()) {
            return;
        }
        this.mIsStarted = true;
        int cameraCheck = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA");
        int audioCheck = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.RECORD_AUDIO");
        switch (this.mPermissions) {
            case 0: {
                if (cameraCheck == 0 && audioCheck == 0) break;
                this.requestPermissions(true, true);
                return;
            }
            case 1: {
                if (cameraCheck == 0) break;
                this.requestPermissions(true, true);
                return;
            }
            case 2: {
                if (cameraCheck == 0) break;
                this.requestPermissions(true, false);
                return;
            }
        }
        this.mCameraImpl.start();
    }

    public void stop() {
        if (!this.mIsStarted) {
            return;
        }
        this.mIsStarted = false;
        this.mCameraImpl.stop();
    }

    @Override
    protected CameraImpl getCameraImpl() {
        return this.mCameraImpl;
    }

    @Override
    protected PreviewImpl getPreviewImpl() {
        return this.mPreviewImpl;
    }

    @Override
    protected void onZoom(float modifier, boolean start) {
        if (this.mPinchToZoom) {
            this.mCameraImpl.modifyZoom((modifier - 1.0f) * 0.8f + 1.0f);
        }
    }

    @Override
    protected void onTapToFocus(float x, float y) {
        if (this.mFocus == 2 || this.mFocus == 3) {
            this.focusMarkerLayout.focus(x, y);
            float px = x - this.getPreviewImpl().getX();
            float py = y - this.getPreviewImpl().getY();
            this.mCameraImpl.setFocusArea(px / (float)this.getPreviewImpl().getWidth(), py / (float)this.getPreviewImpl().getHeight());
        }
    }

    @Override
    protected void onToggleFacing() {
        if (this.mDoubleTapToToggleFacing) {
            this.toggleFacing();
        }
    }

    @Nullable
    public CameraProperties getCameraProperties() {
        return this.mCameraImpl.getCameraProperties();
    }

    public int getFacing() {
        return this.mFacing;
    }

    public boolean isFacingFront() {
        return this.mFacing == 1;
    }

    public boolean isFacingBack() {
        return this.mFacing == 0;
    }

    public void setFacing(final int facing) {
        this.mFacing = facing;
        sWorkerHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mCameraImpl.setFacing(facing);
            }
        });
    }

    public void setFlash(int flash) {
        this.mFlash = flash;
        this.mCameraImpl.setFlash(flash);
    }

    public int getFlash() {
        return this.mFlash;
    }

    public void setFocus(int focus) {
        this.mFocus = focus;
        if (this.mFocus == 3) {
            this.mCameraImpl.setFocus(2);
            return;
        }
        this.mCameraImpl.setFocus(this.mFocus);
    }

    public void setMethod(int method) {
        this.mMethod = method;
        this.mCameraImpl.setMethod(this.mMethod);
    }

    public void setPinchToZoom(boolean zoom) {
        this.mPinchToZoom = zoom;
    }

    public void setZoom(float zoom) {
        this.mZoom = zoom;
        this.mCameraImpl.setZoom(zoom);
    }

    public void setPermissions(int permissions) {
        this.mPermissions = permissions;
    }

    public void setVideoQuality(int videoQuality) {
        this.mVideoQuality = videoQuality;
        this.mCameraImpl.setVideoQuality(this.mVideoQuality);
    }

    public void setVideoBitRate(int videoBirRate) {
        this.mVideoBitRate = videoBirRate;
        this.mCameraImpl.setVideoBitRate(this.mVideoBitRate);
    }

    public void setLockVideoAspectRatio(boolean lockVideoAspectRatio) {
        this.mLockVideoAspectRatio = lockVideoAspectRatio;
        this.mCameraImpl.setLockVideoAspectRatio(lockVideoAspectRatio);
    }

    public void setJpegQuality(int jpegQuality) {
        this.mJpegQuality = jpegQuality;
    }

    public void setCropOutput(boolean cropOutput) {
        this.mCropOutput = cropOutput;
    }

    public int toggleFacing() {
        switch (this.mFacing) {
            case 0: {
                this.setFacing(1);
                break;
            }
            case 1: {
                this.setFacing(0);
            }
        }
        return this.mFacing;
    }

    public int toggleFlash() {
        switch (this.mFlash) {
            case 0: {
                this.setFlash(1);
                break;
            }
            case 1: {
                this.setFlash(2);
                break;
            }
            case 2: 
            case 3: {
                this.setFlash(0);
            }
        }
        return this.mFlash;
    }

    public void captureImage() {
        this.captureImage(null);
    }

    public boolean setTextDetectionListener(CameraKitEventCallback<CameraKitTextDetect> callback) throws GooglePlayServicesUnavailableException {
        TextRecognizer textRecognizer = new TextRecognizer.Builder(this.getContext()).build();
        textRecognizer.setProcessor((Detector.Processor)new TextProcessor(this.mEventDispatcher, callback));
        int code = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext().getApplicationContext());
        if (code != 0) {
            throw new GooglePlayServicesUnavailableException();
        }
        if (textRecognizer.isOperational()) {
            this.mCameraImpl.setTextDetector((Detector<TextBlock>)textRecognizer);
            return true;
        }
        return false;
    }

    public void captureImage(final CameraKitEventCallback<CameraKitImage> callback) {
        this.mCameraImpl.captureImage(new CameraImpl.ImageCapturedCallback(){

            @Override
            public void imageCaptured(byte[] jpeg) {
                PostProcessor postProcessor = new PostProcessor(jpeg);
                postProcessor.setJpegQuality(CameraView.this.mJpegQuality);
                postProcessor.setFacing(CameraView.this.mFacing);
                if (CameraView.this.mCropOutput) {
                    postProcessor.setCropOutput(AspectRatio.of(CameraView.this.getWidth(), CameraView.this.getHeight()));
                }
                CameraKitImage image = new CameraKitImage(postProcessor.getJpeg());
                if (callback != null) {
                    callback.callback(image);
                }
                CameraView.this.mEventDispatcher.dispatch(image);
            }
        });
    }

    public void captureVideo() {
        this.captureVideo(null, null);
    }

    public void captureVideo(File videoFile) {
        this.captureVideo(videoFile, null);
    }

    public void captureVideo(CameraKitEventCallback<CameraKitVideo> callback) {
        this.captureVideo(null, callback);
    }

    public void captureVideo(File videoFile, CameraKitEventCallback<CameraKitVideo> callback) {
        this.captureVideo(videoFile, 0, callback);
    }

    public void captureVideo(File videoFile, int maxDuration, final CameraKitEventCallback<CameraKitVideo> callback) {
        this.mCameraImpl.captureVideo(videoFile, maxDuration, new CameraImpl.VideoCapturedCallback(){

            @Override
            public void videoCaptured(File file) {
                CameraKitVideo video = new CameraKitVideo(file);
                if (callback != null) {
                    callback.callback(video);
                }
                CameraView.this.mEventDispatcher.dispatch(video);
            }

            @Override
            public void onStart(long time) {
                CameraStartRecord cameraStartRecord = new CameraStartRecord(time);
                CameraView.this.mEventDispatcher.dispatch(cameraStartRecord);
            }
        });
    }

    public void stopVideo() {
        this.mCameraImpl.stopVideo();
    }

    public Size getPreviewSize() {
        return this.mCameraImpl != null ? this.mCameraImpl.getPreviewResolution() : null;
    }

    public Size getCaptureSize() {
        return this.mCameraImpl != null ? this.mCameraImpl.getCaptureResolution() : null;
    }

    private void requestPermissions(boolean requestCamera, boolean requestAudio) {
        Activity activity = null;
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestCamera) {
            permissions.add("android.permission.CAMERA");
        }
        if (requestAudio) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        if (activity != null) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions.toArray(new String[permissions.size()]), (int)16);
        }
    }

    public void addCameraKitListener(CameraKitEventListener CameraKitEventListener2) {
        this.mEventDispatcher.addListener(CameraKitEventListener2);
    }

    public void bindCameraKitListener(Object object) {
        this.mEventDispatcher.addBinding(object);
    }

    static {
        HandlerThread workerThread = new HandlerThread("CameraViewWorker");
        workerThread.setDaemon(true);
        workerThread.start();
        sWorkerHandler = new Handler(workerThread.getLooper());
    }
}

