/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.text.TextBlock;
import com.wonderkiln.camerakit.events.CameraKitEventCallback;
import com.wonderkiln.camerakit.events.EventDispatcher;
import com.wonderkiln.camerakit.vision.CameraKitTextBlock;
import com.wonderkiln.camerakit.vision.CameraKitTextDetect;

public class TextProcessor
implements Detector.Processor<TextBlock> {
    private EventDispatcher mEventDispatcher;
    private CameraKitEventCallback<CameraKitTextDetect> callback;

    public TextProcessor(EventDispatcher mEventDispatcher, CameraKitEventCallback<CameraKitTextDetect> callback) {
        this.mEventDispatcher = mEventDispatcher;
        this.callback = callback;
    }

    public void release() {
    }

    public void receiveDetections(Detector.Detections<TextBlock> detections) {
        SparseArray detectedItems = detections.getDetectedItems();
        for (int i = 0; i < detectedItems.size(); ++i) {
            TextBlock item = (TextBlock)detectedItems.valueAt(i);
            if (item == null || item.getValue() == null) continue;
            CameraKitTextDetect event = new CameraKitTextDetect(new CameraKitTextBlock(item));
            this.mEventDispatcher.dispatch(event);
            this.callback.callback(event);
        }
    }
}

