/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.bassmedia.BassMusicPlay;
import com.bassmedia.PlayerListener;
import com.jinmingyunle.midiplaylib.file.FileUri;
import com.jinmingyunle.midiplaylib.midifile.MidiEvent;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.midifile.MidiFileException;
import com.jinmingyunle.midiplaylib.midifile.MidiFileReader;
import com.jinmingyunle.midiplaylib.midifile.MidiTrack;
import com.jinmingyunle.midiplaylib.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class MidiPlayerUtils {
    private static final String TAG = "MidiPlayerUtilsTAG";
    private Context mContext;
    private static volatile MidiPlayerUtils instance = null;
    public static final int[] PIANO_IDS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public String tempSoundFile;
    private long currentStartPosition;
    public int midiTotalTime = 0;
    private ArrayList<MidiTrack> tracks = new ArrayList();
    private ArrayList<Boolean> trackSelected = new ArrayList();
    int hasNoteTrackNum = 0;
    private float currentTempo = 0.0f;
    private Runnable doPlay = new Runnable(){

        @Override
        public void run() {
            MidiPlayerUtils.this.playSound(MidiPlayerUtils.this.mContext, MidiPlayerUtils.this.currentTempo);
        }
    };

    public void init(Context context, String filePath) {
        this.mContext = context;
        this.tempSoundFile = filePath;
        this.hasNoteTrackNum = this.analyseFile(this.tempSoundFile);
        BassMusicPlay.getInstance().Load(this.mContext, this.tempSoundFile);
    }

    public ArrayList<MidiTrack> getMidiTracks() {
        return this.tracks;
    }

    public ArrayList<Boolean> getTrackSelected() {
        return this.trackSelected;
    }

    public void setTrackSelected(ArrayList<Boolean> trackSelected) {
        this.trackSelected = trackSelected;
    }

    public int getHasNoteTrackNum() {
        return this.hasNoteTrackNum;
    }

    private int analyseFile(String midiFile) {
        FileUri fileUri = new FileUri(Uri.parse((String)midiFile), midiFile);
        byte[] fileData = fileUri.getData(this.mContext);
        if (fileData == null || fileData.length <= 6 || !MidiFile.hasMidiHeader(fileData)) {
            return 0;
        }
        Uri uri = fileUri.getUri();
        String title = fileUri.toString();
        FileUri fileuri = new FileUri(uri, title);
        byte[] data = fileuri.getData(this.mContext);
        this.midiTotalTime = 0;
        this.tracks.clear();
        this.trackSelected.clear();
        boolean trackPerChannel = false;
        MidiFileReader file = new MidiFileReader(data);
        String id = file.ReadAscii(4);
        if (!id.equals("MThd")) {
            throw new MidiFileException("Doesn't start with MThd", 0);
        }
        int len = file.ReadInt();
        if (len != 6) {
            throw new MidiFileException("Bad MThd header", 4);
        }
        short trackmode = (short)file.ReadShort();
        int num_tracks = file.ReadShort();
        int quarternote = file.ReadShort();
        int hasNoteTrackNum = 0;
        ArrayList<ArrayList<MidiEvent>> allevents = new ArrayList<ArrayList<MidiEvent>>();
        for (int tracknum = 0; tracknum < num_tracks; ++tracknum) {
            allevents.add(MidiPlayerUtils.ReadTrack(file));
            MidiTrack track = new MidiTrack((ArrayList)allevents.get(tracknum), tracknum);
            this.tracks.add(track);
            this.trackSelected.add(true);
            if (track.getNotes().size() <= 0) continue;
            ++hasNoteTrackNum;
        }
        for (int i = 0; i < this.tracks.size(); ++i) {
            MidiTrack midiTrack = this.tracks.get(i);
            this.midiTotalTime = this.midiTotalTime > this.tracks.get(i).getTime() ? this.midiTotalTime : this.tracks.get(i).getTime();
        }
        return hasNoteTrackNum;
    }

    private static ArrayList<MidiEvent> ReadTrack(MidiFileReader file) {
        ArrayList<MidiEvent> result = new ArrayList<MidiEvent>(20);
        int starttime = 0;
        String id = file.ReadAscii(4);
        if (!id.equals("MTrk")) {
            throw new MidiFileException("Bad MTrk header", file.GetOffset() - 4);
        }
        int tracklen = file.ReadInt();
        int trackend = tracklen + file.GetOffset();
        int eventflag = 0;
        while (file.GetOffset() < trackend) {
            byte peekevent;
            int deltatime;
            try {
                int startoffset = file.GetOffset();
                deltatime = file.ReadVarlen();
                starttime += deltatime;
                peekevent = file.Peek();
            }
            catch (MidiFileException e) {
                return result;
            }
            MidiEvent mevent = new MidiEvent();
            result.add(mevent);
            mevent.DeltaTime = deltatime;
            mevent.StartTime = starttime;
            if (peekevent < 0) {
                mevent.HasEventflag = true;
                eventflag = file.ReadByte();
            }
            if (eventflag >= -112 && eventflag < -96) {
                mevent.EventFlag = (byte)-112;
                mevent.Channel = (byte)(eventflag - -112);
                mevent.Notenumber = file.ReadByte();
                mevent.Velocity = file.ReadByte();
                continue;
            }
            if (eventflag >= -128 && eventflag < -112) {
                mevent.EventFlag = (byte)-128;
                mevent.Channel = (byte)(eventflag - -128);
                mevent.Notenumber = file.ReadByte();
                mevent.Velocity = file.ReadByte();
                continue;
            }
            if (eventflag >= -96 && eventflag < -80) {
                mevent.EventFlag = (byte)-96;
                mevent.Channel = (byte)(eventflag - -96);
                mevent.Notenumber = file.ReadByte();
                mevent.KeyPressure = file.ReadByte();
                continue;
            }
            if (eventflag >= -80 && eventflag < -64) {
                mevent.EventFlag = (byte)-80;
                mevent.Channel = (byte)(eventflag - -80);
                mevent.ControlNum = file.ReadByte();
                mevent.ControlValue = file.ReadByte();
                continue;
            }
            if (eventflag >= -64 && eventflag < -48) {
                mevent.EventFlag = (byte)-64;
                mevent.Channel = (byte)(eventflag - -64);
                mevent.Instrument = file.ReadByte();
                continue;
            }
            if (eventflag >= -48 && eventflag < -32) {
                mevent.EventFlag = (byte)-48;
                mevent.Channel = (byte)(eventflag - -48);
                mevent.ChanPressure = file.ReadByte();
                continue;
            }
            if (eventflag >= -32 && eventflag < -16) {
                mevent.EventFlag = (byte)-32;
                mevent.Channel = (byte)(eventflag - -32);
                mevent.PitchBend = (short)file.ReadShort();
                continue;
            }
            if (eventflag == -16) {
                mevent.EventFlag = (byte)-16;
                mevent.Metalength = file.ReadVarlen();
                mevent.Value = file.ReadBytes(mevent.Metalength);
                continue;
            }
            if (eventflag == -9) {
                mevent.EventFlag = (byte)-9;
                mevent.Metalength = file.ReadVarlen();
                mevent.Value = file.ReadBytes(mevent.Metalength);
                continue;
            }
            if (eventflag == -1) {
                mevent.EventFlag = (byte)-1;
                mevent.Metaevent = file.ReadByte();
                mevent.Metalength = file.ReadVarlen();
                mevent.Value = file.ReadBytes(mevent.Metalength);
                if (mevent.Metaevent == 88) {
                    if (mevent.Metalength < 2) {
                        throw new MidiFileException("Meta Event Time Signature len == " + mevent.Metalength + " != 4", file.GetOffset());
                    }
                    mevent.Numerator = mevent.Value[0];
                    mevent.Denominator = (byte)Math.pow(2.0, mevent.Value[1]);
                    continue;
                }
                if (mevent.Metaevent == 81) {
                    if (mevent.Metalength != 3) {
                        throw new MidiFileException("Meta Event Tempo len == " + mevent.Metalength + " != 3", file.GetOffset());
                    }
                    mevent.Tempo = (mevent.Value[0] & 0xFF) << 16 | (mevent.Value[1] & 0xFF) << 8 | mevent.Value[2] & 0xFF;
                    continue;
                }
                if (mevent.Metaevent == 47) continue;
                System.out.println("MidiPlayerUtils " + new String(mevent.Value));
                continue;
            }
            throw new MidiFileException("Unknown event " + mevent.EventFlag, file.GetOffset() - 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MidiPlayerUtils getInstance() {
        if (instance != null) return instance;
        Class<MidiPlayerUtils> var0 = MidiPlayerUtils.class;
        Class<MidiPlayerUtils> clazz = MidiPlayerUtils.class;
        synchronized (MidiPlayerUtils.class) {
            if (instance != null) return instance;
            instance = new MidiPlayerUtils();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void play(long startPosition, float tempo) {
        this.currentStartPosition = startPosition;
        this.currentTempo = tempo;
        new Handler().post(this.doPlay);
    }

    public void stopPlay() {
        Log.i((String)TAG, (String)"stopPlay: ");
        this.stopSound();
    }

    public void seekTo(long time) {
        BassMusicPlay.getInstance().Seek(time);
    }

    public boolean setTracksVolume(int[] tracks, float volume) {
        if (this.hasNoteTrackNum > 0) {
            for (int i = 0; i < tracks.length; ++i) {
                if (BassMusicPlay.getInstance().SetTrackVolume2(tracks[i], volume)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean setTrackVolume(int tracks, float volume) {
        if (this.hasNoteTrackNum > 0) {
            return BassMusicPlay.getInstance().SetTrackVolume2(tracks, volume);
        }
        return false;
    }

    public float getTrackVolume(int track) {
        return BassMusicPlay.getInstance().GetTrackVolume(track);
    }

    public boolean setTrackVolumeByName(String trackName, float volume) {
        if (this.tracks == null) {
            return false;
        }
        for (int i = 0; i < this.tracks.size(); ++i) {
            if (TextUtils.isEmpty((CharSequence)this.tracks.get(i).getTrackName()) || TextUtils.isEmpty((CharSequence)trackName) || !this.tracks.get(i).getTrackName().trim().equalsIgnoreCase(trackName.trim())) continue;
            return this.setTrackVolume(i, volume);
        }
        return false;
    }

    public boolean setTrackVolumeById(int id, float volume) {
        if (this.tracks == null) {
            return false;
        }
        if (this.isSingleTracks()) {
            return false;
        }
        boolean isPianoId = this.isPianoId(id);
        if (isPianoId) {
            for (int i = 0; i < PIANO_IDS.length; ++i) {
                int pianoId = PIANO_IDS[i];
                this.updateTrackVolumeById(pianoId, volume);
            }
            return true;
        }
        return this.updateTrackVolumeById(id, volume);
    }

    public boolean updateTrackVolumeById(int targetId, float volume) {
        for (int i = 0; i < this.tracks.size(); ++i) {
            int id;
            MidiTrack midiTrack = this.tracks.get(i);
            if (midiTrack == null || (id = midiTrack.getInstrument()) != targetId) continue;
            return this.setTrackVolume(i, volume);
        }
        return false;
    }

    public boolean isSingleTracks() {
        MidiTrack midiTrack;
        int i;
        if (this.tracks == null) {
            return true;
        }
        Log.i((String)"pq", (String)("tracksSize:" + this.tracks.size()));
        if (this.tracks.size() == 1) {
            return true;
        }
        for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
            MidiTrack midiTrack2 = this.tracks.get(i2);
        }
        List<MidiTrack> distinct = Utils.distinct(this.tracks);
        for (i = 0; i < distinct.size(); ++i) {
            midiTrack = distinct.get(i);
            if (midiTrack.getInstrument() != -1) continue;
            distinct.remove(midiTrack);
        }
        for (i = 0; i < distinct.size(); ++i) {
            midiTrack = distinct.get(i);
        }
        if (distinct.size() == 1) {
            return true;
        }
        for (i = 0; i < distinct.size(); ++i) {
            midiTrack = distinct.get(i);
            int instrument = midiTrack.getInstrument();
            if (instrument <= 7 && instrument >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isPianoId(int id) {
        for (int i = 0; i < PIANO_IDS.length; ++i) {
            int pianoId = PIANO_IDS[i];
            if (id != pianoId) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.stopSound();
    }

    public void destroy() {
        this.stopSound();
        this.setPreparedListener(null);
        this.setCompletionListener(null);
        this.setErrorListener(null);
    }

    public void pausePlay() {
        BassMusicPlay.getInstance().Pause();
    }

    public void resumePlay(int startPos) {
        if (startPos >= 0) {
            this.seekTo(startPos);
        }
        BassMusicPlay.getInstance().Resume();
    }

    public boolean isPlaying() {
        return BassMusicPlay.getInstance().IsPlaying();
    }

    public boolean isPause() {
        return BassMusicPlay.getInstance().IsPause();
    }

    public boolean isStop() {
        return BassMusicPlay.getInstance().IsStop();
    }

    public boolean setNoteFineTune(int trackNum, int targetHz) {
        return BassMusicPlay.getInstance().setNoteFineTune(trackNum, targetHz);
    }

    public long getCurrentPosition() {
        return BassMusicPlay.getInstance().GetCurrentPosition();
    }

    public int getCurrentTICK() {
        return BassMusicPlay.getInstance().GetCurrentTICK();
    }

    public int getTotalTICK() {
        return BassMusicPlay.getInstance().GetTotalTICK();
    }

    public long getTotalLength() {
        return BassMusicPlay.getInstance().GetTotalLength();
    }

    public double getTotalLength2Second() {
        return BassMusicPlay.getInstance().getTotalLength2Second();
    }

    public void setCompletionListener(PlayerListener.OnCompletionListener listener) {
        BassMusicPlay.getInstance().SetOnCompletionListener(listener);
    }

    public void setErrorListener(PlayerListener.OnErrorListener listener) {
        BassMusicPlay.getInstance().SetOnErrorListener(listener);
    }

    public void setPreparedListener(PlayerListener.OnPreparedListener listener) {
        BassMusicPlay.getInstance().SetOnPreparedListener(listener);
    }

    private void stopSound() {
        BassMusicPlay.getInstance().Stop();
    }

    public void setSpeed(float speed) {
        BassMusicPlay.getInstance().setSpeed(speed);
    }

    private void playSound(Context context, float speed) {
        String midMusicSourcePath = Utils.getMidMusicSourcePath(context);
        if (BassMusicPlay.getInstance().LoadSoundFont(midMusicSourcePath)) {
            if (this.currentStartPosition != 0L) {
                BassMusicPlay.getInstance().Seek(this.currentStartPosition);
            }
            BassMusicPlay.getInstance().setSpeed(speed);
            BassMusicPlay.getInstance().Play();
        }
    }

    public void playSound(int startPos, float speed, int hertz, PlayerListener.OnPreparedListener listener, PlayerListener.OnCompletionListener compleListener) {
        if (listener != null) {
            BassMusicPlay.getInstance().SetOnPreparedListener(listener);
        }
        if (compleListener != null) {
            BassMusicPlay.getInstance().SetOnCompletionListener(compleListener);
        }
        this.currentStartPosition = startPos;
        String midMusicSourcePath = Utils.getMidMusicSourcePath(this.mContext.getApplicationContext());
        if (BassMusicPlay.getInstance().LoadSoundFont(midMusicSourcePath)) {
            if (this.currentStartPosition >= 0L) {
                BassMusicPlay.getInstance().Seek(this.currentStartPosition);
            }
            for (int i = 0; i < this.tracks.size(); ++i) {
                BassMusicPlay.getInstance().setNoteFineTune(i, hertz);
            }
            BassMusicPlay.getInstance().setSpeed(speed);
            BassMusicPlay.getInstance().Play();
        }
    }
}

