/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.taobao.weex.R;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.LogLevel;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXSoInstallMgrSdk;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import dalvik.system.PathClassLoader;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.feature.uniapp.utils.AbsLogLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXEnvironment {
    public static final String OS = "android";
    public static String SYS_VERSION = Build.VERSION.RELEASE;
    public static final String SYS_MODEL;
    public static final String EAGLE = "eagle";
    public static final String ENVIRONMENT = "environment";
    public static final String WEEX_CURRENT_KEY = "wx_current_url";
    public static String JS_LIB_SDK_VERSION;
    public static String WXSDK_VERSION;
    public static Application sApplication;
    public static final String DEV_Id;
    @Deprecated
    public static int sDefaultWidth;
    public static volatile boolean JsFrameworkInit;
    public static final String SETTING_EXCLUDE_X86SUPPORT = "env_exclude_x86";
    public static boolean SETTING_FORCE_VERTICAL_SCREEN;
    public static boolean AUTO_ADJUST_ENV_DEVICE_WIDTH;
    public static boolean AUTO_UPDATE_APPLICATION_SCREEN_SIZE;
    public static volatile boolean sUseRunTimeApi;
    public static boolean sDebugMode;
    public static final boolean sForceEnableDevTool = true;
    public static String sDebugWsUrl;
    public static boolean sDebugServerConnectable;
    public static boolean sRemoteDebugMode;
    public static String sRemoteDebugProxyUrl;
    public static boolean sDebugNetworkEventReporterEnable;
    public static long sJSLibInitTime;
    public static long sSDKInitStart;
    public static long sSDKInitInvokeTime;
    public static long sSDKInitExecuteTime;
    public static long sSDKInitTime;
    public static long sJSFMStartListenerTime;
    public static volatile boolean isWsFixMode;
    public static long sComponentsAndModulesReadyTime;
    public static boolean sInAliWeex;
    public static AbsLogLevel sLogLevel;
    private static boolean isApkDebug;
    public static boolean isPerf;
    private static boolean sDebugFlagInit;
    private static boolean openDebugLog;
    private static String sGlobalFontFamily;
    public static final String CORE_SO_NAME = "weexcore";
    public static final String CORE_JSS_SO_NAME = "weexjss";
    public static final String CORE_JSB_SO_NAME = "weexjsb";
    public static final String CORE_JST_SO_NAME = "weexjst";
    public static final String CORE_JSC_SO_NAME = "jsc";
    private static String CORE_JSS_SO_PATH;
    public static String CORE_JSS_RUNTIME_SO_PATH;
    private static String CORE_JSS_ICU_PATH;
    private static String CORE_JSC_SO_PATH;
    public static String CORE_JSB_SO_PATH;
    private static String COPY_SO_DES_DIR;
    private static String LIB_LD_PATH;
    private static float mViewProt;
    private static Map<String, String> options;
    private static WXDefaultSettings mWXDefaultSettings;
    public static boolean sDynamicMode;
    public static String sDynamicUrl;

    public static float getViewProt() {
        return mViewProt;
    }

    public static void setViewProt(float mViewProt) {
        WXEnvironment.mViewProt = mViewProt;
    }

    public static synchronized WXDefaultSettings getWXDefaultSettings() {
        if (mWXDefaultSettings == null && WXEnvironment.getApplication() != null) {
            mWXDefaultSettings = new WXDefaultSettings(WXEnvironment.getApplication());
        }
        return mWXDefaultSettings;
    }

    public static synchronized String getDefaultSettingValue(String key, String defaultValue) {
        WXDefaultSettings wxDefaultSettings = WXEnvironment.getWXDefaultSettings();
        if (wxDefaultSettings == null || TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        return wxDefaultSettings.getValue(key, defaultValue);
    }

    public static synchronized void writeDefaultSettingsValue(String key, String value) {
        WXDefaultSettings wxDefaultSettings = WXEnvironment.getWXDefaultSettings();
        if (wxDefaultSettings == null || TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        wxDefaultSettings.saveValue(key, value);
    }

    public static Map<String, String> getConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("os", OS);
        configs.put("appVersion", WXEnvironment.getAppVersionName());
        configs.put("cacheDir", WXEnvironment.getAppCacheFile());
        configs.put("devId", DEV_Id);
        configs.put("sysVersion", SYS_VERSION);
        configs.put("sysModel", SYS_MODEL);
        configs.put("weexVersion", String.valueOf(WXSDK_VERSION));
        if (sRemoteDebugMode) {
            configs.put("logLevel", "log");
        } else {
            configs.put("logLevel", sLogLevel.getName());
        }
        try {
            configs.put("layoutDirection", WXEnvironment.isLayoutDirectionRTL() ? "rtl" : "ltr");
        }
        catch (Exception e) {
            configs.put("layoutDirection", "ltr");
        }
        try {
            if (WXEnvironment.isApkDebugable()) {
                WXEnvironment.addCustomOptions("debugMode", "true");
            }
            WXEnvironment.addCustomOptions("scale", Float.toString(WXEnvironment.sApplication.getResources().getDisplayMetrics().density));
            WXEnvironment.addCustomOptions("androidStatusBarHeight", Float.toString(WXViewUtils.getStatusBarHeight((Context)sApplication)));
        }
        catch (NullPointerException e) {
            WXLogUtils.e("WXEnvironment scale Exception: ", e);
        }
        configs.putAll(WXEnvironment.getCustomOptions());
        if (configs.get("appName") == null && sApplication != null) {
            configs.put("appName", sApplication.getPackageName());
        }
        return configs;
    }

    public static String getAppVersionName() {
        String versionName = "";
        PackageInfo info = null;
        try {
            PackageManager manager = sApplication.getPackageManager();
            info = manager.getPackageInfo(sApplication.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppVersionName Exception: ", e);
        }
        return versionName;
    }

    private static String getAppCacheFile() {
        String cache = "";
        try {
            cache = sApplication.getApplicationContext().getCacheDir().getPath();
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppCacheFile Exception: ", e);
        }
        return cache;
    }

    @Deprecated
    public static Map<String, String> getCustomOptions() {
        return options;
    }

    public static void addCustomOptions(String key, String value) {
        options.put(key, value);
    }

    public static String getCustomOptions(String key) {
        return options.get(key);
    }

    @SuppressLint(value={"SdCardPath"})
    public static String copySoDesDir() {
        try {
            if (TextUtils.isEmpty((CharSequence)COPY_SO_DES_DIR)) {
                if (sApplication == null) {
                    WXLogUtils.e("sApplication is null, so copy path will be null");
                    return null;
                }
                String dirName = "/cache/weex/libs";
                File desDir = null;
                String cachePath = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
                if (!TextUtils.isEmpty((CharSequence)cachePath)) {
                    desDir = new File(cachePath, dirName);
                } else {
                    String pkgName = sApplication.getPackageName();
                    String toPath = "/data/data/" + pkgName + dirName;
                    desDir = new File(toPath);
                }
                if (!desDir.exists()) {
                    desDir.mkdirs();
                }
                COPY_SO_DES_DIR = desDir.getAbsolutePath();
            }
        }
        catch (Throwable e) {
            WXLogUtils.e(WXLogUtils.getStackTrace(e));
        }
        return COPY_SO_DES_DIR;
    }

    @Deprecated
    public static boolean isSupport() {
        boolean isInitialized = WXSDKEngine.isInitialized();
        if (!isInitialized) {
            WXLogUtils.e("WXSDKEngine.isInitialized():" + isInitialized);
        }
        return WXEnvironment.isHardwareSupport() && isInitialized;
    }

    public static boolean isLayoutDirectionRTL() {
        if (Build.VERSION.SDK_INT >= 17) {
            return sApplication.getApplicationContext().getResources().getBoolean(R.bool.weex_is_right_to_left);
        }
        return false;
    }

    @Deprecated
    public static boolean isHardwareSupport() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("isTableDevice:" + WXUtils.isTabletDevice());
        }
        return WXEnvironment.isCPUSupport();
    }

    public static boolean isCPUSupport() {
        boolean isCPUSupport;
        boolean excludeX86 = "true".equals(WXEnvironment.getCustomOptions().get(SETTING_EXCLUDE_X86SUPPORT));
        boolean isX86AndExcluded = WXSoInstallMgrSdk.isX86() && excludeX86;
        boolean bl = isCPUSupport = WXSoInstallMgrSdk.isCPUSupport() && !isX86AndExcluded;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXEnvironment.sSupport:" + isCPUSupport + "isX86AndExclueded: " + isX86AndExcluded);
        }
        return isCPUSupport;
    }

    public static boolean isApkDebugable() {
        return WXEnvironment.isApkDebugable(sApplication);
    }

    public static boolean isApkDebugable(Application application) {
        if (application == null) {
            return false;
        }
        if (isPerf) {
            return false;
        }
        if (sDebugFlagInit) {
            return isApkDebug;
        }
        if (!isApkDebug && BaseInfo.SyncDebug) {
            isApkDebug = true;
        } else if (isApkDebug && !BaseInfo.SyncDebug) {
            isApkDebug = false;
        }
        sDebugFlagInit = true;
        return isApkDebug;
    }

    public static boolean isPerf() {
        return isPerf;
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getDevId() {
        String ret = "";
        if (sApplication != null) {
            try {
                ret = ((TelephonyManager)sApplication.getSystemService("phone")).getDeviceId();
            }
            catch (NullPointerException | SecurityException e) {
                WXLogUtils.e(WXLogUtils.getStackTrace(e));
            }
        }
        return ret;
    }

    public static Application getApplication() {
        return sApplication;
    }

    public void initMetrics() {
        if (sApplication == null) {
            return;
        }
    }

    public static String getDiskCacheDir(Context context) {
        if (context == null) {
            return null;
        }
        String cachePath = null;
        try {
            cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cachePath;
    }

    public static String getFilesDir(Context context) {
        if (context == null) {
            return "";
        }
        File filesDir = context.getFilesDir();
        String path = "";
        if (filesDir != null) {
            path = filesDir.getPath();
        } else {
            path = WXEnvironment.getApplication().getApplicationInfo().dataDir;
            path = path + File.separator;
            path = path + "files";
        }
        return path;
    }

    public static String getCrashFilePath(Context context) {
        if (context == null) {
            return "";
        }
        File dir = context.getDir("crash", 0);
        if (dir == null) {
            return "";
        }
        String crashDir = dir.getAbsolutePath();
        return crashDir;
    }

    public static String getGlobalFontFamilyName() {
        return sGlobalFontFamily;
    }

    public static void setGlobalFontFamily(String fontFamilyName, Typeface typeface) {
        WXLogUtils.d("GlobalFontFamily", "Set global font family: " + fontFamilyName);
        sGlobalFontFamily = fontFamilyName;
        if (!TextUtils.isEmpty((CharSequence)fontFamilyName)) {
            if (typeface == null) {
                TypefaceUtil.removeFontDO(fontFamilyName);
            } else {
                FontDO nativeFontDO = new FontDO(fontFamilyName, typeface);
                TypefaceUtil.putFontDO(nativeFontDO);
                WXLogUtils.d("TypefaceUtil", "Add new font: " + fontFamilyName);
            }
        }
    }

    public static boolean isOpenDebugLog() {
        return openDebugLog;
    }

    public static void setOpenDebugLog(boolean openDebugLog) {
        WXEnvironment.openDebugLog = openDebugLog;
    }

    public static void setApkDebugable(boolean debugable) {
        isApkDebug = debugable;
        if (!isApkDebug) {
            openDebugLog = false;
        }
    }

    public static String getCacheDir() {
        Application application = WXEnvironment.getApplication();
        if (application == null || application.getApplicationContext() == null) {
            return null;
        }
        return application.getApplicationContext().getCacheDir().getPath();
    }

    public static boolean extractSo() {
        File sourceFile;
        String[] splitSourceDirs;
        ArrayList<String> queryDirs = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 21 && null != (splitSourceDirs = WXEnvironment.getApplication().getApplicationContext().getApplicationInfo().splitSourceDirs)) {
            for (String item : splitSourceDirs) {
                if (item.contains(Build.CPU_ABI)) {
                    queryDirs.add(0, item);
                    continue;
                }
                queryDirs.add(item);
            }
        }
        if ((sourceFile = new File(WXEnvironment.getApplication().getApplicationContext().getApplicationInfo().sourceDir)).exists()) {
            queryDirs.add(sourceFile.getAbsolutePath());
        }
        String soDesPath = WXEnvironment.copySoDesDir();
        if (queryDirs.size() > 0 && !TextUtils.isEmpty((CharSequence)soDesPath)) {
            try {
                String item;
                Iterator iterator = queryDirs.iterator();
                while (iterator.hasNext() && !WXFileUtils.extractSo(item = (String)iterator.next(), soDesPath)) {
                }
            }
            catch (IOException e) {
                WXLogUtils.e("extractSo error " + e.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findIcuPath() {
        File file = new File("/proc/self/maps");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                if (!tempString.contains("icudt")) continue;
                int i = tempString.indexOf(47);
                String substring = tempString.substring(i);
                String string2 = substring.trim();
                return string2;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String findSoPath(String libName) {
        File soFile;
        String soPath = ((PathClassLoader)WXEnvironment.class.getClassLoader()).findLibrary(libName);
        if (!TextUtils.isEmpty((CharSequence)soPath)) {
            File soFile2 = new File(soPath);
            if (soFile2.exists()) {
                WXLogUtils.e(libName + "'s Path is" + soPath);
                return soFile2.getAbsolutePath();
            }
            WXLogUtils.e(libName + "'s Path is " + soPath + " but file does not exist");
        }
        String realName = "lib" + libName + ".so";
        String cacheDir = WXEnvironment.getCacheDir();
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            WXLogUtils.e("cache dir is null");
            return "";
        }
        if (cacheDir.indexOf("/cache") > 0) {
            soPath = new File(cacheDir.replace("/cache", "/lib"), realName).getAbsolutePath();
        }
        if ((soFile = new File(soPath)).exists()) {
            WXLogUtils.e(libName + "use lib so");
            return soPath;
        }
        String soDesPath = WXEnvironment.copySoDesDir();
        File soCopyFile = new File(soDesPath, realName);
        if (soCopyFile.exists()) {
            return soCopyFile.getAbsolutePath();
        }
        boolean success = WXEnvironment.extractSo();
        if (success) {
            return new File(WXEnvironment.getCacheDir(), realName).getAbsolutePath();
        }
        return soPath;
    }

    public static String getLibJScRealPath() {
        return "";
    }

    public static String getLibJssRealPath() {
        if (sUseRunTimeApi && !TextUtils.isEmpty((CharSequence)CORE_JSS_RUNTIME_SO_PATH)) {
            WXLogUtils.d("test-> findLibJssRuntimeRealPath " + CORE_JSS_RUNTIME_SO_PATH);
            return CORE_JSS_RUNTIME_SO_PATH;
        }
        if (TextUtils.isEmpty((CharSequence)CORE_JSS_SO_PATH)) {
            CORE_JSS_SO_PATH = WXEnvironment.findSoPath(CORE_JSS_SO_NAME);
            WXLogUtils.d("test-> findLibJssRealPath " + CORE_JSS_SO_PATH);
        }
        return CORE_JSS_SO_PATH;
    }

    public static String getLibJssIcuPath() {
        if (TextUtils.isEmpty((CharSequence)CORE_JSS_ICU_PATH)) {
            CORE_JSS_ICU_PATH = WXEnvironment.findIcuPath();
        }
        return CORE_JSS_ICU_PATH;
    }

    public static String getLibLdPath() {
        if (TextUtils.isEmpty((CharSequence)LIB_LD_PATH)) {
            ClassLoader classLoader = WXEnvironment.class.getClassLoader();
            try {
                Method getLdLibraryPath = classLoader.getClass().getMethod("getLdLibraryPath", new Class[0]);
                LIB_LD_PATH = (String)getLdLibraryPath.invoke((Object)classLoader, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)LIB_LD_PATH)) {
            try {
                String property = System.getProperty("java.library.path");
                String libJScRealPath = WXEnvironment.getLibJScRealPath();
                if (!TextUtils.isEmpty((CharSequence)libJScRealPath)) {
                    LIB_LD_PATH = new File(libJScRealPath).getParent() + ":" + property;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WXLogUtils.d("getLibLdPath is " + LIB_LD_PATH);
        return LIB_LD_PATH;
    }

    static {
        if (SYS_VERSION != null && SYS_VERSION.toUpperCase(Locale.ROOT).equals("P")) {
            SYS_VERSION = "9.0.0";
        }
        if (SYS_VERSION != null && SYS_VERSION.toUpperCase(Locale.ROOT).equals("Q")) {
            SYS_VERSION = "10.0.0";
        }
        SYS_MODEL = Build.MODEL;
        JS_LIB_SDK_VERSION = "0.29.6";
        WXSDK_VERSION = "0.28.0";
        DEV_Id = WXEnvironment.getDevId();
        sDefaultWidth = 750;
        JsFrameworkInit = false;
        SETTING_FORCE_VERTICAL_SCREEN = false;
        AUTO_ADJUST_ENV_DEVICE_WIDTH = true;
        AUTO_UPDATE_APPLICATION_SCREEN_SIZE = true;
        sUseRunTimeApi = false;
        sDebugMode = false;
        sDebugWsUrl = "";
        sDebugServerConnectable = false;
        sRemoteDebugMode = false;
        sRemoteDebugProxyUrl = "";
        sDebugNetworkEventReporterEnable = false;
        sJSLibInitTime = 0L;
        sSDKInitStart = 0L;
        sSDKInitInvokeTime = 0L;
        sSDKInitExecuteTime = 0L;
        sSDKInitTime = 0L;
        sJSFMStartListenerTime = 0L;
        isWsFixMode = true;
        sComponentsAndModulesReadyTime = 0L;
        sInAliWeex = false;
        sLogLevel = LogLevel.DEBUG;
        isApkDebug = true;
        isPerf = false;
        sDebugFlagInit = false;
        openDebugLog = true;
        CORE_JSS_SO_PATH = null;
        CORE_JSS_RUNTIME_SO_PATH = null;
        CORE_JSS_ICU_PATH = null;
        CORE_JSC_SO_PATH = null;
        CORE_JSB_SO_PATH = null;
        COPY_SO_DES_DIR = null;
        LIB_LD_PATH = null;
        mViewProt = 750.0f;
        options = new ConcurrentHashMap<String, String>();
        options.put("os", OS);
        options.put("osName", OS);
        sDynamicMode = false;
        sDynamicUrl = "";
    }

    public static class WXDefaultSettings {
        private String configName = "weex_default_settings";
        private SharedPreferences sharedPreferences = null;

        public WXDefaultSettings(Application application) {
            if (application != null) {
                this.sharedPreferences = application.getSharedPreferences(this.configName, 0);
            }
        }

        public synchronized String getValue(String key, String defaultValue) {
            if (this.sharedPreferences == null || TextUtils.isEmpty((CharSequence)key)) {
                WXLogUtils.i("get default settings " + key + " return default value :" + defaultValue);
                return defaultValue;
            }
            String result = this.sharedPreferences.getString(key, defaultValue);
            WXLogUtils.i("get default settings " + key + " : " + result);
            return result;
        }

        public synchronized void saveValue(String key, String value) {
            if (this.sharedPreferences == null || TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
                return;
            }
            WXLogUtils.i("save default settings " + key + ":" + value);
            SharedPreferences.Editor editor = this.sharedPreferences.edit();
            editor.putString(key, value);
            editor.apply();
        }
    }
}

