/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import com.cooleshow.ffmpegcmd.listener.OnHandleListener;
import com.cooleshow.ffmpegcmd.util.ThreadPoolUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@Keep
public class FFmpegCmd {
    private static final String TAG;
    private static final int RESULT_SUCCESS = 1;
    private static final int RESULT_ERROR = 0;
    private static OnHandleListener mProgressListener;
    private static final int STATE_INIT = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_FINISH = 2;
    private static final int STATE_ERROR = 3;

    public static void execute(final String[] commands, final OnHandleListener onHandleListener) {
        mProgressListener = onHandleListener;
        ThreadPoolUtil.INSTANCE.executeSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                if (onHandleListener != null) {
                    onHandleListener.onBegin();
                }
                int result = FFmpegCmd.handle(commands);
                if (onHandleListener != null) {
                    onHandleListener.onEnd(result, "");
                }
                mProgressListener = null;
            }
        });
    }

    public static int executeSync(String[] commands) {
        return FFmpegCmd.handle(commands);
    }

    public static void execute(final List<String[]> commands, final OnHandleListener onHandleListener) {
        mProgressListener = onHandleListener;
        ThreadPoolUtil.INSTANCE.executeSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                if (onHandleListener != null) {
                    onHandleListener.onBegin();
                }
                int result = 0;
                int count = 0;
                for (String[] command : commands) {
                    result = FFmpegCmd.handle(command);
                    Log.i((String)TAG, (String)(++count + " result=" + result));
                }
                if (onHandleListener != null) {
                    onHandleListener.onEnd(result, "");
                }
                mProgressListener = null;
            }
        });
    }

    @Keep
    public static void cancelTask(boolean cancel) {
        FFmpegCmd.cancelTaskJni(cancel ? 1 : 0);
    }

    @Keep
    public static void executeProbe(final String[] commands, final OnHandleListener onHandleListener) {
        ThreadPoolUtil.INSTANCE.executeSingleThreadPool(new Runnable(){

            @Override
            public void run() {
                String result;
                int resultCode;
                if (onHandleListener != null) {
                    onHandleListener.onBegin();
                }
                int n = resultCode = !TextUtils.isEmpty((CharSequence)(result = FFmpegCmd.handleProbe(commands))) ? 1 : 0;
                if (onHandleListener != null) {
                    onHandleListener.onEnd(resultCode, result);
                }
            }
        });
    }

    @Keep
    public static String executeProbeSynchronize(String[] commands) {
        return FFmpegCmd.handleProbe(commands);
    }

    private static native int handle(String[] var0);

    private static native void cancelTaskJni(int var0);

    private static native String handleProbe(String[] var0);

    @Keep
    public static void onProgressCallback(int position, int duration, int state) {
        Log.e((String)TAG, (String)("onProgress position=" + position + "--duration=" + duration + "--state=" + state));
        if (position > duration && duration > 0) {
            return;
        }
        if (mProgressListener != null) {
            if (position > 0 && duration > 0) {
                int progress = position * 100 / duration;
                if (progress <= 100) {
                    mProgressListener.onProgress(progress, duration);
                }
            } else {
                mProgressListener.onProgress(position, duration);
            }
        }
    }

    @Keep
    public static void setOnProgressCallback(OnHandleListener onProgressCallback) {
        mProgressListener = onProgressCallback;
    }

    @Keep
    public static void onMsgCallback(String msg, int level) {
        if (msg != null && !msg.isEmpty()) {
            Log.e((String)TAG, (String)("from native msg=" + msg));
            if (msg.startsWith("silence") && mProgressListener != null) {
                mProgressListener.onMsg(msg);
            }
        }
    }

    static {
        System.loadLibrary("media-handle");
        TAG = FFmpegCmd.class.getSimpleName();
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FFmpegState {
    }
}

