/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.stream.RCRTCCDNInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;

public class RCRTCCDNInputStreamImpl
extends RCInputStreamImpl
implements RCRTCCDNInputStream {
    private RCRTCVideoView mVideoView;
    private String mCDNServer;
    private boolean mMute = false;
    private static final String TAG = "RCRTCCDNInputStreamImpl";
    private RCRTCRoomType mRoomType = RCRTCRoomType.LIVE_AUDIO_VIDEO;
    private String mRoomId;
    private RCRTCParamsType.RCRTCVideoResolution mVideoResolution = null;
    private RCRTCParamsType.RCRTCVideoFps mFPS = null;
    private RCRTCParamsType.RCRTCVideoResolution mHighestResolution = null;
    private RCRTCParamsType.RCRTCVideoFps mHighestFPS = null;
    private String mCurrentPlaybackAddress = "";
    private boolean mPull_safe = false;
    private int mOriginalMaximumWidth = 0;
    private int mOriginalMaximumHeight = 0;
    private int mDesiredWidth = 0;
    private int mDesiredHeight = 0;
    private RCRTCParamsType.RCRTCVideoFps mDesiredFPS = null;

    public RCRTCCDNInputStreamImpl(String cdnServer, RCRTCRoomType roomType, String roomId, RCRTCParamsType.RCRTCVideoResolution highestResolution, RCRTCParamsType.RCRTCVideoFps highestFPS, boolean pull_safe, int originalMaximumWidth, int originalMaximumHeight) {
        super("", "RongCloudCDN", RCRTCMediaType.APPLICATION, roomId + "_CDN", "");
        this.mCDNServer = cdnServer;
        this.mRoomType = roomType;
        this.mRoomId = roomId;
        this.mHighestResolution = highestResolution;
        this.mHighestFPS = highestFPS;
        this.mPull_safe = pull_safe;
        this.mOriginalMaximumWidth = originalMaximumWidth;
        this.mOriginalMaximumHeight = originalMaximumHeight;
        FinLog.d(TAG, "cdnServer : " + cdnServer + " , pull_safe : " + pull_safe + " , originalMaximumWidth : " + originalMaximumWidth + " , originalMaximumHeight : " + originalMaximumHeight);
    }

    @Override
    public void setVideoView(RCRTCVideoView videoView) {
        this.mVideoView = videoView;
        if (this.mVideoView != null) {
            this.mVideoView.setDrawingMode(1);
        }
    }

    @Override
    public RCRTCVideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void setVideoConfig(RCRTCParamsType.RCRTCVideoResolution videoResolution, RCRTCParamsType.RCRTCVideoFps videoFps, final IRCRTCResultCallback callback) {
        ReportUtil.appTask(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "videoResolution|videoFps", new Object[]{videoResolution, videoFps});
        this.mVideoResolution = videoResolution;
        this.mFPS = videoFps;
        int tmpWidth = videoResolution == null ? 0 : videoResolution.getWidth();
        int tmpHeight = videoResolution == null ? 0 : videoResolution.getHeight();
        int tmpFPS = videoFps == null ? 0 : videoFps.getFps();
        this.mDesiredWidth = tmpWidth;
        this.mDesiredHeight = tmpHeight;
        this.mDesiredFPS = videoFps;
        RTCEngineImpl.getInstance().sendMessage(5043, tmpWidth, tmpHeight, tmpFPS, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "code", 0);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.CHANGE_CDN_VIDEO_SIZE, "code", errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(errorCode);
                }
            }
        });
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.mFPS;
    }

    @Override
    public RCRTCParamsType.RCRTCVideoResolution getVideoResolution() {
        return this.mVideoResolution;
    }

    @Override
    public RCRTCParamsType.RCRTCVideoResolution getHighestResolution() {
        return this.mHighestResolution;
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getHighestFPS() {
        return this.mHighestFPS;
    }

    public void setHighestResolution(RCRTCParamsType.RCRTCVideoResolution mHighestResolution) {
        this.mHighestResolution = mHighestResolution;
    }

    public void setHighestFPS(RCRTCParamsType.RCRTCVideoFps mHighestFPS) {
        this.mHighestFPS = mHighestFPS;
    }

    public void setOriginalMaximum(int width, int height) {
        this.mOriginalMaximumWidth = width;
        this.mOriginalMaximumHeight = height;
        FinLog.d(TAG, "setOriginalMaximum->Width : " + this.mOriginalMaximumWidth + " , Height : " + this.mOriginalMaximumHeight);
    }

    @Override
    public String getStreamId() {
        String streamId = this.mRoomId + "_CDN";
        return streamId;
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
    }

    @Override
    public MediaStreamTrack getTrack() {
        return null;
    }

    @Override
    public RCRTCMediaType getMediaType() {
        RCRTCMediaType mediaType = RCRTCMediaType.VIDEO;
        if (this.mRoomType == RCRTCRoomType.LIVE_AUDIO) {
            mediaType = RCRTCMediaType.AUDIO;
        } else if (this.mRoomType == RCRTCRoomType.LIVE_AUDIO_VIDEO) {
            mediaType = RCRTCMediaType.VIDEO;
        }
        return mediaType;
    }

    @Override
    public String getUri() {
        return "";
    }

    @Override
    public String getTag() {
        return "RongCloudCDN";
    }

    @Override
    public RCRTCResourceState getResourceState() {
        return RCRTCResourceState.NORMAL;
    }

    @Override
    public void mute(boolean mute) {
        this.mMute = mute;
        RTCEngineImpl.getInstance().sendMessage(5040, this.mMute, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.PLAYER_MUTE, "code", 0);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.PLAYER_MUTE, "code", errorCode.getValue());
            }
        });
    }

    @Override
    public boolean isMute() {
        return this.mMute;
    }

    public void setMute(boolean mMute) {
        this.mMute = mMute;
    }

    public String getCDNServer() {
        return this.mCDNServer;
    }

    public void setStreamConfig(RCRTCParamsType.RCRTCVideoResolution videoResolution, RCRTCParamsType.RCRTCVideoFps fps) {
        this.mVideoResolution = videoResolution;
        this.mFPS = fps;
    }

    public String getCurrentPlaybackAddress() {
        return this.mCurrentPlaybackAddress;
    }

    public void setCurrentPlaybackAddress(String mCurrentPlaybackAddress) {
        this.mCurrentPlaybackAddress = mCurrentPlaybackAddress;
    }

    public boolean isPull_safe() {
        return this.mPull_safe;
    }

    public int getOriginalMaximumWidth() {
        return this.mOriginalMaximumWidth;
    }

    public int getOriginalMaximumHeight() {
        return this.mOriginalMaximumHeight;
    }

    public int getDesiredWidth() {
        return this.mDesiredWidth;
    }

    public int getDesiredHeight() {
        return this.mDesiredHeight;
    }

    public RCRTCParamsType.RCRTCVideoFps getDesiredFPS() {
        return this.mDesiredFPS;
    }

    public void setDesiredVideoResolution(int desiredW, int desiredH, RCRTCParamsType.RCRTCVideoFps desiredFPS) {
        this.mDesiredWidth = desiredW;
        this.mDesiredHeight = desiredH;
        this.mDesiredFPS = desiredFPS;
    }
}

