/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.FileDownloadBroadcastHandler;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class DownloadStatusCallback
implements Handler.Callback {
    private final FileDownloadModel model;
    private final FileDownloadDatabase database;
    private final ProcessParams processParams;
    private final int maxRetryTimes;
    private static final int CALLBACK_SAFE_MIN_INTERVAL_BYTES = 1;
    private static final int CALLBACK_SAFE_MIN_INTERVAL_MILLIS = 5;
    private static final int NO_ANY_PROGRESS_CALLBACK = -1;
    private final int callbackProgressMinInterval;
    private final int callbackProgressMaxCount;
    private long callbackMinIntervalBytes;
    private Handler handler;
    private HandlerThread handlerThread;
    private volatile boolean handlingMessage = false;
    private volatile Thread parkThread;
    private volatile long lastCallbackTimestamp = 0L;
    private final AtomicLong callbackIncreaseBuffer = new AtomicLong();
    private final AtomicBoolean needCallbackProgressToUser = new AtomicBoolean(false);
    private static final String ALREADY_DEAD_MESSAGE = "require callback %d but the host thread of the flow has already dead, what is occurred because of there are several reason can final this flow on different thread.";
    private final AtomicBoolean needSetProcess = new AtomicBoolean(false);
    private final AtomicBoolean isFirstCallback = new AtomicBoolean(true);

    DownloadStatusCallback(FileDownloadModel model, int maxRetryTimes, int minIntervalMillis, int callbackProgressMaxCount) {
        this.model = model;
        this.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        this.callbackProgressMinInterval = minIntervalMillis < 5 ? 5 : minIntervalMillis;
        this.callbackProgressMaxCount = callbackProgressMaxCount;
        this.processParams = new ProcessParams();
        this.maxRetryTimes = maxRetryTimes;
    }

    public boolean isAlive() {
        return this.handlerThread != null && this.handlerThread.isAlive();
    }

    void discardAllMessage() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handlerThread.quit();
            this.parkThread = Thread.currentThread();
            while (this.handlingMessage) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
            this.parkThread = null;
        }
    }

    public void onPending() {
        this.model.setStatus((byte)1);
        this.database.updatePending(this.model.getId());
        this.onStatusChanged((byte)1);
    }

    void onStartThread() {
        this.model.setStatus((byte)6);
        this.onStatusChanged((byte)6);
        this.database.onTaskStart(this.model.getId());
    }

    void onConnected(boolean isResume, long totalLength, String etag, String fileName) throws IllegalArgumentException {
        String oldEtag = this.model.getETag();
        if (oldEtag != null && !oldEtag.equals(etag)) {
            throw new IllegalArgumentException(FileDownloadUtils.formatString("callback onConnected must with precondition succeed, but the etag is changes(%s != %s)", etag, oldEtag));
        }
        this.processParams.setResuming(isResume);
        this.model.setStatus((byte)2);
        this.model.setTotal(totalLength);
        this.model.setETag(etag);
        this.model.setFilename(fileName);
        this.database.updateConnected(this.model.getId(), totalLength, etag, fileName);
        this.onStatusChanged((byte)2);
        this.callbackMinIntervalBytes = DownloadStatusCallback.calculateCallbackMinIntervalBytes(totalLength, this.callbackProgressMaxCount);
        this.needSetProcess.compareAndSet(false, true);
    }

    void onMultiConnection() {
        this.handlerThread = new HandlerThread("source-status-callback");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper(), (Handler.Callback)this);
    }

    void onProgress(long increaseBytes) {
        this.callbackIncreaseBuffer.addAndGet(increaseBytes);
        this.model.increaseSoFar(increaseBytes);
        long now = SystemClock.elapsedRealtime();
        this.inspectNeedCallbackToUser(now);
        if (this.handler == null) {
            this.handleProgress();
        } else if (this.needCallbackProgressToUser.get()) {
            this.sendMessage(this.handler.obtainMessage(3));
        }
    }

    void onRetry(Exception exception, int remainRetryTimes) {
        this.callbackIncreaseBuffer.set(0L);
        if (this.handler == null) {
            this.handleRetry(exception, remainRetryTimes);
        } else {
            this.sendMessage(this.handler.obtainMessage(5, remainRetryTimes, 0, (Object)exception));
        }
    }

    void onPausedDirectly() {
        this.handlePaused();
    }

    void onErrorDirectly(Exception exception) {
        this.handleError(exception);
    }

    void onCompletedDirectly() throws IOException {
        if (this.interceptBeforeCompleted()) {
            return;
        }
        this.handleCompleted();
    }

    private synchronized void sendMessage(Message message) {
        if (!this.handlerThread.isAlive()) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, ALREADY_DEAD_MESSAGE, message.what);
            }
            return;
        }
        try {
            this.handler.sendMessage(message);
        }
        catch (IllegalStateException e) {
            if (!this.handlerThread.isAlive()) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, ALREADY_DEAD_MESSAGE, message.what);
                }
            }
            throw e;
        }
    }

    private static long calculateCallbackMinIntervalBytes(long contentLength, long callbackProgressMaxCount) {
        if (callbackProgressMaxCount <= 0L) {
            return -1L;
        }
        if (contentLength == -1L) {
            return 1L;
        }
        long minIntervalBytes = contentLength / callbackProgressMaxCount;
        return minIntervalBytes <= 0L ? 1L : minIntervalBytes;
    }

    private Exception exFiltrate(Exception ex) {
        long freeSpaceBytes;
        String tempPath = this.model.getTempFilePath();
        if ((this.model.isChunked() || FileDownloadProperties.getImpl().fileNonPreAllocation) && ex instanceof IOException && new File(tempPath).exists() && (freeSpaceBytes = FileDownloadUtils.getFreeSpaceBytes(tempPath)) <= 4096L) {
            long downloadedSize = 0L;
            File file = new File(tempPath);
            if (!file.exists()) {
                FileDownloadLog.e((Object)this, ex, "Exception with: free space isn't enough, and the target file not exist.", new Object[0]);
            } else {
                downloadedSize = file.length();
            }
            ex = Build.VERSION.SDK_INT >= 9 ? new FileDownloadOutOfSpaceException(freeSpaceBytes, 4096L, downloadedSize, ex) : new FileDownloadOutOfSpaceException(freeSpaceBytes, 4096L, downloadedSize);
        }
        return ex;
    }

    private void handleSQLiteFullException(SQLiteFullException sqLiteFullException) {
        int id = this.model.getId();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "the data of the task[%d] is dirty, because the SQLite full exception[%s], so remove it from the database directly.", id, sqLiteFullException.toString());
        }
        this.model.setErrMsg(sqLiteFullException.toString());
        this.model.setStatus((byte)-1);
        this.database.remove(id);
        this.database.removeConnections(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTempFile() throws IOException {
        String tempPath = this.model.getTempFilePath();
        String targetPath = this.model.getTargetFilePath();
        File tempFile = new File(tempPath);
        boolean renameFailed = true;
        try {
            File targetFile = new File(targetPath);
            if (targetFile.exists()) {
                long oldTargetFileLength = targetFile.length();
                if (!targetFile.delete()) {
                    throw new IOException(FileDownloadUtils.formatString("Can't delete the old file([%s], [%d]), so can't replace it with the new downloaded one.", targetPath, oldTargetFileLength));
                }
                FileDownloadLog.w(this, "The target file([%s], [%d]) will be replaced with the new downloaded file[%d]", targetPath, oldTargetFileLength, tempFile.length());
            }
            if (tempFile.renameTo(targetFile)) return;
            boolean bl = true;
            renameFailed = bl;
            if (renameFailed) {
                throw new IOException(FileDownloadUtils.formatString("Can't rename the  temp downloaded file(%s) to the target file(%s)", tempPath, targetPath));
            }
            if (!renameFailed) return;
            if (!tempFile.exists()) return;
            if (tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (!renameFailed) throw throwable;
            if (!tempFile.exists()) throw throwable;
            if (tempFile.delete()) throw throwable;
            FileDownloadLog.w(this, "delete the temp file(%s) failed, on completed downloading.", tempPath);
            throw throwable;
        }
        FileDownloadLog.w(this, "delete the temp file(%s) failed, on completed downloading.", tempPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message msg) {
        this.handlingMessage = true;
        int status = msg.what;
        try {
            switch (status) {
                case 3: {
                    this.handleProgress();
                    return true;
                }
                case 5: {
                    this.handleRetry((Exception)msg.obj, msg.arg1);
                    return true;
                }
            }
            return true;
        }
        finally {
            this.handlingMessage = false;
            if (this.parkThread != null) {
                LockSupport.unpark(this.parkThread);
            }
        }
    }

    private void handleProgress() {
        if (this.model.getSoFar() == this.model.getTotal()) {
            this.database.updateProgress(this.model.getId(), this.model.getSoFar());
            return;
        }
        if (this.needSetProcess.compareAndSet(true, false)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.i(this, "handleProgress update model's status with progress", new Object[0]);
            }
            this.model.setStatus((byte)3);
        }
        if (this.needCallbackProgressToUser.compareAndSet(true, false)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.i(this, "handleProgress notify user progress status", new Object[0]);
            }
            this.onStatusChanged((byte)3);
        }
    }

    private void handleCompleted() throws IOException {
        this.renameTempFile();
        this.model.setStatus((byte)-3);
        this.database.updateCompleted(this.model.getId(), this.model.getTotal());
        this.database.removeConnections(this.model.getId());
        this.onStatusChanged((byte)-3);
        if (FileDownloadProperties.getImpl().broadcastCompleted) {
            FileDownloadBroadcastHandler.sendCompletedBroadcast(this.model);
        }
    }

    private boolean interceptBeforeCompleted() {
        if (this.model.isChunked()) {
            this.model.setTotal(this.model.getSoFar());
        } else if (this.model.getSoFar() != this.model.getTotal()) {
            this.onErrorDirectly(new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("sofar[%d] not equal total[%d]", this.model.getSoFar(), this.model.getTotal())));
            return true;
        }
        return false;
    }

    private void handleRetry(Exception exception, int remainRetryTimes) {
        Exception processEx = this.exFiltrate(exception);
        this.processParams.setException(processEx);
        this.processParams.setRetryingTimes(this.maxRetryTimes - remainRetryTimes);
        this.model.setStatus((byte)5);
        this.model.setErrMsg(processEx.toString());
        this.database.updateRetry(this.model.getId(), processEx);
        this.onStatusChanged((byte)5);
    }

    private void handlePaused() {
        this.model.setStatus((byte)-2);
        this.database.updatePause(this.model.getId(), this.model.getSoFar());
        this.onStatusChanged((byte)-2);
    }

    private void handleError(Exception exception) {
        Throwable errProcessEx = this.exFiltrate(exception);
        if (errProcessEx instanceof SQLiteFullException) {
            this.handleSQLiteFullException((SQLiteFullException)errProcessEx);
        } else {
            try {
                this.model.setStatus((byte)-1);
                this.model.setErrMsg(exception.toString());
                this.database.updateError(this.model.getId(), errProcessEx, this.model.getSoFar());
            }
            catch (SQLiteFullException fullException) {
                errProcessEx = fullException;
                this.handleSQLiteFullException((SQLiteFullException)errProcessEx);
            }
        }
        this.processParams.setException((Exception)errProcessEx);
        this.onStatusChanged((byte)-1);
    }

    private void inspectNeedCallbackToUser(long now) {
        boolean needCallback;
        if (this.isFirstCallback.compareAndSet(true, false)) {
            needCallback = true;
        } else {
            long callbackTimeDelta = now - this.lastCallbackTimestamp;
            boolean bl = needCallback = this.callbackMinIntervalBytes != -1L && this.callbackIncreaseBuffer.get() >= this.callbackMinIntervalBytes && callbackTimeDelta >= (long)this.callbackProgressMinInterval;
        }
        if (needCallback && this.needCallbackProgressToUser.compareAndSet(false, true)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.i(this, "inspectNeedCallbackToUser need callback to user", new Object[0]);
            }
            this.lastCallbackTimestamp = now;
            this.callbackIncreaseBuffer.set(0L);
        }
    }

    private void onStatusChanged(byte status) {
        if (status == -2) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "High concurrent cause, Already paused and we don't need to call-back to Task in here, %d", this.model.getId());
            }
            return;
        }
        MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.take(status, this.model, this.processParams));
    }

    public static class ProcessParams {
        private boolean isResuming;
        private Exception exception;
        private int retryingTimes;

        void setResuming(boolean isResuming) {
            this.isResuming = isResuming;
        }

        public boolean isResuming() {
            return this.isResuming;
        }

        void setException(Exception exception) {
            this.exception = exception;
        }

        void setRetryingTimes(int retryingTimes) {
            this.retryingTimes = retryingTimes;
        }

        public Exception getException() {
            return this.exception;
        }

        public int getRetryingTimes() {
            return this.retryingTimes;
        }
    }
}

