/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.tools;

import android.text.TextUtils;
import android.util.Log;
import com.cooleshow.ffmpegcmd.model.AudioBean;
import com.cooleshow.ffmpegcmd.model.MediaBean;
import com.cooleshow.ffmpegcmd.model.VideoBean;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/cooleshow/ffmpegcmd/tools/JsonParseTool;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "TYPE_AUDIO", "TYPE_VIDEO", "parseMediaFormat", "Lcom/cooleshow/ffmpegcmd/model/MediaBean;", "mediaFormat", "parseTag", "", "audioTag", "Lorg/json/JSONObject;", "audioBean", "Lcom/cooleshow/ffmpegcmd/model/AudioBean;", "stringFormat", "mediaBean", "ffmpegCmd_release"})
public final class JsonParseTool {
    @NotNull
    public static final JsonParseTool INSTANCE = new JsonParseTool();
    private static final String TAG = JsonParseTool.class.getSimpleName();
    @NotNull
    private static final String TYPE_VIDEO = "video";
    @NotNull
    private static final String TYPE_AUDIO = "audio";

    private JsonParseTool() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MediaBean parseMediaFormat(@Nullable String mediaFormat) {
        if (mediaFormat == null || ((CharSequence)mediaFormat).length() == 0) {
            return null;
        }
        MediaBean mediaBean = null;
        try {
            JSONObject jsonMedia = new JSONObject(mediaFormat);
            JSONObject jsonMediaFormat = jsonMedia.getJSONObject("format");
            mediaBean = new MediaBean();
            int streamNum = jsonMediaFormat.optInt("nb_streams");
            mediaBean.setStreamNum(streamNum);
            Log.e((String)TAG, (String)("streamNum=" + streamNum));
            String formatName = jsonMediaFormat.optString("format_name");
            mediaBean.setFormatName(formatName);
            Log.e((String)TAG, (String)("formatName=" + formatName));
            String bitRateStr = jsonMediaFormat.optString("bit_rate");
            if (!TextUtils.isEmpty((CharSequence)bitRateStr)) {
                Integer n = Integer.valueOf(bitRateStr);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(bitRateStr)");
                mediaBean.setBitRate(((Number)n).intValue());
            }
            Log.e((String)TAG, (String)("bitRate=" + bitRateStr));
            String sizeStr = jsonMediaFormat.optString("size");
            if (!TextUtils.isEmpty((CharSequence)sizeStr)) {
                Long l = Long.valueOf(sizeStr);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(sizeStr)");
                mediaBean.setSize(((Number)l).longValue());
            }
            Log.e((String)TAG, (String)("size=" + sizeStr));
            String durationStr = jsonMediaFormat.optString("duration");
            if (!TextUtils.isEmpty((CharSequence)durationStr)) {
                Float duration = Float.valueOf(durationStr);
                mediaBean.setDuration((long)duration.floatValue());
            }
            JSONArray jSONArray = jsonMedia.getJSONArray("streams");
            if (jSONArray == null) {
                return mediaBean;
            }
            JSONArray jsonMediaStream = jSONArray;
            int n = jsonMediaStream.length();
            for (int index = 0; index < n; ++index) {
                String codecName;
                String codecType;
                JSONObject jsonMediaStreamItem;
                if (jsonMediaStream.optJSONObject(index) == null || jsonMediaStreamItem.optString("codec_type") == null) continue;
                if (Intrinsics.areEqual((Object)codecType, (Object)TYPE_VIDEO)) {
                    String[] frameRateArray;
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    VideoBean videoBean = new VideoBean();
                    mediaBean.setVideoBean(videoBean);
                    codecName = jsonMediaStreamItem.optString("codec_tag_string");
                    videoBean.setVideoCodec(codecName);
                    Log.e((String)TAG, (String)("codecName=" + codecName));
                    int width = jsonMediaStreamItem.optInt("width");
                    videoBean.setWidth(width);
                    int height = jsonMediaStreamItem.optInt("height");
                    videoBean.setHeight(height);
                    Log.e((String)TAG, (String)("width=" + width + "--height=" + height));
                    String aspectRatio = jsonMediaStreamItem.optString("display_aspect_ratio");
                    videoBean.setDisplayAspectRatio(aspectRatio);
                    Log.e((String)TAG, (String)("aspectRatio=" + aspectRatio));
                    String pixelFormat = jsonMediaStreamItem.optString("pix_fmt");
                    videoBean.setPixelFormat(pixelFormat);
                    Log.e((String)TAG, (String)("pixelFormat=" + pixelFormat));
                    String profile = jsonMediaStreamItem.optString("profile");
                    videoBean.setProfile(profile);
                    int level = jsonMediaStreamItem.optInt("level");
                    videoBean.setLevel(level);
                    Log.e((String)TAG, (String)("profile=" + profile + "--level=" + level));
                    String frameRateStr = jsonMediaStreamItem.optString("r_frame_rate");
                    if (TextUtils.isEmpty((CharSequence)frameRateStr)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)frameRateStr, (String)"frameRateStr");
                    Object object = frameRateStr;
                    Regex regex = new Regex("/");
                    int n2 = 0;
                    object = regex.split((CharSequence)object, n2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    Intrinsics.checkNotNull((Object)thisCollection$iv.toArray(new String[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    double d = Double.valueOf(frameRateArray[0]);
                    Double d2 = Double.valueOf(frameRateArray[1]);
                    Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"valueOf(frameRateArray[1])");
                    double frameRate = Math.ceil(d / ((Number)d2).doubleValue());
                    Log.e((String)TAG, (String)("frameRate=" + (int)frameRate));
                    videoBean.setFrameRate((int)frameRate);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)codecType, (Object)TYPE_AUDIO)) continue;
                AudioBean audioBean = new AudioBean();
                mediaBean.setAudioBean(audioBean);
                codecName = jsonMediaStreamItem.optString("codec_tag_string");
                audioBean.setAudioCodec(codecName);
                Log.e((String)TAG, (String)("codecName=" + codecName));
                String sampleRateStr = jsonMediaStreamItem.optString("sample_rate");
                if (!TextUtils.isEmpty((CharSequence)sampleRateStr)) {
                    Integer n3 = Integer.valueOf(sampleRateStr);
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"valueOf(sampleRateStr)");
                    audioBean.setSampleRate(((Number)n3).intValue());
                }
                Log.e((String)TAG, (String)("sampleRate=" + sampleRateStr));
                int channels = jsonMediaStreamItem.optInt("channels");
                audioBean.setChannels(channels);
                Log.e((String)TAG, (String)("channels=" + channels));
                String channelLayout = jsonMediaStreamItem.optString("channel_layout");
                audioBean.setChannelLayout(channelLayout);
                Log.e((String)TAG, (String)("channelLayout=" + channelLayout));
                JSONObject audioTag = jsonMediaFormat.getJSONObject("tags");
                if (audioTag == null) continue;
                this.parseTag(audioTag, audioBean);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("parse error=" + e));
        }
        return mediaBean;
    }

    @Nullable
    public final String stringFormat(@Nullable MediaBean mediaBean) {
        if (mediaBean == null) {
            return null;
        }
        StringBuilder formatBuilder = new StringBuilder();
        formatBuilder.append("duration:").append(mediaBean.getDuration()).append("\n");
        formatBuilder.append("size:").append(mediaBean.getSize()).append("\n");
        formatBuilder.append("bitRate:").append(mediaBean.getBitRate()).append("\n");
        formatBuilder.append("formatName:").append(mediaBean.getFormatName()).append("\n");
        formatBuilder.append("streamNum:").append(mediaBean.getStreamNum()).append("\n");
        if (mediaBean.getVideoBean() != null) {
            VideoBean videoBean = mediaBean.getVideoBean();
            StringBuilder stringBuilder = formatBuilder.append("width:");
            VideoBean videoBean2 = videoBean;
            Intrinsics.checkNotNull((Object)videoBean2);
            stringBuilder.append(videoBean2.getWidth()).append("\n");
            formatBuilder.append("height:").append(videoBean.getHeight()).append("\n");
            if (!TextUtils.isEmpty((CharSequence)videoBean.getDisplayAspectRatio())) {
                formatBuilder.append("aspectRatio:").append(videoBean.getDisplayAspectRatio()).append("\n");
            }
            formatBuilder.append("pixelFormat:").append(videoBean.getPixelFormat()).append("\n");
            formatBuilder.append("frameRate:").append(videoBean.getFrameRate()).append("\n");
            if (videoBean.getVideoCodec() != null) {
                formatBuilder.append("videoCodec:").append(videoBean.getVideoCodec()).append("\n");
            }
        }
        if (mediaBean.getAudioBean() != null) {
            AudioBean audioBean = mediaBean.getAudioBean();
            StringBuilder stringBuilder = formatBuilder.append("sampleRate:");
            AudioBean audioBean2 = audioBean;
            Intrinsics.checkNotNull((Object)audioBean2);
            stringBuilder.append(audioBean2.getSampleRate()).append("\n");
            formatBuilder.append("channels:").append(audioBean.getChannels()).append("\n");
            formatBuilder.append("channelLayout:").append(audioBean.getChannelLayout()).append("\n");
            if (audioBean.getAudioCodec() != null) {
                formatBuilder.append("audioCodec:").append(audioBean.getAudioCodec()).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)audioBean.getTitle())) {
                formatBuilder.append("title:").append(audioBean.getTitle()).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)audioBean.getArtist())) {
                formatBuilder.append("artist:").append(audioBean.getArtist()).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)audioBean.getAlbum())) {
                formatBuilder.append("album:").append(audioBean.getAlbum()).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)audioBean.getComposer())) {
                formatBuilder.append("composer:").append(audioBean.getComposer()).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)audioBean.getGenre())) {
                formatBuilder.append("genre:").append(audioBean.getGenre()).append("\n");
            }
        }
        return formatBuilder.toString();
    }

    private final void parseTag(JSONObject audioTag, AudioBean audioBean) {
        String title = audioTag.optString("title");
        audioBean.setTitle(title);
        Log.e((String)TAG, (String)("title=" + title));
        String artist = audioTag.optString("artist");
        audioBean.setArtist(artist);
        String album = audioTag.optString("album");
        audioBean.setAlbum(album);
        String albumArtist = audioTag.optString("album_artist");
        audioBean.setAlbumArtist(albumArtist);
        String composer = audioTag.optString("composer");
        audioBean.setComposer(composer);
        String genre = audioTag.optString("genre");
        audioBean.setGenre(genre);
        String lyrics = audioTag.optString("lyrics-eng");
        if (lyrics != null && StringsKt.contains$default((CharSequence)lyrics, (CharSequence)"\r\n", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"\r\n"};
            List array = StringsKt.split$default((CharSequence)lyrics, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            audioBean.setLyrics(array);
        }
    }
}

