/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview.adapter;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXHeader;
import java.lang.ref.WeakReference;

public class ListBaseViewHolder
extends RecyclerView.ViewHolder {
    private int mViewType;
    private boolean isRecycled;
    private WeakReference<WXComponent> mComponent;

    public ListBaseViewHolder(WXComponent component, int viewType) {
        super(component.getHostView());
        this.mViewType = viewType;
        this.mComponent = new WeakReference<WXComponent>(component);
        this.isRecycled = component.canRecycled();
    }

    public ListBaseViewHolder(WXComponent component, int viewType, boolean forceBindData) {
        this(component, viewType);
        this.isRecycled = this.isRecycled || forceBindData;
    }

    public ListBaseViewHolder(View view, int viewType) {
        super(view);
        this.mViewType = viewType;
    }

    public boolean isRecycled() {
        return this.isRecycled;
    }

    public void recycled() {
        if (this.mComponent != null && this.mComponent.get() != null) {
            ((WXComponent)this.mComponent.get()).recycled();
            this.isRecycled = true;
        }
    }

    public void bindData(WXComponent component) {
        if (this.mComponent != null && this.mComponent.get() != null) {
            ((WXComponent)this.mComponent.get()).bindData(component);
            this.isRecycled = false;
        }
    }

    public boolean isFullSpan() {
        return this.mComponent != null && this.mComponent.get() instanceof WXHeader;
    }

    public boolean canRecycled() {
        if (this.mComponent != null && this.mComponent.get() != null) {
            return ((WXComponent)this.mComponent.get()).canRecycled();
        }
        return true;
    }

    public View getView() {
        return this.itemView;
    }

    public int getViewType() {
        return this.mViewType;
    }

    public void setComponentUsing(boolean using) {
        if (this.mComponent != null && this.mComponent.get() != null) {
            ((WXComponent)this.mComponent.get()).setUsing(using);
        }
    }

    public WXComponent getComponent() {
        return this.mComponent != null ? (WXComponent)this.mComponent.get() : null;
    }
}

