/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class TopLeftCorner
extends BorderCorner {
    TopLeftCorner() {
    }

    void set(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        this.set(cornerRadius, preBorderWidth, postBorderWidth, borderBox, 225.0f);
    }

    @Override
    protected void prepareOval() {
        if (this.hasInnerCorner()) {
            this.setOvalLeft(this.getPreBorderWidth() / 2.0f);
            this.setOvalTop(this.getPostBorderWidth() / 2.0f);
            this.setOvalRight(2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f);
            this.setOvalBottom(2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f);
        } else {
            this.setOvalLeft(this.getOuterCornerRadius() / 2.0f);
            this.setOvalTop(this.getOuterCornerRadius() / 2.0f);
            this.setOvalRight(this.getOuterCornerRadius() * 1.5f);
            this.setOvalBottom(this.getOuterCornerRadius() * 1.5f);
        }
    }

    @Override
    protected void prepareRoundCorner() {
        if (this.hasOuterCorner()) {
            this.setRoundCornerStartX(this.getPreBorderWidth() / 2.0f);
            this.setRoundCornerStartY(this.getOuterCornerRadius());
            this.setRoundCornerEndX(this.getOuterCornerRadius());
            this.setRoundCornerEndY(this.getPostBorderWidth() / 2.0f);
        } else {
            float x = this.getPreBorderWidth() / 2.0f;
            float y = this.getPostBorderWidth() / 2.0f;
            this.setRoundCornerStartX(x);
            this.setRoundCornerStartY(y);
            this.setRoundCornerEndX(x);
            this.setRoundCornerEndY(y);
        }
    }
}

